/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CTCGreedyDecoder
extends PrimitiveOp {
    private Output<Long> decodedIndices;
    private Output<Long> decodedValues;
    private Output<Long> decodedShape;
    private Output<Float> logProbability;

    public static CTCGreedyDecoder create(Scope scope, Operand<Float> inputs, Operand<Integer> sequenceLength, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("CTCGreedyDecoder", scope.makeOpName("CTCGreedyDecoder"));
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(sequenceLength.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.mergeRepeated == null) continue;
                opBuilder.setAttr("merge_repeated", opts.mergeRepeated);
            }
        }
        return new CTCGreedyDecoder(opBuilder.build());
    }

    public static Options mergeRepeated(Boolean mergeRepeated) {
        return new Options().mergeRepeated(mergeRepeated);
    }

    public Output<Long> decodedIndices() {
        return this.decodedIndices;
    }

    public Output<Long> decodedValues() {
        return this.decodedValues;
    }

    public Output<Long> decodedShape() {
        return this.decodedShape;
    }

    public Output<Float> logProbability() {
        return this.logProbability;
    }

    private CTCGreedyDecoder(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.decodedIndices = operation.output(outputIdx++);
        this.decodedValues = operation.output(outputIdx++);
        this.decodedShape = operation.output(outputIdx++);
        this.logProbability = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean mergeRepeated;

        public Options mergeRepeated(Boolean mergeRepeated) {
            this.mergeRepeated = mergeRepeated;
            return this;
        }

        private Options() {
        }
    }
}

