/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FusedPadConv2D<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> FusedPadConv2D<T> create(Scope scope, Operand<T> input, Operand<Integer> paddings, Operand<T> filter, String mode, List<Long> strides, String padding) {
        OperationBuilder opBuilder = scope.graph().opBuilder("FusedPadConv2D", scope.makeOpName("FusedPadConv2D"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(paddings.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.setAttr("mode", mode);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        return new FusedPadConv2D<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private FusedPadConv2D(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }
}

