/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.zip.CRC32;
import org.telegram.bot.services.BotLogger;
import org.telegram.tl.StreamingUtils;

class SafeFileWriter {
    private static final String LOGTAG = "SAFEFILEWRITER";
    private final Random random = new Random();
    private final String fileName;

    public SafeFileWriter(String fileName) {
        this.fileName = fileName;
        String TAG = "SafeFileWriter#" + this.hashCode();
    }

    private File getFile() {
        return new File(this.fileName);
    }

    private File getTempFile() {
        return new File("random_" + this.random.nextLong() + ".tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveData(byte[] data) {
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            StreamingUtils.writeInt(data.length, os);
            StreamingUtils.writeByteArray(data, os);
            CRC32 crc32 = new CRC32();
            crc32.update(data);
            StreamingUtils.writeLong(crc32.getValue(), os);
            os.flush();
            os.getFD().sync();
            os.close();
            os = null;
            file.renameTo(this.getFile());
        }
        catch (IOException e) {
            BotLogger.error(LOGTAG, e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    BotLogger.error(LOGTAG, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] loadData() {
        File file = this.getFile();
        if (!file.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            int len = StreamingUtils.readInt(is);
            byte[] res = StreamingUtils.readBytes(len, is);
            CRC32 crc32 = new CRC32();
            crc32.update(res);
            long crc = StreamingUtils.readLong(is);
            if (crc32.getValue() != crc) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = res;
            return byArray;
        }
        catch (IOException e) {
            BotLogger.error(LOGTAG, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    BotLogger.error(LOGTAG, e);
                }
            }
        }
        return null;
    }
}

