/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel.differenceparameters;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.telegram.bot.kernel.database.DatabaseManager;
import org.telegram.bot.kernel.differenceparameters.IDifferenceParametersService;

public class DifferenceParametersService
implements IDifferenceParametersService {
    private static final ConcurrentHashMap<Integer, DifferenceData> differenceDatas = new ConcurrentHashMap();
    private static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final Object lock = new Object();
    private final DatabaseManager databaseManager;

    public DifferenceParametersService(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
        if (!loaded.get()) {
            this.loadParamsFromDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNewUpdateParams(int chatId, @Nullable Integer newPts, @Nullable Integer newSeq, @NotNull Integer newDate) {
        if (!differenceDatas.containsKey(chatId)) {
            this.create(chatId);
        }
        Object object = lock;
        synchronized (object) {
            DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).pts = newPts == null || newPts == 0 ? DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).pts : newPts;
            DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).seq = newSeq == null || newSeq == 0 ? DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).seq : newSeq;
            DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).date = newDate < DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).date ? DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).date : newDate;
            this.databaseManager.updateDifferencesData(chatId, DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).pts, DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).date, DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).seq);
        }
    }

    @Override
    public int getDate(int chatId) {
        if (!differenceDatas.containsKey(chatId)) {
            this.create(chatId);
        }
        return DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).date;
    }

    @Override
    public int getPts(int chatId) {
        if (!differenceDatas.containsKey(chatId)) {
            this.create(chatId);
        }
        return DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).pts;
    }

    @Override
    public int getSeq(int chatId) {
        if (!differenceDatas.containsKey(chatId)) {
            this.create(chatId);
        }
        return DifferenceParametersService.differenceDatas.get((Object)Integer.valueOf((int)chatId)).seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mustGetDifferences(int chatId, int pts, @Nullable Integer ptsCount, int seq, @Nullable Integer seqStart) {
        Object object = lock;
        synchronized (object) {
            boolean mustGetDifferences = false;
            if (pts > 0) {
                int newPts = this.getPts(chatId) + (ptsCount == null ? 0 : ptsCount);
                if (newPts != pts) {
                    mustGetDifferences = true;
                }
            } else if (seq > 0) {
                int newSeqStart;
                int n = newSeqStart = seqStart == null ? seq : seqStart;
                if (newSeqStart != this.getSeq(chatId) + 1 && newSeqStart > this.getSeq(chatId)) {
                    mustGetDifferences = true;
                }
            }
            return mustGetDifferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadParamsFromDatabase() {
        Object object = lock;
        synchronized (object) {
            Map<Integer, int[]> differencesDatas = this.databaseManager.getDifferencesData();
            for (Map.Entry<Integer, int[]> entry : differencesDatas.entrySet()) {
                DifferenceData data = new DifferenceData();
                data.pts = entry.getValue()[0];
                data.date = entry.getValue()[1];
                data.seq = entry.getValue()[2];
                differenceDatas.put(entry.getKey(), data);
            }
            loaded.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(int chatId) {
        Object object = lock;
        synchronized (object) {
            if (!differenceDatas.containsKey(chatId)) {
                differenceDatas.put(chatId, new DifferenceData());
                this.databaseManager.updateDifferencesData(chatId, 0, 0, 0);
            }
        }
    }

    private class DifferenceData {
        int pts = 0;
        int date = 0;
        int seq = 0;

        DifferenceData() {
        }
    }
}

