/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.phone;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;

public class TLPhoneCallProtocol
extends TLObject {
    public static final int CLASS_ID = -1564789301;
    private static final int FLAG_DP_P2P = 1;
    private static final int FLAG_UDP_REFLECTOR = 2;
    private int flags;
    private int minLayer;
    private int maxLayer;

    public int getFlags() {
        return this.flags;
    }

    public int getMinLayer() {
        return this.minLayer;
    }

    public int getMaxLayer() {
        return this.maxLayer;
    }

    public boolean isDpP2p() {
        return (this.flags & 1) != 0;
    }

    public boolean isUdpReflector() {
        return (this.flags & 2) != 0;
    }

    public void setMinLayer(int minLayer) {
        this.minLayer = minLayer;
    }

    public void setMaxLayer(int maxLayer) {
        this.maxLayer = maxLayer;
    }

    public void setDpP2p(boolean enabled) {
        this.flags = enabled ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setUdpReflector(boolean enabled) {
        this.flags = enabled ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public int getClassId() {
        return -1564789301;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeInt(this.minLayer, stream);
        StreamingUtils.writeInt(this.maxLayer, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.minLayer = StreamingUtils.readInt(stream);
        this.maxLayer = StreamingUtils.readInt(stream);
    }

    @Override
    public String toString() {
        return "phoneCallProtocol#a2bb35cb";
    }
}

