/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.page.block;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.page.block.TLAbsPageBlock;
import org.telegram.api.richtext.TLAbsRichText;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;

public class TLPageBlockEmbed
extends TLAbsPageBlock {
    public static final int CLASS_ID = -840826671;
    private static final int FLAG_FULL_WIDTH = 1;
    private static final int FLAG_URL = 2;
    private static final int FLAG_HTML = 4;
    private static final int FLAG_ALLOW_SCROLLING = 8;
    private static final int FLAG_POSTER_PHOTO_ID = 16;
    private int flags;
    private String url;
    private String html;
    private long posterPhotoId;
    private int w;
    private int h;
    private TLAbsRichText caption;

    @Override
    public int getClassId() {
        return -840826671;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHtml() {
        return this.html;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public TLAbsRichText getCaption() {
        return this.caption;
    }

    public long getPosterPhotoId() {
        return this.posterPhotoId;
    }

    public boolean isFullWidth() {
        return (this.flags & 1) != 0;
    }

    public boolean allowScrolling() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        if ((this.flags & 2) != 0) {
            StreamingUtils.writeTLString(this.url, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamingUtils.writeTLString(this.html, stream);
        }
        if ((this.flags & 0x10) != 0) {
            StreamingUtils.writeLong(this.posterPhotoId, stream);
        }
        StreamingUtils.writeInt(this.w, stream);
        StreamingUtils.writeInt(this.h, stream);
        StreamingUtils.writeTLObject(this.caption, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        if ((this.flags & 2) != 0) {
            this.url = StreamingUtils.readTLString(stream);
        }
        if ((this.flags & 4) != 0) {
            this.html = StreamingUtils.readTLString(stream);
        }
        if ((this.flags & 0x10) != 0) {
            this.posterPhotoId = StreamingUtils.readLong(stream);
        }
        this.w = StreamingUtils.readInt(stream);
        this.h = StreamingUtils.readInt(stream);
        this.caption = StreamingUtils.readTLObject(stream, context, TLAbsRichText.class);
    }

    @Override
    public String toString() {
        return "pageBlockEmbed#cde200d1";
    }
}

