/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.functions.payments;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.input.paymentapi.paymentcredentials.TLAbsInputPaymentCredentials;
import org.telegram.api.paymentapi.payments.result.TLAbsPaymentsPaymentResult;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLMethod;
import org.telegram.tl.TLObject;

public class TLRequestPaymentsSendPaymentForm
extends TLMethod<TLAbsPaymentsPaymentResult> {
    public static final int CLASS_ID = 730364339;
    private static final int FLAG_INFO = 1;
    private static final int FLAG_SHIPPING_OPTION = 2;
    private int flags;
    private int msgId;
    private String requestedInfo;
    private String shippingOptionId;
    private TLAbsInputPaymentCredentials credentials;

    public int getMsgId() {
        return this.msgId;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    public String getRequestedInfo() {
        return this.requestedInfo;
    }

    public void setRequestedInfo(String requestedInfo) {
        this.flags = requestedInfo == null ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
        this.requestedInfo = requestedInfo;
    }

    public String getShippingOptionId() {
        return this.shippingOptionId;
    }

    public void setShippingOptionId(String shippingOptionId) {
        this.flags = shippingOptionId == null ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        this.shippingOptionId = shippingOptionId;
    }

    public TLAbsInputPaymentCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(TLAbsInputPaymentCredentials credentials) {
        this.credentials = credentials;
    }

    public boolean hasShippingOptions() {
        return (this.flags & 2) != 0;
    }

    public boolean hasInfo() {
        return (this.flags & 1) != 0;
    }

    @Override
    public TLAbsPaymentsPaymentResult deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject res = StreamingUtils.readTLObject(stream, context);
        if (res == null) {
            throw new IOException("Unable to parse response");
        }
        if (res instanceof TLAbsPaymentsPaymentResult) {
            return (TLAbsPaymentsPaymentResult)res;
        }
        throw new IOException("Incorrect response type. Expected " + TLAbsPaymentsPaymentResult.class.getName() + ", got: " + res.getClass().getCanonicalName());
    }

    @Override
    public int getClassId() {
        return 730364339;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeInt(this.msgId, stream);
        if (this.hasInfo()) {
            StreamingUtils.writeTLString(this.requestedInfo, stream);
        }
        if (this.hasShippingOptions()) {
            StreamingUtils.writeTLString(this.shippingOptionId, stream);
        }
        StreamingUtils.writeTLObject(this.credentials, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.msgId = StreamingUtils.readInt(stream);
        if (this.hasInfo()) {
            this.requestedInfo = StreamingUtils.readTLString(stream);
        }
        if (this.hasShippingOptions()) {
            this.shippingOptionId = StreamingUtils.readTLString(stream);
        }
        this.credentials = StreamingUtils.readTLObject(stream, context, TLAbsInputPaymentCredentials.class);
    }

    @Override
    public String toString() {
        return "payments.sendPaymentForm#2b8879b3";
    }
}

