/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.functions.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.input.peer.TLAbsInputPeer;
import org.telegram.api.messages.TLMessagesBotCallbackAnswer;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLBytes;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLMethod;
import org.telegram.tl.TLObject;

public class TLRequestMessagesGetBotCallbackAnswer
extends TLMethod<TLMessagesBotCallbackAnswer> {
    public static final int CLASS_ID = -2130010132;
    private static final int FLAG_DATA = 1;
    private static final int FLAG_GAME = 2;
    private int flags;
    private TLAbsInputPeer peer;
    private int msgId;
    private TLBytes data;

    @Override
    public int getClassId() {
        return -2130010132;
    }

    @Override
    public TLMessagesBotCallbackAnswer deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject res = StreamingUtils.readTLObject(stream, context);
        if (res == null) {
            throw new IOException("Unable to parse response");
        }
        if (res instanceof TLMessagesBotCallbackAnswer) {
            return (TLMessagesBotCallbackAnswer)res;
        }
        throw new IOException("Incorrect response type. Expected " + TLMessagesBotCallbackAnswer.class.getName() + ", got: " + res.getClass().getName());
    }

    public TLAbsInputPeer getPeer() {
        return this.peer;
    }

    public int getMsgId() {
        return this.msgId;
    }

    public TLBytes getData() {
        return this.data;
    }

    public void setPeer(TLAbsInputPeer peer) {
        this.peer = peer;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    public void setData(TLBytes data) {
        this.data = data;
    }

    public void enableGame(boolean enabled) {
        this.flags = enabled ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeTLObject(this.peer, stream);
        StreamingUtils.writeInt(this.msgId, stream);
        if ((this.flags & 1) != 0) {
            StreamingUtils.writeTLBytes(this.data, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.peer = StreamingUtils.readTLObject(stream, context, TLAbsInputPeer.class);
        this.msgId = StreamingUtils.readInt(stream);
        if ((this.flags & 1) != 0) {
            this.data = StreamingUtils.readTLBytes(stream, context);
        }
    }

    @Override
    public String toString() {
        return "messages.getBotCallbackAnswer#810a9fec";
    }
}

