/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.draft.TLAbsDraftMessage;
import org.telegram.api.peer.TLAbsPeer;
import org.telegram.api.peer.notify.settings.TLAbsPeerNotifySettings;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;

public class TLDialog
extends TLObject {
    public static final int CLASS_ID = 1728035348;
    private static final int FLAG_PTS = 1;
    private static final int FLAG_DRAFT = 2;
    private static final int FLAG_PINNED = 4;
    private int flags;
    private TLAbsPeer peer;
    private int topMessage;
    private int readInboxMaxId;
    private int readOutboxMaxId;
    private int unreadCount;
    private TLAbsPeerNotifySettings notifySettings;
    private int pts;
    private TLAbsDraftMessage draft;

    @Override
    public int getClassId() {
        return 1728035348;
    }

    public TLAbsPeer getPeer() {
        return this.peer;
    }

    public int getTopMessage() {
        return this.topMessage;
    }

    public int getReadInboxMaxId() {
        return this.readInboxMaxId;
    }

    public int getReadOutboxMaxId() {
        return this.readOutboxMaxId;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public TLAbsPeerNotifySettings getNotifySettings() {
        return this.notifySettings;
    }

    public int getPts() {
        return this.pts;
    }

    public TLAbsDraftMessage getDraft() {
        return this.draft;
    }

    public boolean isPinned() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeTLObject(this.peer, stream);
        StreamingUtils.writeInt(this.topMessage, stream);
        StreamingUtils.writeInt(this.readInboxMaxId, stream);
        StreamingUtils.writeInt(this.readOutboxMaxId, stream);
        StreamingUtils.writeInt(this.unreadCount, stream);
        StreamingUtils.writeTLObject(this.notifySettings, stream);
        if ((this.flags & 1) != 0) {
            StreamingUtils.writeInt(this.pts, stream);
        }
        if ((this.flags & 2) != 0) {
            StreamingUtils.writeTLObject(this.draft, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.peer = (TLAbsPeer)StreamingUtils.readTLObject(stream, context);
        this.topMessage = StreamingUtils.readInt(stream);
        this.readInboxMaxId = StreamingUtils.readInt(stream);
        this.readOutboxMaxId = StreamingUtils.readInt(stream);
        this.unreadCount = StreamingUtils.readInt(stream);
        this.notifySettings = (TLAbsPeerNotifySettings)StreamingUtils.readTLObject(stream, context);
        if ((this.flags & 1) != 0) {
            this.pts = StreamingUtils.readInt(stream);
        }
        if ((this.flags & 2) != 0) {
            this.draft = (TLAbsDraftMessage)StreamingUtils.readTLObject(stream, context);
        }
    }

    @Override
    public String toString() {
        return "dialog#66ffba14";
    }
}

