/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.apachecommons.cli.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teavm.apachecommons.cli.Option;
import org.teavm.apachecommons.cli.help.AbstractHelpFormatter;
import org.teavm.apachecommons.cli.help.OptionFormatter;
import org.teavm.apachecommons.cli.help.TableDefinition;
import org.teavm.apachecommons.cli.help.TextStyle;

public class HelpFormatter
extends AbstractHelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_COLUMN_SPACING = 5;
    private final boolean showSince;

    public static Builder builder() {
        return new Builder();
    }

    protected HelpFormatter(Builder builder) {
        super(builder);
        this.showSince = builder.showSince;
    }

    @Override
    public TableDefinition getTableDefinition(Iterable<Option> options) {
        TextStyle.Builder builder = TextStyle.builder().setAlignment(TextStyle.Alignment.LEFT).setIndent(1).setScalable(false);
        ArrayList<TextStyle> styles = new ArrayList<TextStyle>();
        styles.add(builder.get());
        builder.setScalable(true).setLeftPad(5);
        if (this.showSince) {
            builder.setAlignment(TextStyle.Alignment.CENTER);
            styles.add(builder.get());
        }
        builder.setAlignment(TextStyle.Alignment.LEFT);
        styles.add(builder.get());
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        StringBuilder sb = new StringBuilder();
        for (Option option : options) {
            ArrayList<String> row = new ArrayList<String>();
            OptionFormatter formatter = this.getOptionFormatBuilder().build(option);
            sb.setLength(0);
            sb.append(formatter.getBothOpt());
            if (option.hasArg()) {
                sb.append(" ").append(formatter.getArgName());
            }
            row.add(sb.toString());
            if (this.showSince) {
                row.add(formatter.getSince());
            }
            row.add(formatter.getDescription());
            rows.add(row);
        }
        return TableDefinition.from("", styles, this.showSince ? Arrays.asList("Options", "Since", "Description") : Arrays.asList("Options", "Description"), rows);
    }

    public static class Builder
    extends AbstractHelpFormatter.Builder<Builder, HelpFormatter> {
        private boolean showSince = true;

        protected Builder() {
        }

        @Override
        public HelpFormatter get() {
            return new HelpFormatter(this);
        }

        public Builder setShowSince(boolean showSince) {
            this.showSince = showSince;
            return this;
        }
    }
}

