/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.asm.ClassReader;
import org.teavm.asm.ClassVisitor;
import org.teavm.asm.ClassWriter;
import org.teavm.asm.Handle;
import org.teavm.asm.MethodVisitor;
import org.teavm.asm.Type;
import org.teavm.metaprogramming.Action;
import org.teavm.metaprogramming.Computation;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.impl.ActionImpl;
import org.teavm.metaprogramming.impl.ComputationImpl;
import org.teavm.metaprogramming.impl.MetaprogrammingImpl;
import org.teavm.metaprogramming.impl.RuntimeHelper;
import org.teavm.model.MethodReference;

public class MetaprogrammingInstrumentation {
    private static String lambdaMetafactory = LambdaMetafactory.class.getName().replace('.', '/');
    private static String proxyHelperType = Type.getInternalName(RuntimeHelper.class);
    private static String listDesc = Type.getDescriptor(List.class);

    public byte[] instrument(byte[] bytecode) {
        ClassReader reader = new ClassReader(bytecode);
        ClassWriter writer = new ClassWriter(0);
        ClassTransformer transformer = new ClassTransformer((ClassVisitor)writer);
        reader.accept((ClassVisitor)transformer, 0);
        return writer.toByteArray();
    }

    class MethodTransformer
    extends MethodVisitor {
        private boolean instrumented;

        MethodTransformer(MethodVisitor mv) {
            super(458752, mv);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            Type returnType;
            if ((!bsm.getOwner().equals(lambdaMetafactory) || bsm.getName().equals("metafactory")) && (returnType = Type.getReturnType((String)desc)).getSort() == 10) {
                if (returnType.getClassName().equals(Action.class.getName())) {
                    this.instrumented = true;
                    this.transformAction(desc, bsmArgs);
                    return;
                }
                if (returnType.getClassName().equals(Computation.class.getName())) {
                    this.instrumented = true;
                    this.transformComputation(desc, bsmArgs);
                    return;
                }
            }
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        private void transformAction(String desc, Object[] bsmArgs) {
            this.transformArguments(desc);
            this.transformMethod((Handle)bsmArgs[1]);
            super.visitMethodInsn(184, Type.getInternalName(ActionImpl.class), "create", "(" + Type.getDescriptor(List.class) + Type.getDescriptor(MethodReference.class) + ")" + Type.getDescriptor(ActionImpl.class), false);
        }

        private void transformComputation(String desc, Object[] bsmArgs) {
            this.transformArguments(desc);
            this.transformMethod((Handle)bsmArgs[1]);
            super.visitMethodInsn(184, Type.getInternalName(ComputationImpl.class), "create", "(" + Type.getDescriptor(List.class) + Type.getDescriptor(MethodReference.class) + ")" + Type.getDescriptor(ComputationImpl.class), false);
        }

        private void transformArguments(String desc) {
            Type[] argTypes = Type.getArgumentTypes((String)desc);
            String arrayListType = Type.getInternalName(ArrayList.class);
            super.visitTypeInsn(187, arrayListType);
            super.visitInsn(89);
            super.visitIntInsn(17, argTypes.length);
            super.visitMethodInsn(183, arrayListType, "<init>", "(I)V", false);
            for (int i = argTypes.length - 1; i >= 0; --i) {
                this.transformArgument(argTypes[i]);
            }
            super.visitInsn(89);
            super.visitMethodInsn(184, Type.getInternalName(Collections.class), "reverse", "(" + listDesc + ")V", false);
        }

        private void transformArgument(Type type) {
            switch (type.getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.transformArgument("I");
                    break;
                }
                case 7: {
                    this.transformArgument("L");
                    break;
                }
                case 6: {
                    this.transformArgument("F");
                    break;
                }
                case 8: {
                    this.transformArgument("D");
                    break;
                }
                default: {
                    this.transformArgument("Ljava/lang/Object;");
                }
            }
        }

        private void transformArgument(String desc) {
            super.visitMethodInsn(184, proxyHelperType, "add", "(" + desc + listDesc + ")" + listDesc, false);
        }

        private void transformMethod(Handle handle) {
            super.visitTypeInsn(187, Type.getInternalName(MethodReference.class));
            super.visitInsn(89);
            Type ownerType = Type.getType((String)("L" + handle.getOwner() + ";"));
            super.visitLdcInsn((Object)ownerType);
            super.visitLdcInsn((Object)handle.getName());
            Type[] argTypes = Type.getArgumentTypes((String)handle.getDesc());
            Type resultType = Type.getReturnType((String)handle.getDesc());
            super.visitIntInsn(17, argTypes.length + 1);
            super.visitTypeInsn(189, "java/lang/Class");
            for (int i = 0; i < argTypes.length; ++i) {
                super.visitInsn(89);
                super.visitIntInsn(17, i);
                this.emitClassLiteral(argTypes[i]);
                super.visitInsn(83);
            }
            super.visitInsn(89);
            super.visitIntInsn(17, argTypes.length);
            this.emitClassLiteral(resultType);
            super.visitInsn(83);
            super.visitMethodInsn(183, Type.getInternalName(MethodReference.class), "<init>", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)V", false);
        }

        private void emitClassLiteral(Type type) {
            switch (type.getSort()) {
                case 1: {
                    super.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 3: {
                    super.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 4: {
                    super.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 2: {
                    super.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 5: {
                    super.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 7: {
                    super.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 6: {
                    super.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 8: {
                    super.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 0: {
                    super.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    break;
                }
                default: {
                    super.visitLdcInsn((Object)type);
                }
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 184 && owner.equals(Type.getInternalName(Metaprogramming.class))) {
                owner = Type.getInternalName(MetaprogrammingImpl.class);
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(this.instrumented ? maxStack + 9 : maxStack, maxLocals);
        }
    }

    class ClassTransformer
    extends ClassVisitor {
        ClassTransformer(ClassVisitor cv) {
            super(458752, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor innerVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            return new MethodTransformer(innerVisitor);
        }
    }
}

