/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.metaprogramming.impl.MetaprogrammingClassLoader;
import org.teavm.metaprogramming.impl.MetaprogrammingImpl;
import org.teavm.metaprogramming.impl.UsageGenerator;
import org.teavm.metaprogramming.impl.model.MethodDescriber;
import org.teavm.metaprogramming.impl.model.MethodModel;
import org.teavm.metaprogramming.impl.optimization.Optimizations;
import org.teavm.metaprogramming.impl.reflect.ReflectContext;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.StringChooseEmitter;
import org.teavm.model.emit.ValueEmitter;

public class MetaprogrammingDependencyListener
extends AbstractDependencyListener {
    private MethodDescriber describer;
    private Set<MethodModel> installedProxies = new HashSet<MethodModel>();
    private MetaprogrammingClassLoader proxyClassLoader;

    public void started(DependencyAgent agent) {
        this.proxyClassLoader = new MetaprogrammingClassLoader(agent.getClassLoader());
        this.describer = new MethodDescriber(MetaprogrammingImpl.createDiagnostics(), agent.getClassSource());
        MetaprogrammingImpl.classLoader = this.proxyClassLoader;
        MetaprogrammingImpl.classSource = agent.getUnprocessedClassSource();
        MetaprogrammingImpl.hierarchy = new ClassHierarchy(agent.getUnprocessedClassSource());
        MetaprogrammingImpl.incrementalDependencies = agent.getIncrementalCache();
        MetaprogrammingImpl.agent = agent;
        MetaprogrammingImpl.reflectContext = new ReflectContext(agent.getClassHierarchy(), this.proxyClassLoader);
    }

    public void complete() {
        MetaprogrammingImpl.classLoader = null;
        MetaprogrammingImpl.classSource = null;
        MetaprogrammingImpl.hierarchy = null;
        MetaprogrammingImpl.incrementalDependencies = null;
        MetaprogrammingImpl.agent = null;
        MetaprogrammingImpl.reflectContext = null;
    }

    public void methodReached(DependencyAgent agent, MethodDependency methodDep) {
        MethodModel proxy = this.describer.getMethod(methodDep.getReference());
        if (proxy != null && this.installedProxies.add(proxy)) {
            MethodReader method;
            agent.getIncrementalCache().setNoCache(methodDep.getReference());
            ClassReader cls = agent.getClassSource().get(methodDep.getMethod().getOwnerName());
            int index = 0;
            Iterator iterator = cls.getMethods().iterator();
            while (iterator.hasNext() && !(method = (MethodReader)iterator.next()).getDescriptor().equals((Object)methodDep.getMethod().getDescriptor())) {
                ++index;
            }
            new UsageGenerator(agent, proxy, methodDep, this.proxyClassLoader, index).installProxyEmitter();
        }
    }

    public void completing(DependencyAgent agent) {
        for (MethodModel model : this.describer.getKnownMethods()) {
            ProgramEmitter pe = ProgramEmitter.create((MethodDescriptor)model.getMethod().getDescriptor(), (ClassHierarchy)agent.getClassHierarchy());
            ValueEmitter[] paramVars = new ValueEmitter[model.getMetaParameterCount()];
            int offset = model.isStatic() ? 1 : 0;
            for (int i = 0; i < paramVars.length; ++i) {
                paramVars[i] = pe.var(i + offset, model.getMetaParameterType(i));
            }
            if (model.getUsages().size() == 1) {
                this.emitSingleUsage(model, pe, paramVars);
            } else if (model.getUsages().isEmpty()) {
                ValueType returnType = model.getMethod().getReturnType();
                if (returnType == ValueType.VOID) {
                    pe.exit();
                } else {
                    pe.defaultValue(returnType).returnValue();
                }
            } else {
                this.emitMultipleUsage(model, pe, agent, paramVars);
            }
            agent.submitMethod(model.getMethod(), new Optimizations().apply(pe.getProgram(), model.getMethod()));
        }
    }

    private void emitSingleUsage(MethodModel model, ProgramEmitter pe, ValueEmitter[] paramVars) {
        MethodReference usage = model.getUsages().values().stream().findFirst().orElse(null);
        ValueEmitter result = pe.invoke(usage, paramVars);
        if (usage.getReturnType() == ValueType.VOID) {
            pe.exit();
        } else {
            assert (result != null) : "Expected non-null result at " + model.getMethod();
            result.returnValue();
        }
    }

    private void emitMultipleUsage(MethodModel model, ProgramEmitter pe, DependencyAgent agent, ValueEmitter[] paramVars) {
        MethodDependencyInfo methodDep = agent.getMethod(model.getMethod());
        ValueEmitter paramVar = paramVars[model.getMetaClassParameterIndex()];
        ValueEmitter tag = paramVar.invokeVirtual("getName", String.class, new ValueEmitter[0]);
        StringChooseEmitter choice = pe.stringChoice(tag);
        for (Map.Entry<ValueType, MethodReference> usageEntry : model.getUsages().entrySet()) {
            ValueType type = usageEntry.getKey();
            String typeName = type instanceof ValueType.Object ? ((ValueType.Object)type).getClassName() : type.toString().replace('/', '.');
            choice.option(typeName, () -> {
                MethodReference implMethod = (MethodReference)usageEntry.getValue();
                ValueEmitter[] castParamVars = new ValueEmitter[paramVars.length];
                for (int i = 0; i < castParamVars.length; ++i) {
                    castParamVars[i] = paramVars[i].cast(implMethod.parameterType(i));
                }
                ValueEmitter result = pe.invoke(implMethod, castParamVars);
                if (implMethod.getReturnType() == ValueType.VOID) {
                    pe.exit();
                } else {
                    assert (result != null) : "Expected non-null result at " + model.getMethod();
                    result.returnValue();
                }
            });
        }
        choice.otherwise(() -> {
            ValueType returnType = methodDep.getReference().getReturnType();
            if (returnType == ValueType.VOID) {
                pe.exit();
            } else {
                pe.defaultValue(returnType).returnValue();
            }
        });
    }
}

