/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.teavm.hppc.AbstractByteCollection;
import org.teavm.hppc.AbstractDoubleCollection;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.BitMixer;
import org.teavm.hppc.BufferAllocationException;
import org.teavm.hppc.ByteCollection;
import org.teavm.hppc.DoubleBufferVisualizer;
import org.teavm.hppc.DoubleByteAssociativeContainer;
import org.teavm.hppc.DoubleByteMap;
import org.teavm.hppc.DoubleContainer;
import org.teavm.hppc.DoubleLookupContainer;
import org.teavm.hppc.HashContainers;
import org.teavm.hppc.HashOrderMixing;
import org.teavm.hppc.HashOrderMixingStrategy;
import org.teavm.hppc.Preallocable;
import org.teavm.hppc.cursors.ByteCursor;
import org.teavm.hppc.cursors.DoubleByteCursor;
import org.teavm.hppc.cursors.DoubleCursor;
import org.teavm.hppc.predicates.BytePredicate;
import org.teavm.hppc.predicates.DoubleBytePredicate;
import org.teavm.hppc.predicates.DoublePredicate;
import org.teavm.hppc.procedures.ByteProcedure;
import org.teavm.hppc.procedures.DoubleByteProcedure;
import org.teavm.hppc.procedures.DoubleProcedure;

public class DoubleByteHashMap
implements DoubleByteMap,
Preallocable,
Cloneable {
    public double[] keys;
    public byte[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public DoubleByteHashMap() {
        this(4);
    }

    public DoubleByteHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleByteHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public DoubleByteHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public DoubleByteHashMap(DoubleByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(double key, byte value) {
        double existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = true;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                byte previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(DoubleByteAssociativeContainer container) {
        int count = this.size();
        for (DoubleByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends DoubleByteCursor> iterable) {
        int count = this.size();
        for (DoubleByteCursor doubleByteCursor : iterable) {
            this.put(doubleByteCursor.key, doubleByteCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(double key, byte value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(double key, byte putValue, byte incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = (byte)(this.values[keyIndex] + incrementValue);
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public byte addTo(double key, byte incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public byte remove(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = false;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                byte previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(DoubleContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof DoubleLookupContainer) {
            if (this.hasEmptyKey && other.contains(0.0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            double[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                double existing = keys[slot];
                if (Double.doubleToLongBits(existing) != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (DoubleCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoubleBytePredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0.0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        double[] keys = this.keys;
        byte[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0.0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        double[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public byte get(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (byte)0;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(double key, byte defaultValue) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public byte indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        byte previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, double key, byte value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (Double.doubleToLongBits(key) == 0L) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (Double.doubleToLongBits(this.keys[index]) == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0.0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (DoubleByteCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((DoubleByteHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(DoubleByteHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (DoubleByteCursor c : other) {
            double key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            double[] prevKeys = this.keys;
            byte[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<DoubleByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleByteProcedure> T forEach(T procedure) {
        double[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0.0, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (Double.doubleToLongBits(keys[slot]) == 0L) continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends DoubleBytePredicate> T forEach(T predicate) {
        double[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(0.0, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (Double.doubleToLongBits(keys[slot]) == 0L || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    public DoubleByteHashMap clone() {
        try {
            DoubleByteHashMap cloned = (DoubleByteHashMap)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.values = (byte[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return DoubleBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static DoubleByteHashMap from(double[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleByteHashMap map = new DoubleByteHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(double key) {
        assert (Double.doubleToLongBits(key) != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(double[] fromKeys, byte[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        double[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            double existing = fromKeys[from];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        double[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new double[arraySize + emptyElementSlot];
            this.values = new byte[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, double pendingKey, byte pendingValue) {
        assert (this.assigned == this.resizeAt && Double.doubleToLongBits(this.keys[slot]) == 0L && Double.doubleToLongBits(pendingKey) != 0L);
        double[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        double existing;
        double[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while (Double.doubleToLongBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        values[gapSlot] = 0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = DoubleByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (Double.doubleToLongBits(DoubleByteHashMap.this.keys[this.slot]) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = DoubleByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = DoubleByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final DoubleByteHashMap owner;

        private ValuesContainer() {
            this.owner = DoubleByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (DoubleByteCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            for (DoubleByteCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            for (DoubleByteCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final byte e) {
            return this.owner.removeAll(new DoubleBytePredicate(){

                @Override
                public boolean apply(double key, byte value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate predicate) {
            return this.owner.removeAll(new DoubleBytePredicate(){

                @Override
                public boolean apply(double key, byte value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = DoubleByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleByteHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0.0;
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleByteHashMap owner;

        public KeysContainer() {
            this.owner = DoubleByteHashMap.this;
        }

        @Override
        public boolean contains(double e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(final T procedure) {
            this.owner.forEach(new DoubleByteProcedure(){

                @Override
                public void apply(double key, byte value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(final T predicate) {
            this.owner.forEach(new DoubleBytePredicate(){

                @Override
                public boolean apply(double key, byte value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(double e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleByteCursor> {
        private final DoubleByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = DoubleByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleByteCursor();
        }

        @Override
        protected DoubleByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleByteHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = DoubleByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0.0;
                this.cursor.value = DoubleByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleByteCursor)this.done();
        }
    }
}

