/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.List;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformAnnotationProvider;
import org.teavm.platform.PlatformClass;

public class AnnotationDependencyListener
extends AbstractDependencyListener {
    private static final MethodReference GET_ANNOTATIONS_METHOD = new MethodReference(Platform.class, "getAnnotations", PlatformClass.class, Annotation[].class);
    private static final String ANNOTATIONS_READER_SUFFIX = "$$__annotations__$$";

    private String getAnnotationImplementor(DependencyAgent agent, String annotationType) {
        String implementorName = annotationType + "$$_impl";
        if (agent.getClassSource().get(implementorName) == null) {
            ClassHolder implementor = this.createImplementor(agent.getClassHierarchy(), annotationType, implementorName);
            agent.submitClass(implementor);
        }
        return implementorName;
    }

    private ClassHolder createImplementor(ClassHierarchy hierarchy, String annotationType, String implementorName) {
        ClassHolder implementor = new ClassHolder(implementorName);
        implementor.setParent("java.lang.Object");
        implementor.getInterfaces().add(annotationType);
        implementor.getModifiers().add(ElementModifier.FINAL);
        implementor.setLevel(AccessLevel.PUBLIC);
        ClassReader annotation = hierarchy.getClassSource().get(annotationType);
        if (annotation == null) {
            return implementor;
        }
        ArrayList<ValueType> ctorSignature = new ArrayList<ValueType>();
        for (MethodReader methodReader : annotation.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC)) continue;
            FieldHolder field = new FieldHolder("$" + methodReader.getName());
            field.setType(methodReader.getResultType());
            field.setLevel(AccessLevel.PRIVATE);
            implementor.addField(field);
            MethodHolder accessor = new MethodHolder(methodReader.getDescriptor());
            ProgramEmitter pe = ProgramEmitter.create(accessor, hierarchy);
            ValueEmitter valueEmitter = pe.var(0, (ClassReader)implementor);
            ValueEmitter result = valueEmitter.getField(field.getName(), field.getType());
            if (field.getType() instanceof ValueType.Array) {
                result = result.cloneArray();
            }
            result.returnValue();
            implementor.addMethod(accessor);
            ctorSignature.add(field.getType());
        }
        ctorSignature.add(ValueType.VOID);
        MethodHolder ctor = new MethodHolder("<init>", ctorSignature.toArray(new ValueType[0]));
        ProgramEmitter programEmitter = ProgramEmitter.create(ctor, hierarchy);
        ValueEmitter thisVar = programEmitter.var(0, (ClassReader)implementor);
        thisVar.invokeSpecial(Object.class, "<init>", new ValueEmitter[0]);
        int index = 1;
        for (MethodReader methodReader : annotation.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC)) continue;
            ValueEmitter param = programEmitter.var(index++, methodReader.getResultType());
            thisVar.setField("$" + methodReader.getName(), param);
        }
        programEmitter.exit();
        implementor.addMethod(ctor);
        MethodHolder annotTypeMethod = new MethodHolder("annotationType", ValueType.parse(Class.class));
        ProgramEmitter programEmitter2 = ProgramEmitter.create(annotTypeMethod, hierarchy);
        programEmitter2.constant(ValueType.object(annotationType)).returnValue();
        implementor.addMethod(annotTypeMethod);
        return implementor;
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        MethodReference methodRef;
        ClassReader cls;
        ValueType type = method.getMethod().getResultType();
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            ClassReader cls2 = agent.getClassSource().get(className);
            if (cls2 != null && cls2.hasModifier(ElementModifier.ANNOTATION)) {
                agent.linkClass(className);
            }
        }
        if (method.getMethod().hasModifier(ElementModifier.STATIC) && method.getMethod().getName().equals("$$__readAnnotations__$$") && (cls = agent.getClassSource().get(method.getReference().getClassName())) != null) {
            for (AnnotationReader annotationReader : cls.getAnnotations().all()) {
                agent.linkClass(annotationReader.getType());
            }
        }
        if ((methodRef = method.getMethod().getReference()).getClassName().equals("java.lang.Class") && methodRef.getName().equals("getAnnotations")) {
            this.reachGetAnnotations(agent, method.getVariable(0));
        }
    }

    private void reachGetAnnotations(DependencyAgent agent, DependencyNode node) {
        node.getClassValueNode().addConsumer(type -> {
            String className = type.getName();
            if (className.endsWith(ANNOTATIONS_READER_SUFFIX)) {
                return;
            }
            ClassReader cls = agent.getClassSource().get(className);
            if (cls == null) {
                return;
            }
            for (AnnotationReader annotationReader : cls.getAnnotations().all()) {
                agent.linkClass(annotationReader.getType());
            }
            this.createAnnotationClass(agent, className);
        });
    }

    private void createAnnotationClass(DependencyAgent agent, String className) {
        String readerClassName = className + ANNOTATIONS_READER_SUFFIX;
        if (agent.getClassSource().get(readerClassName) != null) {
            return;
        }
        ClassHolder cls = new ClassHolder(readerClassName);
        cls.setLevel(AccessLevel.PUBLIC);
        cls.setOwnerName("java.lang.Object");
        cls.getInterfaces().add(PlatformAnnotationProvider.class.getName());
        MethodHolder ctor = new MethodHolder("<init>", ValueType.VOID);
        ctor.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create(ctor, agent.getClassHierarchy());
        ValueEmitter thisVar = pe.var(0, (ClassReader)cls);
        thisVar.invokeSpecial(Object.class, "<init>", new ValueEmitter[0]).exit();
        ClassReader annotatedClass = agent.getClassSource().get(className);
        cls.addMethod(ctor);
        MethodHolder reader = this.addReader(agent, annotatedClass);
        cls.addMethod(reader);
        agent.submitClass(cls);
        MethodDependency ctorDep = agent.linkMethod(ctor.getReference());
        ctorDep.getVariable(0).propagate(agent.getType(readerClassName));
        ctorDep.use();
        MethodDependency annotationsDep = agent.linkMethod(GET_ANNOTATIONS_METHOD);
        MethodDependency readerDep = agent.linkMethod(reader.getReference());
        readerDep.getVariable(0).propagate(agent.getType(readerClassName));
        readerDep.getResult().getArrayItem().connect(annotationsDep.getResult().getArrayItem());
        readerDep.use();
    }

    /*
     * WARNING - void declaration
     */
    private MethodHolder addReader(DependencyAgent agent, ClassReader cls) {
        void var7_9;
        MethodHolder readerMethod = new MethodHolder("getAnnotations", ValueType.parse(Annotation[].class));
        readerMethod.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create(readerMethod, agent.getClassHierarchy());
        ArrayList<AnnotationReader> annotations = new ArrayList<AnnotationReader>();
        for (AnnotationReader annotationReader : cls.getAnnotations().all()) {
            String retentionPolicy;
            AnnotationReader retention;
            ClassReader annotType = agent.getClassSource().get(annotationReader.getType());
            if (annotType == null || (retention = annotType.getAnnotations().get(Retention.class.getName())) == null || !(retentionPolicy = retention.getValue("value").getEnumValue().getFieldName()).equals("RUNTIME")) continue;
            annotations.add(annotationReader);
        }
        ValueEmitter array = pe.constructArray(Annotation.class, annotations.size());
        boolean bl = false;
        while (var7_9 < annotations.size()) {
            array.setElement((int)var7_9, this.generateAnnotationInstance(agent, pe, (AnnotationReader)annotations.get((int)var7_9)));
            ++var7_9;
        }
        array.returnValue();
        return readerMethod;
    }

    private ValueEmitter generateAnnotationInstance(DependencyAgent agent, ProgramEmitter pe, AnnotationReader annotation) {
        ClassReader annotationClass = agent.getClassSource().get(annotation.getType());
        if (annotationClass == null) {
            return pe.constantNull(ValueType.object(annotation.getType()));
        }
        String className = this.getAnnotationImplementor(agent, annotation.getType());
        ArrayList<ValueEmitter> params = new ArrayList<ValueEmitter>();
        for (MethodReader methodReader : annotationClass.getMethods()) {
            AnnotationValue value = annotation.getValue(methodReader.getName());
            if (value == null) {
                value = methodReader.getAnnotationDefault();
            }
            params.add(this.generateAnnotationValue(agent, pe, methodReader.getResultType(), value).cast(methodReader.getResultType()));
        }
        return pe.construct(className, params.toArray(new ValueEmitter[0]));
    }

    private ValueEmitter generateAnnotationValue(DependencyAgent agent, ProgramEmitter pe, ValueType type, AnnotationValue value) {
        switch (value.getType()) {
            case 0: {
                return pe.constant(value.getBoolean() ? 1 : 0);
            }
            case 12: {
                return pe.constant(value.getChar());
            }
            case 1: {
                return pe.constant(value.getByte());
            }
            case 2: {
                return pe.constant(value.getShort());
            }
            case 3: {
                return pe.constant(value.getInt());
            }
            case 4: {
                return pe.constant(value.getLong());
            }
            case 5: {
                return pe.constant(value.getFloat());
            }
            case 6: {
                return pe.constant(value.getDouble());
            }
            case 7: {
                return pe.constant(value.getString());
            }
            case 9: {
                List<AnnotationValue> list = value.getList();
                ValueType itemType = ((ValueType.Array)type).getItemType();
                ValueEmitter array = pe.constructArray(itemType, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    array.setElement(i, this.generateAnnotationValue(agent, pe, itemType, list.get(i)));
                }
                return array;
            }
            case 10: {
                pe.initClass(value.getEnumValue().getClassName());
                return pe.getField(value.getEnumValue(), type);
            }
            case 8: {
                return pe.constant(value.getJavaClass());
            }
            case 11: {
                return this.generateAnnotationInstance(agent, pe, value.getAnnotation());
            }
        }
        throw new IllegalArgumentException("Unknown annotation value type: " + value.getType());
    }
}

