/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.impl.reflection.Flags;
import org.teavm.classlib.impl.reflection.JSClass;
import org.teavm.classlib.impl.reflection.JSField;
import org.teavm.classlib.impl.reflection.JSMethodMember;
import org.teavm.classlib.java.lang.ClassDependencyListener;
import org.teavm.classlib.java.lang.ClassGenerator;
import org.teavm.classlib.java.lang.TClassCastException;
import org.teavm.classlib.java.lang.TClassLoader;
import org.teavm.classlib.java.lang.TClassNotFoundException;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TInstantiationException;
import org.teavm.classlib.java.lang.TNoSuchFieldError;
import org.teavm.classlib.java.lang.TNoSuchMethodException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TPackage;
import org.teavm.classlib.java.lang.TSecurityException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.annotation.TAnnotation;
import org.teavm.classlib.java.lang.reflect.TAnnotatedElement;
import org.teavm.classlib.java.lang.reflect.TConstructor;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.lang.reflect.TMethod;
import org.teavm.classlib.java.lang.reflect.TModifier;
import org.teavm.classlib.java.lang.reflect.TType;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.core.JSArray;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformClass;
import org.teavm.platform.PlatformSequence;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;

public class TClass<T>
extends TObject
implements TAnnotatedElement,
TType {
    String name;
    String simpleName;
    String canonicalName;
    private PlatformClass platformClass;
    private TAnnotation[] annotationsCache;
    private Map<TClass<?>, TAnnotation> annotationsByType;
    private TField[] declaredFields;
    private TField[] fields;
    private TConstructor<T>[] declaredConstructors;
    private TMethod[] declaredMethods;
    private static boolean reflectionInitialized;

    private TClass(PlatformClass platformClass) {
        this.platformClass = platformClass;
        platformClass.setJavaClass(Platform.getPlatformObject(this));
    }

    public static TClass<?> getClass(PlatformClass cls) {
        if (cls == null) {
            return null;
        }
        TClass result = (TClass)((Object)Platform.asJavaClass(cls.getJavaClass()));
        if (result == null) {
            result = new TClass(cls);
        }
        return result;
    }

    @Override
    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    private String obfuscatedToString() {
        return "javaClass@" + this.identity();
    }

    public PlatformClass getPlatformClass() {
        return this.platformClass;
    }

    @DelegateTo(value="isInstanceLowLevel")
    public boolean isInstance(TObject obj) {
        return Platform.isInstance(Platform.getPlatformObject(obj), this.platformClass);
    }

    @Unmanaged
    private boolean isInstanceLowLevel(RuntimeObject obj) {
        return obj != null && this.isAssignableFromLowLevel(RuntimeClass.getClass(obj));
    }

    @DelegateTo(value="isAssignableFromLowLevel")
    public boolean isAssignableFrom(TClass<?> obj) {
        return Platform.isAssignable(obj.getPlatformClass(), this.platformClass);
    }

    @Unmanaged
    private boolean isAssignableFromLowLevel(RuntimeClass other) {
        return ((RuntimeClass)Address.ofObject((Object)this).toStructure()).isSupertypeOf.apply(other);
    }

    @Unmanaged
    public String getName() {
        if (PlatformDetector.isLowLevel()) {
            String result = TClass.getNameCache(this);
            if (result == null) {
                TClass<?> componentType;
                String componentName;
                result = Platform.getName(this.platformClass);
                if (result == null && this.isArray() && (componentName = (componentType = this.getComponentType()).getName()) != null) {
                    result = componentType.isArray() ? "[" + componentName : "[L" + componentName + ";";
                }
                TClass.setNameCache(this, result);
            }
            return result;
        }
        if (this.name == null) {
            this.name = Platform.getName(this.platformClass);
        }
        return this.name;
    }

    public String getSimpleName() {
        String simpleName = TClass.getSimpleNameCache(this);
        if (simpleName == null) {
            if (this.isArray()) {
                simpleName = this.getComponentType().getSimpleName() + "[]";
            } else if (this.getEnclosingClass() != null) {
                simpleName = Platform.getSimpleName(this.platformClass);
                if (simpleName == null) {
                    simpleName = "";
                }
            } else {
                String name = Platform.getName(this.platformClass);
                int lastDollar = name.lastIndexOf(36);
                if (lastDollar != -1) {
                    if ((name = name.substring(lastDollar + 1)).charAt(0) >= '0' && name.charAt(0) <= '9') {
                        name = "";
                    }
                } else {
                    int lastDot = name.lastIndexOf(46);
                    if (lastDot != -1) {
                        name = name.substring(lastDot + 1);
                    }
                }
                simpleName = name;
            }
            TClass.setSimpleNameCache(this, simpleName);
        }
        return simpleName;
    }

    @DelegateTo(value="getSimpleNameCacheLowLevel")
    private static String getSimpleNameCache(TClass<?> self) {
        return self.simpleName;
    }

    @Unmanaged
    @PluggableDependency(value=ClassDependencyListener.class)
    private static RuntimeObject getSimpleNameCacheLowLevel(RuntimeClass self) {
        return self.simpleNameCache;
    }

    @DelegateTo(value="setSimpleNameCacheLowLevel")
    private static void setSimpleNameCache(TClass<?> self, String value) {
        self.simpleName = value;
    }

    @Unmanaged
    private static void setSimpleNameCacheLowLevel(RuntimeClass self, RuntimeObject object) {
        self.simpleNameCache = object;
    }

    @DelegateTo(value="getNameCacheLowLevel")
    private static String getNameCache(TClass<?> self) {
        return self.name;
    }

    @Unmanaged
    @PluggableDependency(value=ClassDependencyListener.class)
    private static RuntimeObject getNameCacheLowLevel(RuntimeClass self) {
        return self.nameCache;
    }

    @DelegateTo(value="setNameCacheLowLevel")
    private static void setNameCache(TClass<?> self, String value) {
        self.name = value;
    }

    @Unmanaged
    private static void setNameCacheLowLevel(RuntimeClass self, RuntimeObject object) {
        self.nameCache = object;
    }

    public String getCanonicalName() {
        String result = this.getCanonicalNameCache();
        if (result == null) {
            if (this.isArray()) {
                String componentName = this.getComponentType().getCanonicalName();
                if (componentName == null) {
                    return null;
                }
                result = componentName + "[]";
            } else if (this.getEnclosingClass() != null) {
                if (this.getDeclaringClass() == null || this.isSynthetic()) {
                    return null;
                }
                String enclosingName = this.getDeclaringClass().getCanonicalName();
                if (enclosingName == null) {
                    return null;
                }
                result = enclosingName + "." + this.getSimpleName();
            } else {
                result = this.getName();
            }
            this.setCanonicalNameCache(result);
        }
        return result;
    }

    private boolean isSynthetic() {
        if (PlatformDetector.isJavaScript()) {
            return (this.platformClass.getMetadata().getAccessLevel() & 0x20) != 0;
        }
        return (RuntimeClass.getClass((RuntimeObject)((RuntimeObject)Address.ofObject((Object)this).toStructure())).flags & 0x400) != 0;
    }

    @DelegateTo(value="getCanonicalNameCacheLowLevel")
    private String getCanonicalNameCache() {
        return this.canonicalName;
    }

    @Unmanaged
    @PluggableDependency(value=ClassDependencyListener.class)
    private RuntimeObject getCanonicalNameCacheLowLevel() {
        return ((RuntimeClass)Address.ofObject((Object)this).toStructure()).canonicalName;
    }

    @DelegateTo(value="setCanonicalNameCacheLowLevel")
    private void setCanonicalNameCache(String value) {
        this.canonicalName = value;
    }

    @Unmanaged
    private void setCanonicalNameCacheLowLevel(RuntimeObject object) {
        ((RuntimeClass)Address.ofObject((Object)this).toStructure()).canonicalName = object;
    }

    public boolean isPrimitive() {
        return Platform.isPrimitive(this.platformClass);
    }

    public boolean isArray() {
        return Platform.getArrayItem(this.platformClass) != null;
    }

    public boolean isEnum() {
        return Platform.isEnum(this.platformClass);
    }

    public boolean isInterface() {
        return (this.platformClass.getMetadata().getFlags() & 2) != 0;
    }

    public boolean isLocalClass() {
        return (this.platformClass.getMetadata().getFlags() & 0x20) != 0 && this.getEnclosingClass() != null;
    }

    public boolean isMemberClass() {
        return this.getDeclaringClass() != null;
    }

    @PluggableDependency(value=ClassGenerator.class)
    public TClass<?> getComponentType() {
        return TClass.getClass(Platform.getArrayItem(this.platformClass));
    }

    public TField[] getDeclaredFields() throws TSecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new TField[0];
        }
        if (this.declaredFields == null) {
            TClass.initReflection();
            JSClass jsClass = (JSClass)this.getPlatformClass().getMetadata();
            JSArray<JSField> jsFields = jsClass.getFields();
            this.declaredFields = new TField[jsFields.getLength()];
            for (int i = 0; i < jsFields.getLength(); ++i) {
                JSField jsField = (JSField)jsFields.get(i);
                this.declaredFields[i] = new TField(this, jsField.getName(), jsField.getModifiers(), jsField.getAccessLevel(), TClass.getClass(jsField.getType()), jsField.getGetter(), jsField.getSetter());
            }
        }
        return (TField[])this.declaredFields.clone();
    }

    private static void initReflection() {
        if (!reflectionInitialized) {
            reflectionInitialized = true;
            TClass.createMetadata();
        }
    }

    @GeneratedBy(value=ClassGenerator.class)
    @NoSideEffects
    private static native void createMetadata();

    public TField[] getFields() throws TSecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new TField[0];
        }
        if (this.fields == null) {
            ArrayList<TField> fieldList = new ArrayList<TField>();
            TClass<T> cls = this;
            if (cls.isInterface()) {
                TClass.getFieldsOfInterfaces(cls, fieldList, new HashSet());
            } else {
                while (cls != null) {
                    for (TField field : this.declaredFields) {
                        if (!Modifier.isPublic(field.getModifiers())) continue;
                        fieldList.add(field);
                    }
                    cls = cls.getSuperclass();
                }
            }
            this.fields = fieldList.toArray(new TField[fieldList.size()]);
        }
        return (TField[])this.fields.clone();
    }

    public TField getDeclaredField(String name) throws TNoSuchFieldError {
        for (TField field : this.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new TNoSuchFieldError();
    }

    public TField getField(String name) throws TNoSuchFieldError {
        TField result = this.findField(name, new HashSet<String>());
        if (result == null) {
            throw new TNoSuchFieldError();
        }
        return result;
    }

    private TField findField(String name, Set<String> visited) {
        TField field;
        if (!visited.add(name)) {
            return null;
        }
        for (TField tField : this.getDeclaredFields()) {
            if (!TModifier.isPublic(tField.getModifiers()) || !tField.getName().equals(name)) continue;
            return tField;
        }
        for (TAnnotatedElement tAnnotatedElement : this.getInterfaces()) {
            TField field3 = super.findField(name, visited);
            if (field3 == null) continue;
            return field3;
        }
        TClass<T> superclass = this.getSuperclass();
        if (superclass != null && (field = super.findField(name, visited)) != null) {
            return field;
        }
        return null;
    }

    @InjectedBy(value=ClassGenerator.class)
    @PluggableDependency(value=ClassGenerator.class)
    public native <T> T newEmptyInstance();

    public TConstructor<?>[] getDeclaredConstructors() throws TSecurityException {
        if (this.isPrimitive() || this.isArray()) {
            return new TConstructor[0];
        }
        if (this.declaredConstructors == null) {
            TClass.initReflection();
            JSClass jsClass = (JSClass)this.getPlatformClass().getMetadata();
            JSArray<JSMethodMember> jsMethods = jsClass.getMethods();
            this.declaredConstructors = new TConstructor[jsMethods.getLength()];
            int count = 0;
            for (int i = 0; i < jsMethods.getLength(); ++i) {
                JSMethodMember jsMethod = (JSMethodMember)jsMethods.get(i);
                if (!jsMethod.getName().equals("<init>")) continue;
                PlatformSequence<PlatformClass> jsParameterTypes = jsMethod.getParameterTypes();
                TClass[] parameterTypes = new TClass[jsParameterTypes.getLength()];
                for (int j = 0; j < parameterTypes.length; ++j) {
                    parameterTypes[j] = TClass.getClass(jsParameterTypes.get(j));
                }
                this.declaredConstructors[count++] = new TConstructor(this, jsMethod.getName(), jsMethod.getModifiers(), jsMethod.getAccessLevel(), parameterTypes, jsMethod.getCallable());
            }
            this.declaredConstructors = Arrays.copyOf(this.declaredConstructors, count);
        }
        return (TConstructor[])this.declaredConstructors.clone();
    }

    public TConstructor<?>[] getConstructors() throws TSecurityException {
        TConstructor<?>[] declaredConstructors = this.getDeclaredConstructors();
        TConstructor[] constructors = new TConstructor[declaredConstructors.length];
        int sz = 0;
        for (TConstructor<?> constructor : declaredConstructors) {
            if (!TModifier.isPublic(constructor.getModifiers())) continue;
            constructors[sz++] = constructor;
        }
        if (sz < constructors.length) {
            constructors = Arrays.copyOf(constructors, sz);
        }
        return constructors;
    }

    public TConstructor<T> getDeclaredConstructor(TClass<?> ... parameterTypes) throws TSecurityException, TNoSuchMethodException {
        for (TConstructor<?> constructor : this.getDeclaredConstructors()) {
            if (!Arrays.equals(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        throw new TNoSuchMethodException();
    }

    public TConstructor<T> getConstructor(TClass<?> ... parameterTypes) throws TSecurityException, TNoSuchMethodException {
        for (TConstructor<?> constructor : this.getDeclaredConstructors()) {
            if (!TModifier.isPublic(constructor.getModifiers()) || !Arrays.equals(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        throw new TNoSuchMethodException();
    }

    private static void getFieldsOfInterfaces(TClass<?> iface, List<TField> fields, Set<TClass<?>> visited) {
        if (!visited.add(iface)) {
            return;
        }
        for (TField tField : iface.getDeclaredFields()) {
            if (!Modifier.isPublic(tField.getModifiers())) continue;
            fields.add(tField);
        }
        for (TAnnotatedElement tAnnotatedElement : iface.getInterfaces()) {
            TClass.getFieldsOfInterfaces(tAnnotatedElement, fields, visited);
        }
    }

    public TMethod[] getDeclaredMethods() {
        if (this.isPrimitive() || this.isArray()) {
            return new TMethod[0];
        }
        if (this.declaredMethods == null) {
            TClass.initReflection();
            JSClass jsClass = (JSClass)this.getPlatformClass().getMetadata();
            JSArray<JSMethodMember> jsMethods = jsClass.getMethods();
            this.declaredMethods = new TMethod[jsMethods.getLength()];
            int count = 0;
            for (int i = 0; i < jsMethods.getLength(); ++i) {
                JSMethodMember jsMethod = (JSMethodMember)jsMethods.get(i);
                if (jsMethod.getName().equals("<init>") || jsMethod.getName().equals("<clinit>")) continue;
                PlatformSequence<PlatformClass> jsParameterTypes = jsMethod.getParameterTypes();
                TClass[] parameterTypes = new TClass[jsParameterTypes.getLength()];
                for (int j = 0; j < parameterTypes.length; ++j) {
                    parameterTypes[j] = TClass.getClass(jsParameterTypes.get(j));
                }
                TClass<?> returnType = TClass.getClass(jsMethod.getReturnType());
                this.declaredMethods[count++] = new TMethod(this, jsMethod.getName(), jsMethod.getModifiers(), jsMethod.getAccessLevel(), returnType, parameterTypes, jsMethod.getCallable());
            }
            this.declaredMethods = Arrays.copyOf(this.declaredMethods, count);
        }
        return (TMethod[])this.declaredMethods.clone();
    }

    public TMethod getDeclaredMethod(String name, TClass<?> ... parameterTypes) throws TNoSuchMethodException, TSecurityException {
        TMethod bestFit = null;
        for (TMethod method : this.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), parameterTypes) || bestFit != null && !bestFit.getReturnType().isAssignableFrom(method.getReturnType())) continue;
            bestFit = method;
        }
        if (bestFit == null) {
            throw new TNoSuchMethodException();
        }
        return bestFit;
    }

    public TMethod[] getMethods() throws TSecurityException {
        HashMap<MethodSignature, TMethod> methods = new HashMap<MethodSignature, TMethod>();
        TClass.findMethods(this, methods);
        return methods.values().toArray(new TMethod[methods.size()]);
    }

    public TMethod getMethod(String name, TClass<?> ... parameterTypes) throws TNoSuchMethodException, TSecurityException {
        TMethod method = TClass.findMethod(this, null, name, parameterTypes);
        if (method == null) {
            throw new TNoSuchMethodException();
        }
        return method;
    }

    private static void findMethods(TClass<?> cls, Map<MethodSignature, TMethod> methods) {
        TClass<?> superclass;
        for (TMethod tMethod : cls.getDeclaredMethods()) {
            MethodSignature signature;
            if (!TModifier.isPublic(tMethod.getModifiers()) || methods.containsKey(signature = new MethodSignature(tMethod.getName(), tMethod.getParameterTypes(), tMethod.getReturnType()))) continue;
            methods.put(signature, tMethod);
        }
        if (!cls.isInterface() && (superclass = cls.getSuperclass()) != null) {
            TClass.findMethods(superclass, methods);
        }
        for (TAnnotatedElement tAnnotatedElement : cls.getInterfaces()) {
            TClass.findMethods(tAnnotatedElement, methods);
        }
    }

    private static TMethod findMethod(TClass<?> cls, TMethod current, String name, TClass<?>[] parameterTypes) {
        TClass<?> superclass;
        for (TMethod tMethod : cls.getDeclaredMethods()) {
            if (!TModifier.isPublic(tMethod.getModifiers()) || !tMethod.getName().equals(name) || !Arrays.equals(tMethod.getParameterTypes(), parameterTypes) || current != null && !current.getReturnType().isAssignableFrom(tMethod.getReturnType())) continue;
            current = tMethod;
        }
        if (!cls.isInterface() && (superclass = cls.getSuperclass()) != null) {
            current = TClass.findMethod(superclass, current, name, parameterTypes);
        }
        for (TAnnotatedElement tAnnotatedElement : cls.getInterfaces()) {
            current = TClass.findMethod(tAnnotatedElement, current, name, parameterTypes);
        }
        return current;
    }

    public int getModifiers() {
        int flags = this.platformClass.getMetadata().getFlags();
        int accessLevel = this.platformClass.getMetadata().getAccessLevel();
        return Flags.getModifiers(flags, accessLevel);
    }

    public boolean desiredAssertionStatus() {
        return true;
    }

    @PluggableDependency(value=ClassGenerator.class)
    public TClass<? super T> getSuperclass() {
        return TClass.getClass(this.platformClass.getMetadata().getSuperclass());
    }

    @PluggableDependency(value=ClassGenerator.class)
    public TClass<? super T>[] getInterfaces() {
        PlatformSequence<PlatformClass> supertypes = this.platformClass.getMetadata().getSupertypes();
        TClass[] filteredSupertypes = new TClass[supertypes.getLength()];
        int j = 0;
        for (int i = 0; i < supertypes.getLength(); ++i) {
            if (supertypes.get(i) == this.platformClass.getMetadata().getSuperclass()) continue;
            filteredSupertypes[j++] = TClass.getClass(supertypes.get(j));
        }
        if (filteredSupertypes.length > j) {
            filteredSupertypes = Arrays.copyOf(filteredSupertypes, j);
        }
        return filteredSupertypes;
    }

    public T[] getEnumConstants() {
        if (!this.isEnum()) {
            return null;
        }
        Platform.initClass(this.platformClass);
        return (Object[])Platform.getEnumConstants(this.platformClass).clone();
    }

    public T cast(TObject obj) {
        if (obj != null && !this.isAssignableFrom((TClass)((Object)obj.getClass()))) {
            throw new TClassCastException(obj.getClass().getName() + " is not subtype of " + this.getName());
        }
        return (T)obj;
    }

    public TClassLoader getClassLoader() {
        return TClassLoader.getSystemClassLoader();
    }

    public static TClass<?> forName(TString name) throws TClassNotFoundException {
        PlatformClass cls = Platform.lookupClass(name.toString());
        if (cls == null) {
            throw new TClassNotFoundException();
        }
        return TClass.getClass(cls);
    }

    public static TClass<?> forName(TString name, boolean initialize, TClassLoader loader) throws TClassNotFoundException {
        return TClass.forName(name);
    }

    @PluggableDependency(value=ClassDependencyListener.class)
    void initialize() {
        Platform.initClass(this.platformClass);
    }

    public T newInstance() throws TInstantiationException, TIllegalAccessException {
        Object instance = Platform.newInstance(this.platformClass);
        if (instance == null) {
            throw new TInstantiationException();
        }
        return instance;
    }

    public TClass<?> getDeclaringClass() {
        PlatformClass result = Platform.getDeclaringClass(this.getPlatformClass());
        return result != null ? TClass.getClass(result) : null;
    }

    public TClass<?> getEnclosingClass() {
        PlatformClass result = Platform.getEnclosingClass(this.getPlatformClass());
        return result != null ? TClass.getClass(result) : null;
    }

    public <U> TClass<? extends U> asSubclass(TClass<U> clazz) {
        if (!clazz.isAssignableFrom(this)) {
            throw new TClassCastException();
        }
        return this;
    }

    @Override
    public boolean isAnnotationPresent(TClass<? extends TAnnotation> annotationClass) {
        this.ensureAnnotationsByType();
        return this.annotationsByType.containsKey(annotationClass);
    }

    public <S extends TAnnotation> S getAnnotation(TClass<S> annotationClass) {
        this.ensureAnnotationsByType();
        return (S)this.annotationsByType.get(annotationClass);
    }

    @Override
    public TAnnotation[] getAnnotations() {
        if (this.annotationsCache == null) {
            this.annotationsCache = (TAnnotation[])Platform.getAnnotations(this.getPlatformClass());
        }
        return (TAnnotation[])this.annotationsCache.clone();
    }

    @Override
    public TAnnotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    private void ensureAnnotationsByType() {
        if (this.annotationsByType != null) {
            return;
        }
        this.annotationsByType = new HashMap();
        for (TAnnotation annot : this.getAnnotations()) {
            this.annotationsByType.put((TClass)((Object)annot.annotationType()), annot);
        }
    }

    public InputStream getResourceAsStream(String name) {
        if (name.startsWith("/")) {
            return this.getClassLoader().getResourceAsStream(name.substring(1));
        }
        TClass<?> cls = this;
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        String prefix = cls.getName().toString();
        int index = prefix.lastIndexOf(46);
        if (index >= 0) {
            name = prefix.substring(0, index + 1).replace('.', '/') + name;
        }
        return this.getClassLoader().getResourceAsStream(name);
    }

    public TPackage getPackage() {
        String name = this.getName();
        name = name.substring(0, name.lastIndexOf(46) + 1);
        return TPackage.getPackage(name);
    }

    private static final class MethodSignature {
        private final String name;
        private final TClass<?>[] parameterTypes;
        private final TClass<?> returnType;

        MethodSignature(String name, TClass<?>[] parameterTypes, TClass<?> returnType) {
            this.name = name;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.returnType, that.returnType);
        }

        public int hashCode() {
            return Objects.hash(this.name, Arrays.hashCode(this.parameterTypes), this.returnType);
        }
    }
}

