/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.console;

import org.teavm.backend.c.intrinsic.RuntimeInclude;
import org.teavm.classlib.PlatformDetector;
import org.teavm.interop.Import;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

public final class Console {
    private Console() {
    }

    public static void writeStderr(int b) {
        if (PlatformDetector.isC()) {
            Console.writeC(b);
        } else if (PlatformDetector.isWebAssembly()) {
            Console.writeWasm(b);
        } else {
            Console.writeJs(b);
        }
    }

    public static void writeStdout(int b) {
        if (PlatformDetector.isC()) {
            Console.writeC(b);
        } else if (PlatformDetector.isWebAssembly()) {
            Console.writeWasm(b);
        } else {
            Console.writeJsStdout(b);
        }
    }

    public static void writeStdout(String s) {
        for (int i = 0; i < s.length(); ++i) {
            Console.writeStderr(s.charAt(i));
        }
    }

    @JSBody(params={"b"}, script="$rt_putStderr(b);")
    private static native void writeJs(int var0);

    @JSBody(params={"b"}, script="$rt_putStdout(b);")
    private static native void writeJsStdout(int var0);

    @Import(name="putwchar", module="teavm")
    private static native void writeWasm(int var0);

    @Unmanaged
    @Import(name="teavm_logchar")
    @RuntimeInclude(value="log.h")
    private static native void writeC(int var0);
}

