/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.interop.Address;
import org.teavm.interop.Import;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;

@StaticInit
@Unmanaged
public final class WasmHeap {
    public static final int PAGE_SIZE = 65536;
    public static final int DEFAULT_STACK_SIZE = 262144;
    public static final int DEFAULT_REGION_SIZE = 1024;
    public static int minHeapSize;
    public static int maxHeapSize;
    public static Address storageAddress;
    public static int storageSize;
    public static Address regionsAddress;
    public static int regionsCount;
    public static int regionsSize;
    public static Address cardTable;
    public static Address heapAddress;
    public static int heapSize;
    public static int regionSize;
    public static Address memoryLimit;
    public static Address stackAddress;
    public static Address stack;
    public static int stackSize;

    private WasmHeap() {
    }

    public static int calculateStorageSize(int heapSize) {
        return heapSize / 16;
    }

    public static int calculateRegionsCount(int heapSize, int regionSize) {
        return heapSize / regionSize + 1;
    }

    public static int calculateRegionsSize(int regionsCount) {
        return regionsCount * 2;
    }

    public static native void growMemory(int var0);

    @Import(name="init", module="teavmHeapTrace")
    private static native void initHeapTrace(int var0);

    public static void initHeap(Address start, int minHeap, int maxHeap, int stackSize) {
        WasmHeap.initHeapTrace(maxHeap);
        stackAddress = start;
        stack = start;
        heapAddress = WasmRuntime.align(stackAddress.add(stackSize), 16);
        memoryLimit = WasmRuntime.align(start, 65536);
        minHeapSize = minHeap;
        maxHeapSize = maxHeap;
        WasmHeap.stackSize = stackSize;
        WasmHeap.resizeHeap(minHeap);
    }

    public static void resizeHeap(int newHeapSize) {
        if (newHeapSize <= heapSize) {
            return;
        }
        int newStorageSize = WasmHeap.calculateStorageSize(newHeapSize);
        int newRegionsCount = WasmHeap.calculateRegionsCount(newHeapSize, regionSize);
        int newRegionsSize = WasmHeap.calculateRegionsSize(newRegionsCount);
        Address newRegionsAddress = WasmRuntime.align(heapAddress.add(newHeapSize), 16);
        Address newCardTable = WasmRuntime.align(newRegionsAddress.add(newRegionsSize), 16);
        Address newStorageAddress = WasmRuntime.align(newCardTable.add(newRegionsCount), 16);
        Address newMemoryLimit = WasmRuntime.align(newStorageAddress.add(newStorageSize), 65536);
        if (newMemoryLimit != memoryLimit) {
            WasmHeap.growMemory((int)(newMemoryLimit.toLong() - memoryLimit.toLong()) / 65536);
            memoryLimit = newMemoryLimit;
        }
        if (storageSize > 0) {
            WasmRuntime.moveMemoryBlock(storageAddress, newStorageAddress, storageSize);
        }
        if (regionsSize > 0) {
            WasmRuntime.moveMemoryBlock(cardTable, newCardTable, regionsCount);
            WasmRuntime.moveMemoryBlock(regionsAddress, newRegionsAddress, regionsSize);
        }
        storageAddress = newStorageAddress;
        regionsAddress = newRegionsAddress;
        cardTable = newCardTable;
        storageSize = newStorageSize;
        regionsCount = newRegionsCount;
        regionsSize = newRegionsSize;
        heapSize = newHeapSize;
    }

    static {
        regionSize = 1024;
    }
}

