/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.MethodReference;

public class PlatformClassIntrinsic
implements Intrinsic {
    private static final String PLATFORM_CLASS = "org.teavm.platform.PlatformClass";

    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(PLATFORM_CLASS)) {
            return false;
        }
        switch (method.getName()) {
            case "getJavaClass": 
            case "getMetadata": 
            case "setJavaClass": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "getJavaClass": 
            case "getMetadata": {
                context.emit(invocation.getArguments().get(0));
                break;
            }
        }
    }
}

