/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.builder;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.callgraph.CallGraph;
import org.teavm.diagnostics.Problem;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.builder.BuildException;
import org.teavm.tooling.builder.BuildResult;
import org.teavm.tooling.builder.BuildStrategy;
import org.teavm.tooling.daemon.RemoteBuildCallback;
import org.teavm.tooling.daemon.RemoteBuildRequest;
import org.teavm.tooling.daemon.RemoteBuildResponse;
import org.teavm.tooling.daemon.RemoteBuildService;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;

public class RemoteBuildStrategy
implements BuildStrategy {
    private RemoteBuildRequest request;
    private RemoteBuildService buildService;
    private TeaVMProgressListener progressListener;
    private TeaVMToolLog log = new EmptyTeaVMToolLog();

    public RemoteBuildStrategy(RemoteBuildService buildService) {
        this.buildService = buildService;
    }

    @Override
    public void init() {
        this.request = new RemoteBuildRequest();
        this.request.optimizationLevel = TeaVMOptimizationLevel.ADVANCED;
        this.request.wasmVersion = WasmBinaryVersion.V_0x1;
        this.request.longjmpSupported = true;
    }

    @Override
    public void addSourcesDirectory(String directory) {
        this.request.sourceDirectories.add(directory);
    }

    @Override
    public void addSourcesJar(String jarFile) {
        this.request.sourceJarFiles.add(jarFile);
    }

    @Override
    public void setClassPathEntries(List<String> entries) {
        this.request.classPath.addAll(entries);
    }

    @Override
    public void setTargetType(TeaVMTargetType targetType) {
        this.request.targetType = targetType;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.request.mainClass = mainClass;
    }

    @Override
    public void setEntryPointName(String entryPointName) {
        this.request.entryPointName = entryPointName;
    }

    @Override
    public void setTargetDirectory(String targetDirectory) {
        this.request.targetDirectory = targetDirectory;
    }

    @Override
    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.request.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    @Override
    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.request.debugInformationGenerated = debugInformationGenerated;
    }

    @Override
    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.request.sourceFilesCopied = sourceFilesCopied;
    }

    @Override
    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public void setIncremental(boolean incremental) {
        this.request.incremental = incremental;
    }

    @Override
    public void setProperties(Properties properties) {
        this.request.properties = new Properties();
        this.request.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    @Override
    public void setMinifying(boolean minifying) {
        this.request.minifying = minifying;
    }

    @Override
    public void setMaxTopLevelNames(int maxTopLevelNames) {
        this.request.maxTopLevelNames = maxTopLevelNames;
    }

    @Override
    public void setTransformers(String[] transformers) {
        this.request.transformers = (String[])transformers.clone();
    }

    @Override
    public void setOptimizationLevel(TeaVMOptimizationLevel level) {
        this.request.optimizationLevel = level;
    }

    @Override
    public void setFastDependencyAnalysis(boolean value) {
        this.request.fastDependencyAnalysis = value;
    }

    @Override
    public void setTargetFileName(String targetFileName) {
        this.request.tagetFileName = targetFileName;
    }

    @Override
    public void setClassesToPreserve(String[] classesToPreserve) {
        this.request.classesToPreserve = (String[])classesToPreserve.clone();
    }

    @Override
    public void setCacheDirectory(String cacheDirectory) {
        this.request.cacheDirectory = cacheDirectory;
    }

    @Override
    public void setWasmVersion(WasmBinaryVersion wasmVersion) {
        this.request.wasmVersion = wasmVersion;
    }

    @Override
    public void setHeapSize(int heapSize) {
        this.request.heapSize = heapSize;
    }

    @Override
    public void setLongjmpSupported(boolean value) {
        this.request.longjmpSupported = value;
    }

    @Override
    public void setHeapDump(boolean heapDump) {
        this.request.heapDump = heapDump;
    }

    @Override
    public BuildResult build() throws BuildException {
        RemoteBuildResponse response;
        try {
            response = this.buildService.build(this.request, new CallbackImpl(this.progressListener, this.log));
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
        if (response.exception != null) {
            throw new BuildException(response.exception);
        }
        return new BuildResult(){
            private ProblemProvider problems = new ProblemProvider(){

                @Override
                public List<Problem> getProblems() {
                    return response.problems;
                }

                @Override
                public List<Problem> getSevereProblems() {
                    return response.severeProblems;
                }
            };

            @Override
            public CallGraph getCallGraph() {
                return response.callGraph;
            }

            @Override
            public ProblemProvider getProblems() {
                return this.problems;
            }

            @Override
            public Collection<String> getUsedResources() {
                return response.usedResources;
            }

            @Override
            public Collection<String> getClasses() {
                return response.classes;
            }

            @Override
            public Collection<String> getGeneratedFiles() {
                return response.generatedFiles;
            }
        };
    }

    static class CallbackImpl
    extends UnicastRemoteObject
    implements RemoteBuildCallback {
        private TeaVMProgressListener listener;
        private TeaVMToolLog log;

        CallbackImpl(TeaVMProgressListener listener, TeaVMToolLog log) throws RemoteException {
            this.listener = listener;
            this.log = log;
        }

        @Override
        public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
            return this.listener != null ? this.listener.phaseStarted(phase, count) : TeaVMProgressFeedback.CONTINUE;
        }

        @Override
        public TeaVMProgressFeedback progressReached(int progress) {
            return this.listener != null ? this.listener.progressReached(progress) : TeaVMProgressFeedback.CONTINUE;
        }

        @Override
        public void errorReported(String message, Throwable e) {
            this.log.error(message, e);
        }

        @Override
        public void errorReported(String message) {
            this.log.error(message);
        }

        @Override
        public void warningReported(String message, Throwable e) {
            this.log.warning(message, e);
        }

        @Override
        public void warningReported(String message) {
            this.log.warning(message);
        }

        @Override
        public void infoReported(String message, Throwable e) {
            this.log.info(message, e);
        }

        @Override
        public void infoReported(String message) {
            this.log.info(message);
        }
    }
}

