/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teavm.common.DisjointSet;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphUtils;
import org.teavm.hppc.IntArrayList;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.lowlevel.Characteristics;
import org.teavm.model.lowlevel.NativePointerFinder;
import org.teavm.model.lowlevel.SpilledPhisFinder;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.GraphColorer;
import org.teavm.model.util.LivenessAnalyzer;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.TypeInferer;
import org.teavm.model.util.UsageExtractor;
import org.teavm.model.util.VariableType;
import org.teavm.runtime.ShadowStack;

public class GCShadowStackContributor {
    private Characteristics characteristics;
    private NativePointerFinder nativePointerFinder;

    public GCShadowStackContributor(Characteristics characteristics) {
        this.characteristics = characteristics;
        this.nativePointerFinder = new NativePointerFinder(characteristics);
    }

    public int contribute(Program program, MethodReader method) {
        List<Map<Instruction, BitSet>> liveInInformation = this.findCallSiteLiveIns(program, method);
        boolean[] spilled = this.getAffectedVariables(liveInInformation, program);
        int[] variableClasses = this.getVariableClasses(program);
        Graph interferenceGraph = this.buildInterferenceGraph(liveInInformation, program, spilled, variableClasses);
        int[] classColors = new int[interferenceGraph.size()];
        Arrays.fill(classColors, -1);
        new GraphColorer().colorize(interferenceGraph, classColors);
        int[] colors = new int[interferenceGraph.size()];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = classColors[variableClasses[i]];
        }
        int usedColors = 0;
        for (int var = 0; var < colors.length; ++var) {
            if (spilled[var]) {
                usedColors = Math.max(usedColors, colors[var]);
                int n = var;
                colors[n] = colors[n] - 1;
                continue;
            }
            colors[var] = -1;
        }
        if (usedColors == 0) {
            return 0;
        }
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        DominatorTree dom = GraphUtils.buildDominatorTree(cfg);
        boolean[] autoSpilled = new SpilledPhisFinder(liveInInformation, dom, program).find();
        List<Map<Instruction, int[]>> liveInStores = this.reduceGCRootStores(dom, program, usedColors, liveInInformation, colors, autoSpilled);
        this.putLiveInGCRoots(program, liveInStores);
        return usedColors;
    }

    private int[] getVariableClasses(Program program) {
        DisjointSet variableClasses = new DisjointSet();
        for (int i = 0; i < program.variableCount(); ++i) {
            variableClasses.create();
        }
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    variableClasses.union(phi.getReceiver().getIndex(), incoming.getValue().getIndex());
                }
            }
        }
        return variableClasses.pack(program.variableCount());
    }

    private List<Map<Instruction, BitSet>> findCallSiteLiveIns(Program program, MethodReader method) {
        boolean[] nativePointers = this.nativePointerFinder.findNativePointers(method.getReference(), program);
        TypeInferer typeInferer = new TypeInferer();
        typeInferer.inferTypes(program, method.getReference());
        ArrayList<Map<Instruction, BitSet>> liveInInformation = new ArrayList<Map<Instruction, BitSet>>();
        LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer();
        livenessAnalyzer.analyze(program, method.getDescriptor());
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            HashMap<Instruction, BitSet> blockLiveIn = new HashMap<Instruction, BitSet>();
            liveInInformation.add(blockLiveIn);
            BitSet currentLiveOut = livenessAnalyzer.liveOut(i);
            for (Instruction insn = block.getLastInstruction(); insn != null; insn = insn.getPrevious()) {
                insn.acceptVisitor(defExtractor);
                insn.acceptVisitor(useExtractor);
                for (Variable usedVar : useExtractor.getUsedVariables()) {
                    currentLiveOut.set(usedVar.getIndex());
                }
                for (Variable definedVar : defExtractor.getDefinedVariables()) {
                    currentLiveOut.clear(definedVar.getIndex());
                }
                if (!(insn instanceof InvokeInstruction) && !(insn instanceof InitClassInstruction) && !(insn instanceof ConstructInstruction) && !(insn instanceof ConstructArrayInstruction) && !(insn instanceof ConstructMultiArrayInstruction) && !(insn instanceof CloneArrayInstruction) && !(insn instanceof RaiseInstruction) && !(insn instanceof NullCheckInstruction) && !(insn instanceof MonitorEnterInstruction) && !(insn instanceof MonitorExitInstruction) || insn instanceof InvokeInstruction && !this.characteristics.isManaged(((InvokeInstruction)insn).getMethod())) continue;
                BitSet csLiveIn = (BitSet)currentLiveOut.clone();
                int v = csLiveIn.nextSetBit(0);
                while (v >= 0) {
                    if (!this.isReference(typeInferer, v) || nativePointers[v]) {
                        csLiveIn.clear(v);
                    }
                    v = csLiveIn.nextSetBit(v + 1);
                }
                csLiveIn.clear(0, method.parameterCount() + 1);
                blockLiveIn.put(insn, csLiveIn);
            }
            if (block.getExceptionVariable() == null) continue;
            currentLiveOut.clear(block.getExceptionVariable().getIndex());
        }
        return liveInInformation;
    }

    private Graph buildInterferenceGraph(List<Map<Instruction, BitSet>> liveInInformation, Program program, boolean[] spilled, int[] variableClasses) {
        GraphBuilder builder = new GraphBuilder(program.variableCount());
        for (Map<Instruction, BitSet> blockLiveIn : liveInInformation) {
            for (BitSet liveVarsSet : blockLiveIn.values()) {
                IntArrayList liveVars = new IntArrayList();
                int i = liveVarsSet.nextSetBit(0);
                while (i >= 0) {
                    liveVars.add(i);
                    i = liveVarsSet.nextSetBit(i + 1);
                }
                int[] liveVarArray = liveVars.toArray();
                for (int i2 = 0; i2 < liveVarArray.length - 1; ++i2) {
                    for (int j = i2 + 1; j < liveVarArray.length; ++j) {
                        int a = liveVarArray[i2];
                        int b = liveVarArray[j];
                        if (!spilled[a] || !spilled[b]) continue;
                        builder.addEdge(variableClasses[a], variableClasses[b]);
                        builder.addEdge(variableClasses[b], variableClasses[a]);
                    }
                }
            }
        }
        return builder.build();
    }

    private boolean[] getAffectedVariables(List<Map<Instruction, BitSet>> liveInInformation, Program program) {
        boolean[] affectedVariables = new boolean[program.variableCount()];
        for (Map<Instruction, BitSet> blockLiveIn : liveInInformation) {
            for (BitSet liveVarsSet : blockLiveIn.values()) {
                int i = liveVarsSet.nextSetBit(0);
                while (i >= 0) {
                    affectedVariables[i] = true;
                    i = liveVarsSet.nextSetBit(i + 1);
                }
            }
        }
        return affectedVariables;
    }

    private List<Map<Instruction, int[]>> reduceGCRootStores(DominatorTree dom, Program program, final int usedColors, List<Map<Instruction, BitSet>> liveInInformation, int[] colors, boolean[] autoSpilled) {
        ArrayList<Map<Instruction, int[]>> slotsToUpdate = new ArrayList<Map<Instruction, int[]>>();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            slotsToUpdate.add(new LinkedHashMap());
        }
        Graph domGraph = GraphUtils.buildDominatorGraph(dom, program.basicBlockCount());
        Step[] stack = new Step[program.basicBlockCount() * 2];
        int head = 0;
        class Step {
            private final int node;
            private final int[] slotStates;

            Step(int node) {
                this.slotStates = new int[usedColors];
                this.node = node;
            }
        }
        Step start = new Step(0);
        Arrays.fill(start.slotStates, program.variableCount());
        stack[head++] = start;
        int[] definitionClasses = this.getDefinitionClasses(program);
        while (head > 0) {
            Step step = stack[--head];
            int[] previousStates = step.slotStates;
            int[] states = (int[])previousStates.clone();
            Map<Instruction, BitSet> callSites = liveInInformation.get(step.node);
            Map updatesByCallSite = (Map)slotsToUpdate.get(step.node);
            for (Instruction callSiteLocation : this.sortInstructions(callSites.keySet(), program.basicBlockAt(step.node))) {
                BitSet liveIns = callSites.get(callSiteLocation);
                int liveVar = liveIns.nextSetBit(0);
                while (liveVar >= 0) {
                    int slot = colors[liveVar];
                    states[slot] = liveVar;
                    liveVar = liveIns.nextSetBit(liveVar + 1);
                }
                for (int slot = 0; slot < states.length; ++slot) {
                    if (states[slot] < 0 || liveIns.get(states[slot])) continue;
                    states[slot] = -1;
                }
                int[] updates = GCShadowStackContributor.compareStates(previousStates, states, autoSpilled, definitionClasses);
                updatesByCallSite.put(callSiteLocation, updates);
                previousStates = states;
                states = (int[])states.clone();
            }
            for (Object succ : (Object)domGraph.outgoingEdges(step.node)) {
                Step next = new Step((int)succ);
                System.arraycopy(states, 0, next.slotStates, 0, usedColors);
                stack[head++] = next;
            }
        }
        return slotsToUpdate;
    }

    private int[] getDefinitionClasses(Program program) {
        DisjointSet disjointSet = new DisjointSet();
        for (int i = 0; i < program.variableCount(); ++i) {
            disjointSet.create();
        }
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                if (!(instruction instanceof NullCheckInstruction)) continue;
                NullCheckInstruction nullCheck = (NullCheckInstruction)instruction;
                disjointSet.union(nullCheck.getValue().getIndex(), nullCheck.getReceiver().getIndex());
            }
        }
        return disjointSet.pack(program.variableCount());
    }

    private List<Instruction> sortInstructions(Collection<Instruction> instructions, BasicBlock block) {
        ObjectIntHashMap<Instruction> indexes = new ObjectIntHashMap<Instruction>();
        int index = 0;
        for (Instruction instruction : block) {
            indexes.put(instruction, index++);
        }
        ArrayList<Instruction> sortedInstructions = new ArrayList<Instruction>(instructions);
        sortedInstructions.sort(Comparator.comparing(insn -> indexes.getOrDefault((Instruction)insn, -1)));
        return sortedInstructions;
    }

    private static int[] compareStates(int[] oldStates, int[] newStates, boolean[] autoSpilled, int[] definitionClasses) {
        int i;
        int[] comparison = new int[oldStates.length];
        Arrays.fill(comparison, -2);
        for (i = 0; i < oldStates.length; ++i) {
            int oldState = oldStates[i];
            int newState = newStates[i];
            if (oldState >= 0 && oldState < definitionClasses.length) {
                oldState = definitionClasses[oldState];
            }
            if (newState >= 0 && newState < definitionClasses.length) {
                newState = definitionClasses[newState];
            }
            if (oldState == newState) continue;
            comparison[i] = newStates[i];
        }
        for (i = 0; i < newStates.length; ++i) {
            if (newStates[i] < 0 || !autoSpilled[newStates[i]]) continue;
            comparison[i] = -2;
        }
        return comparison;
    }

    private void putLiveInGCRoots(Program program, List<Map<Instruction, int[]>> updateInformation) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Map<Instruction, int[]> updatesByIndex = updateInformation.get(i);
            Instruction[] callSiteLocations = updatesByIndex.keySet().toArray(new Instruction[0]);
            ObjectIntMap<Instruction> instructionIndexes = this.getInstructionIndexes(block);
            Arrays.sort(callSiteLocations, Comparator.comparing(instructionIndexes::get));
            for (Instruction callSiteLocation : callSiteLocations) {
                int[] updates = updatesByIndex.get(callSiteLocation);
                this.storeLiveIns(block, callSiteLocation, updates);
            }
        }
    }

    private ObjectIntMap<Instruction> getInstructionIndexes(BasicBlock block) {
        ObjectIntHashMap<Instruction> indexes = new ObjectIntHashMap<Instruction>();
        for (Instruction instruction : block) {
            indexes.put(instruction, indexes.size());
        }
        return indexes;
    }

    private void storeLiveIns(BasicBlock block, Instruction callInstruction, int[] updates) {
        Program program = block.getProgram();
        ArrayList<Instruction> instructionsToAdd = new ArrayList<Instruction>();
        for (int slot = 0; slot < updates.length; ++slot) {
            int var = updates[slot];
            if (var == -2) continue;
            Variable slotVar = program.createVariable();
            IntegerConstantInstruction slotConstant = new IntegerConstantInstruction();
            slotConstant.setReceiver(slotVar);
            slotConstant.setConstant(slot);
            slotConstant.setLocation(callInstruction.getLocation());
            instructionsToAdd.add(slotConstant);
            ArrayList<Variable> arguments = new ArrayList<Variable>();
            InvokeInstruction registerInvocation = new InvokeInstruction();
            registerInvocation.setLocation(callInstruction.getLocation());
            registerInvocation.setType(InvocationType.SPECIAL);
            arguments.add(slotVar);
            if (var >= 0) {
                registerInvocation.setMethod(new MethodReference(ShadowStack.class, "registerGCRoot", Integer.TYPE, Object.class, Void.TYPE));
                arguments.add(program.variableAt(var));
            } else {
                registerInvocation.setMethod(new MethodReference(ShadowStack.class, "removeGCRoot", Integer.TYPE, Void.TYPE));
            }
            registerInvocation.setArguments(arguments.toArray(new Variable[0]));
            instructionsToAdd.add(registerInvocation);
        }
        callInstruction.insertPreviousAll(instructionsToAdd);
    }

    private boolean isReference(TypeInferer typeInferer, int var) {
        VariableType liveType = typeInferer.typeOf(var);
        switch (liveType) {
            case BYTE_ARRAY: 
            case CHAR_ARRAY: 
            case SHORT_ARRAY: 
            case INT_ARRAY: 
            case FLOAT_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: 
            case OBJECT_ARRAY: 
            case OBJECT: {
                return true;
            }
        }
        return false;
    }
}

