/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TStreamOverSpliterator<T>
extends TSimpleStreamImpl<T> {
    private Spliterator<T> spliterator;

    public TStreamOverSpliterator(Spliterator<T> spliterator) {
        this.spliterator = spliterator;
    }

    @Override
    public boolean next(Predicate<? super T> consumer) {
        AdapterAction<? super T> action = new AdapterAction<T>(consumer);
        while (this.spliterator.tryAdvance(action)) {
            if (action.wantsMore) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int estimateSize() {
        return (int)this.spliterator.estimateSize();
    }

    @Override
    public long count() {
        return this.spliterator.hasCharacteristics(64) ? (long)((int)this.spliterator.estimateSize()) : super.count();
    }

    static class AdapterAction<T>
    implements Consumer<T> {
        private Predicate<? super T> consumer;
        boolean wantsMore;

        AdapterAction(Predicate<? super T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(T t) {
            this.wantsMore = this.consumer.test(t);
        }
    }
}

