/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.teavm.ast.AsyncMethodNode;
import org.teavm.ast.AsyncMethodPart;
import org.teavm.ast.MethodNode;
import org.teavm.ast.MethodNodeVisitor;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.VariableNode;
import org.teavm.backend.javascript.codegen.NamingOrderer;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.codegen.ScopedName;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.decompile.PreparedClass;
import org.teavm.backend.javascript.decompile.PreparedMethod;
import org.teavm.backend.javascript.rendering.NameFrequencyEstimator;
import org.teavm.backend.javascript.rendering.RenderingContext;
import org.teavm.backend.javascript.rendering.RenderingManager;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.rendering.StatementRenderer;
import org.teavm.backend.javascript.rendering.TryCatchFinder;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.common.ServiceRepository;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.DummyDebugInformationEmitter;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.vm.RenderingException;
import org.teavm.vm.TeaVMProgressFeedback;

public class Renderer
implements RenderingManager {
    private final NamingStrategy naming;
    private final SourceWriter writer;
    private final ListableClassReaderSource classSource;
    private final ClassLoader classLoader;
    private boolean minifying;
    private final Properties properties = new Properties();
    private final ServiceRepository services;
    private DebugInformationEmitter debugEmitter = new DummyDebugInformationEmitter();
    private final Set<MethodReference> asyncMethods;
    private final Set<MethodReference> asyncFamilyMethods;
    private final Diagnostics diagnostics;
    private RenderingContext context;
    private List<PostponedFieldInitializer> postponedFieldInitializers = new ArrayList<PostponedFieldInitializer>();
    private IntFunction<TeaVMProgressFeedback> progressConsumer = p -> TeaVMProgressFeedback.CONTINUE;
    public static final MethodDescriptor CLINIT_METHOD = new MethodDescriptor("<clinit>", ValueType.VOID);
    private ObjectIntMap<String> sizeByClass = new ObjectIntHashMap<String>();
    private int stringPoolSize;
    private int metadataSize;
    private boolean longLibraryUsed;
    private boolean threadLibraryUsed;

    public Renderer(SourceWriter writer, Set<MethodReference> asyncMethods, Set<MethodReference> asyncFamilyMethods, Diagnostics diagnostics, RenderingContext context) {
        this.naming = context.getNaming();
        this.writer = writer;
        this.classSource = context.getClassSource();
        this.classLoader = context.getClassLoader();
        this.services = context.getServices();
        this.asyncMethods = new HashSet<MethodReference>(asyncMethods);
        this.asyncFamilyMethods = new HashSet<MethodReference>(asyncFamilyMethods);
        this.diagnostics = diagnostics;
        this.context = context;
    }

    public boolean isLongLibraryUsed() {
        return this.longLibraryUsed;
    }

    public boolean isThreadLibraryUsed() {
        return this.threadLibraryUsed;
    }

    public int getStringPoolSize() {
        return this.stringPoolSize;
    }

    public int getMetadataSize() {
        return this.metadataSize;
    }

    public String[] getClassesInStats() {
        return this.sizeByClass.keys().toArray(String.class);
    }

    public int getClassSize(String className) {
        return this.sizeByClass.getOrDefault(className, 0);
    }

    @Override
    public SourceWriter getWriter() {
        return this.writer;
    }

    @Override
    public NamingStrategy getNaming() {
        return this.naming;
    }

    @Override
    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    @Override
    public ListableClassReaderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        return properties;
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void setDebugEmitter(DebugInformationEmitter debugEmitter) {
        this.debugEmitter = debugEmitter;
    }

    public void setProgressConsumer(IntFunction<TeaVMProgressFeedback> progressConsumer) {
        this.progressConsumer = progressConsumer;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void renderStringPool() throws RenderingException {
        if (this.context.getStringPool().isEmpty()) {
            return;
        }
        try {
            int start = this.writer.getOffset();
            this.writer.append("$rt_stringPool([");
            for (int i = 0; i < this.context.getStringPool().size(); ++i) {
                if (i > 0) {
                    this.writer.append(',').ws();
                }
                RenderingUtil.writeString(this.writer, this.context.getStringPool().get(i));
            }
            this.writer.append("]);").newLine();
            this.stringPoolSize = this.writer.getOffset() - start;
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    public void renderStringConstants() throws RenderingException {
        try {
            for (PostponedFieldInitializer initializer : this.postponedFieldInitializers) {
                int start = this.writer.getOffset();
                this.writer.appendStaticField(initializer.field).ws().append("=").ws();
                this.context.constantToString(this.writer, initializer.value);
                this.writer.append(";").softNewLine();
                int sz = this.writer.getOffset() - start;
                this.appendClassSize(initializer.field.getClassName(), sz);
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    public void renderCompatibilityStubs() throws RenderingException {
        try {
            this.renderJavaStringToString();
            this.renderJavaObjectToString();
            this.renderTeaVMClass();
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    private void renderJavaStringToString() throws IOException {
        this.writer.appendClass("java.lang.String").append(".prototype.toString").ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        this.writer.append("return $rt_ustr(this);").softNewLine();
        this.writer.outdent().append("};").newLine();
        this.writer.appendClass("java.lang.String").append(".prototype.valueOf").ws().append("=").ws().appendClass("java.lang.String").append(".prototype.toString;").softNewLine();
    }

    private void renderJavaObjectToString() throws IOException {
        this.writer.appendClass("java.lang.Object").append(".prototype.toString").ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        this.writer.append("return $rt_ustr(").appendMethodBody(Object.class, "toString", String.class).append("(this));").softNewLine();
        this.writer.outdent().append("};").newLine();
    }

    private void renderTeaVMClass() throws IOException {
        this.writer.appendClass("java.lang.Object").append(".prototype.__teavm_class__").ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        this.writer.append("return $dbg_class(this);").softNewLine();
        this.writer.outdent().append("};").newLine();
    }

    private void appendClassSize(String className, int sz) {
        this.sizeByClass.put(className, this.sizeByClass.getOrDefault(className, 0) + sz);
    }

    private void renderRuntimeAliases() throws IOException {
        String[] names = new String[]{"$rt_throw", "$rt_compare", "$rt_nullCheck", "$rt_cls", "$rt_createArray", "$rt_isInstance", "$rt_nativeThread", "$rt_suspending", "$rt_resuming", "$rt_invalidPointer", "$rt_s", "$rt_eraseClinit", "$rt_imul", "$rt_wrapException"};
        boolean first = true;
        for (String name : names) {
            if (!first) {
                this.writer.softNewLine();
            }
            first = false;
            this.writer.append("var ").appendFunction(name).ws().append('=').ws().append(name).append(";").softNewLine();
        }
        this.writer.newLine();
    }

    public void prepare(List<PreparedClass> classes) {
        if (this.minifying) {
            NamingOrderer orderer = new NamingOrderer();
            NameFrequencyEstimator estimator = new NameFrequencyEstimator(orderer, this.classSource, this.asyncMethods, this.asyncFamilyMethods);
            for (PreparedClass cls : classes) {
                estimator.estimate(cls);
            }
            this.naming.getScopeName();
            orderer.apply(this.naming);
        }
    }

    public boolean render(List<PreparedClass> classes) throws RenderingException {
        if (this.minifying) {
            try {
                this.renderRuntimeAliases();
            }
            catch (IOException e) {
                throw new RenderingException(e);
            }
        }
        int index = 0;
        for (PreparedClass cls : classes) {
            int start = this.writer.getOffset();
            this.renderDeclaration(cls);
            this.renderMethodBodies(cls);
            this.appendClassSize(cls.getName(), this.writer.getOffset() - start);
            if (this.progressConsumer.apply(1000 * ++index / classes.size()) != TeaVMProgressFeedback.CANCEL) continue;
            return false;
        }
        this.renderClassMetadata(classes);
        return true;
    }

    private void renderDeclaration(PreparedClass cls) throws RenderingException {
        ScopedName jsName = this.naming.getNameFor(cls.getName());
        this.debugEmitter.addClass(jsName.value, cls.getName(), cls.getParentName());
        try {
            FieldReference fieldRef;
            Object value;
            this.renderFunctionDeclaration(jsName);
            this.writer.append("()").ws().append("{").indent().softNewLine();
            boolean thisAliased = false;
            ArrayList<FieldHolder> nonStaticFields = new ArrayList<FieldHolder>();
            ArrayList<FieldHolder> staticFields = new ArrayList<FieldHolder>();
            for (FieldHolder field : cls.getClassHolder().getFields()) {
                if (field.getModifiers().contains((Object)ElementModifier.STATIC)) {
                    staticFields.add(field);
                    continue;
                }
                nonStaticFields.add(field);
            }
            if (nonStaticFields.size() > 1) {
                thisAliased = true;
                this.writer.append("var a").ws().append("=").ws().append("this;").ws();
            }
            if (!cls.getClassHolder().getModifiers().contains((Object)ElementModifier.INTERFACE) && cls.getParentName() != null) {
                this.writer.appendClass(cls.getParentName()).append(".call(").append(thisAliased ? "a" : "this").append(");").softNewLine();
            }
            for (FieldHolder field : nonStaticFields) {
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                fieldRef = new FieldReference(cls.getName(), field.getName());
                this.writer.append(thisAliased ? "a" : "this").append(".").appendField(fieldRef).ws().append("=").ws();
                this.context.constantToString(this.writer, value);
                this.writer.append(";").softNewLine();
                this.debugEmitter.addField(field.getName(), this.naming.getNameFor(fieldRef));
            }
            if (cls.getName().equals("java.lang.Object")) {
                this.writer.append("this.$id$").ws().append('=').ws().append("0;").softNewLine();
            }
            this.writer.outdent().append("}");
            if (jsName.scoped) {
                this.writer.append(";");
            }
            this.writer.newLine();
            for (FieldHolder field : staticFields) {
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                fieldRef = new FieldReference(cls.getName(), field.getName());
                if (value instanceof String) {
                    this.context.lookupString((String)value);
                    this.postponedFieldInitializers.add(new PostponedFieldInitializer(fieldRef, (String)value));
                    value = null;
                }
                ScopedName fieldName = this.naming.getFullNameFor(fieldRef);
                if (fieldName.scoped) {
                    this.writer.append(this.naming.getScopeName()).append(".");
                } else {
                    this.writer.append("var ");
                }
                this.writer.append(fieldName.value).ws().append("=").ws();
                this.context.constantToString(this.writer, value);
                this.writer.append(";").softNewLine();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private void renderMethodBodies(PreparedClass cls) throws RenderingException {
        this.debugEmitter.emitClass(cls.getName());
        try {
            MethodReader clinit = this.classSource.get(cls.getName()).getMethod(CLINIT_METHOD);
            if (clinit != null && this.context.isDynamicInitializer(cls.getName())) {
                this.renderCallClinit(clinit, cls);
            }
            if (!cls.getClassHolder().getModifiers().contains((Object)ElementModifier.INTERFACE)) {
                for (PreparedMethod method : cls.getMethods()) {
                    if (method.methodHolder.getModifiers().contains((Object)ElementModifier.STATIC) || !method.reference.getName().equals("<init>")) continue;
                    this.renderInitializer(method);
                }
            }
            for (PreparedMethod method : cls.getMethods()) {
                this.renderBody(method);
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
        this.debugEmitter.emitClass(null);
    }

    private void renderCallClinit(MethodReader clinit, PreparedClass cls) throws IOException {
        boolean isAsync = this.asyncMethods.contains(clinit.getReference());
        ScopedName className = this.naming.getNameFor(cls.getName());
        String clinitCalled = (className.scoped ? this.naming.getScopeName() + "_" : "") + className.value + "_$clinitCalled";
        if (isAsync) {
            this.writer.append("var ").append(clinitCalled).ws().append("=").ws().append("false;").softNewLine();
        }
        ScopedName name = this.naming.getNameForClassInit(cls.getName());
        this.renderFunctionDeclaration(name);
        this.writer.append("()").ws().append("{").softNewLine().indent();
        if (isAsync) {
            this.writer.append("var ").append(this.context.pointerName()).ws().append("=").ws().append("0").append(";").softNewLine();
            this.writer.append("if").ws().append("(").appendFunction("$rt_resuming").append("())").ws().append("{").indent().softNewLine();
            this.writer.append(this.context.pointerName()).ws().append("=").ws().appendFunction("$rt_nativeThread").append("().pop();").softNewLine();
            this.writer.outdent().append("}").ws();
            this.writer.append("else if").ws().append("(").append(clinitCalled).append(")").ws().append("{").indent().softNewLine();
            this.writer.append("return;").softNewLine();
            this.writer.outdent().append("}").softNewLine();
            this.renderAsyncPrologue();
            this.writer.append("case 0:").indent().softNewLine();
            this.writer.append(clinitCalled).ws().append('=').ws().append("true;").softNewLine();
        } else {
            this.renderEraseClinit(cls);
        }
        if (isAsync) {
            this.writer.append(this.context.pointerName()).ws().append("=").ws().append("1;").softNewLine();
            this.writer.outdent().append("case 1:").indent().softNewLine();
        }
        this.writer.appendMethodBody(new MethodReference(cls.getName(), clinit.getDescriptor())).append("();").softNewLine();
        if (isAsync) {
            this.writer.append("if").ws().append("(").appendFunction("$rt_suspending").append("())").ws().append("{").indent().softNewLine();
            this.writer.append("break " + this.context.mainLoopName() + ";").softNewLine();
            this.writer.outdent().append("}").softNewLine();
            this.renderEraseClinit(cls);
            this.writer.append("return;").softNewLine().outdent();
            this.renderAsyncEpilogue();
            this.writer.appendFunction("$rt_nativeThread").append("().push(" + this.context.pointerName() + ");").softNewLine();
        }
        this.writer.outdent().append("}");
        if (name.scoped) {
            this.writer.append(";");
        }
        this.writer.newLine();
    }

    private void renderEraseClinit(PreparedClass cls) throws IOException {
        this.writer.appendClassInit(cls.getName()).ws().append("=").ws().appendFunction("$rt_eraseClinit").append("(").appendClass(cls.getName()).append(");").softNewLine();
    }

    private void renderClassMetadata(List<PreparedClass> classes) {
        if (classes.isEmpty()) {
            return;
        }
        Set<String> classesRequiringName = this.findClassesRequiringName();
        int start = this.writer.getOffset();
        try {
            this.writer.append("$rt_packages([");
            ObjectIntMap<String> packageIndexes = this.generatePackageMetadata(classes, classesRequiringName);
            this.writer.append("]);").newLine();
            for (int i = 0; i < classes.size(); i += 50) {
                int j = Math.min(i + 50, classes.size());
                this.renderClassMetadataPortion(classes.subList(i, j), packageIndexes, classesRequiringName);
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
        this.metadataSize = this.writer.getOffset() - start;
    }

    private void renderClassMetadataPortion(List<PreparedClass> classes, ObjectIntMap<String> packageIndexes, Set<String> classesRequiringName) throws IOException {
        this.writer.append("$rt_metadata([");
        boolean first = true;
        for (PreparedClass cls : classes) {
            if (!first) {
                this.writer.append(',').softNewLine();
            }
            first = false;
            this.debugEmitter.emitClass(cls.getName());
            this.writer.appendClass(cls.getName()).append(",").ws();
            if (classesRequiringName.contains(cls.getName())) {
                String className = cls.getName();
                int dotIndex = className.lastIndexOf(46) + 1;
                String packageName = className.substring(0, dotIndex);
                className = className.substring(dotIndex);
                this.writer.append("\"").append(RenderingUtil.escapeString(className)).append("\"").append(",").ws();
                this.writer.append(String.valueOf(packageIndexes.getOrDefault(packageName, -1)));
            } else {
                this.writer.append("0");
            }
            this.writer.append(",").ws();
            if (cls.getParentName() != null) {
                this.writer.appendClass(cls.getParentName());
            } else {
                this.writer.append("0");
            }
            this.writer.append(',').ws();
            this.writer.append("[");
            ArrayList<String> interfaces = new ArrayList<String>(cls.getClassHolder().getInterfaces());
            for (int i = 0; i < interfaces.size(); ++i) {
                String iface = (String)interfaces.get(i);
                if (i > 0) {
                    this.writer.append(",").ws();
                }
                this.writer.appendClass(iface);
            }
            this.writer.append("],").ws();
            this.writer.append(ElementModifier.pack(cls.getClassHolder().getModifiers())).append(',').ws();
            this.writer.append(cls.getClassHolder().getLevel().ordinal()).append(',').ws();
            MethodReader clinit = this.classSource.get(cls.getName()).getMethod(CLINIT_METHOD);
            if (clinit != null && this.context.isDynamicInitializer(cls.getName())) {
                this.writer.appendClassInit(cls.getName());
            } else {
                this.writer.append('0');
            }
            this.writer.append(',').ws();
            ArrayList<MethodReference> virtualMethods = new ArrayList<MethodReference>();
            for (PreparedMethod method : cls.getMethods()) {
                if (method.methodHolder.getModifiers().contains((Object)ElementModifier.STATIC)) continue;
                virtualMethods.add(method.reference);
            }
            this.collectMethodsToCopyFromInterfaces(this.classSource.get(cls.getName()), virtualMethods);
            this.renderVirtualDeclarations(virtualMethods);
            this.debugEmitter.emitClass(null);
        }
        this.writer.append("]);").newLine();
    }

    private ObjectIntMap<String> generatePackageMetadata(List<PreparedClass> classes, Set<String> classesRequiringName) throws IOException {
        PackageNode root = new PackageNode(null);
        for (PreparedClass classNode : classes) {
            int dotIndex;
            String className = classNode.getName();
            if (!classesRequiringName.contains(className) || (dotIndex = className.lastIndexOf(46)) < 0) continue;
            this.addPackageName(root, className.substring(0, dotIndex));
        }
        ObjectIntHashMap<String> indexes = new ObjectIntHashMap<String>();
        this.writePackageStructure(root, -1, "", indexes);
        this.writer.softNewLine();
        return indexes;
    }

    private int writePackageStructure(PackageNode node, int startIndex, String prefix, ObjectIntMap<String> indexes) throws IOException {
        int index = startIndex;
        for (PackageNode child : node.children.values()) {
            if (index >= 0) {
                this.writer.append(",").ws();
            }
            this.writer.append(String.valueOf(startIndex)).append(",").ws().append("\"").append(RenderingUtil.escapeString(child.name)).append("\"");
            String fullName = prefix + child.name + ".";
            indexes.put(fullName, ++index);
            index = this.writePackageStructure(child, index, fullName, indexes);
        }
        return index;
    }

    private void addPackageName(PackageNode node, String name) {
        String[] parts;
        for (String part : parts = name.split("\\.")) {
            node = node.children.computeIfAbsent(part, PackageNode::new);
        }
    }

    private Set<String> findClassesRequiringName() {
        MethodDependencyInfo getSimpleNameMethod;
        HashSet<String> classesRequiringName = new HashSet<String>();
        MethodDependencyInfo getNameMethod = this.context.getDependencyInfo().getMethod(new MethodReference(Class.class, "getName", String.class));
        if (getNameMethod != null) {
            this.addClassesRequiringName(classesRequiringName, getNameMethod.getVariable(0).getClassValueNode().getTypes());
        }
        if ((getSimpleNameMethod = this.context.getDependencyInfo().getMethod(new MethodReference(Class.class, "getSimpleName", String.class))) != null) {
            this.addClassesRequiringName(classesRequiringName, getSimpleNameMethod.getVariable(0).getClassValueNode().getTypes());
        }
        return classesRequiringName;
    }

    private void addClassesRequiringName(Set<String> target, String[] source) {
        for (String typeName : source) {
            if (typeName.startsWith("[")) {
                if (!typeName.endsWith(";")) continue;
                int index = 0;
                while (typeName.charAt(index) == '[') {
                    ++index;
                }
                typeName = typeName.substring(index, typeName.length() - 1).replace('/', '.');
            }
            target.add(typeName);
        }
    }

    private void collectMethodsToCopyFromInterfaces(ClassReader cls, List<MethodReference> targetList) {
        HashSet<MethodDescriptor> implementedMethods = new HashSet<MethodDescriptor>();
        implementedMethods.addAll(targetList.stream().map(method -> method.getDescriptor()).collect(Collectors.toList()));
        HashSet<String> visitedClasses = new HashSet<String>();
        for (String ifaceName : cls.getInterfaces()) {
            ClassReader iface = this.classSource.get(ifaceName);
            if (iface == null) continue;
            this.collectMethodsToCopyFromInterfacesImpl(iface, targetList, implementedMethods, visitedClasses);
        }
    }

    private void collectMethodsToCopyFromInterfacesImpl(ClassReader cls, List<MethodReference> targetList, Set<MethodDescriptor> visited, Set<String> visitedClasses) {
        if (!visitedClasses.add(cls.getName())) {
            return;
        }
        for (MethodReader methodReader : cls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC) || methodReader.hasModifier(ElementModifier.ABSTRACT) || !visited.add(methodReader.getDescriptor())) continue;
            targetList.add(methodReader.getReference());
        }
        for (String string : cls.getInterfaces()) {
            ClassReader iface = this.classSource.get(string);
            if (iface == null) continue;
            this.collectMethodsToCopyFromInterfacesImpl(iface, targetList, visited, visitedClasses);
        }
    }

    private static Object getDefaultValue(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitive = (ValueType.Primitive)type;
            switch (primitive.getKind()) {
                case BOOLEAN: {
                    return false;
                }
                case BYTE: {
                    return (byte)0;
                }
                case SHORT: {
                    return (short)0;
                }
                case INTEGER: {
                    return 0;
                }
                case CHARACTER: {
                    return Character.valueOf('\u0000');
                }
                case LONG: {
                    return 0L;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    return 0.0;
                }
            }
        }
        return null;
    }

    private void renderInitializer(PreparedMethod method) throws IOException {
        MethodReference ref = method.reference;
        this.debugEmitter.emitMethod(ref.getDescriptor());
        ScopedName name = this.naming.getNameForInit(ref);
        this.renderFunctionDeclaration(name);
        this.writer.append("(");
        for (int i = 0; i < ref.parameterCount(); ++i) {
            if (i > 0) {
                this.writer.append(",").ws();
            }
            this.writer.append(this.variableNameForInitializer(i));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        String instanceName = this.variableNameForInitializer(ref.parameterCount());
        this.writer.append("var " + instanceName).ws().append("=").ws().append("new ").appendClass(ref.getClassName()).append("();").softNewLine();
        this.writer.appendMethodBody(ref).append("(" + instanceName);
        for (int i = 0; i < ref.parameterCount(); ++i) {
            this.writer.append(",").ws();
            this.writer.append(this.variableNameForInitializer(i));
        }
        this.writer.append(");").softNewLine();
        this.writer.append("return " + instanceName + ";").softNewLine();
        this.writer.outdent().append("}");
        if (name.scoped) {
            this.writer.append(";");
        }
        this.writer.newLine();
        this.debugEmitter.emitMethod(null);
    }

    private String variableNameForInitializer(int index) {
        return this.minifying ? RenderingUtil.indexToId(index) : "var_" + index;
    }

    private void renderVirtualDeclarations(Collection<MethodReference> methods) throws IOException {
        if (methods.stream().noneMatch(this::isVirtual)) {
            this.writer.append('0');
            return;
        }
        this.writer.append("[");
        boolean first = true;
        for (MethodReference method : methods) {
            if (!this.isVirtual(method)) continue;
            this.debugEmitter.emitMethod(method.getDescriptor());
            if (!first) {
                this.writer.append(",").ws();
            }
            first = false;
            this.emitVirtualDeclaration(method);
            this.debugEmitter.emitMethod(null);
        }
        this.writer.append("]");
    }

    private void emitVirtualDeclaration(MethodReference ref) throws IOException {
        int i;
        String methodName = this.naming.getNameFor(ref.getDescriptor());
        this.writer.append("\"").append(methodName).append("\"");
        this.writer.append(",").ws().append("function(");
        ArrayList<String> args = new ArrayList<String>();
        for (i = 1; i <= ref.parameterCount(); ++i) {
            args.add(this.variableNameForInitializer(i));
        }
        for (i = 0; i < args.size(); ++i) {
            if (i > 0) {
                this.writer.append(",").ws();
            }
            this.writer.append((String)args.get(i));
        }
        this.writer.append(")").ws().append("{").ws();
        if (ref.getDescriptor().getResultType() != ValueType.VOID) {
            this.writer.append("return ");
        }
        this.writer.appendMethodBody(ref).append("(");
        this.writer.append("this");
        for (String arg : args) {
            this.writer.append(",").ws().append(arg);
        }
        this.writer.append(");").ws().append("}");
    }

    private void renderBody(PreparedMethod method) throws IOException {
        StatementRenderer statementRenderer = new StatementRenderer(this.context, this.writer);
        statementRenderer.setCurrentMethod(method.node);
        MethodReference ref = method.reference;
        this.debugEmitter.emitMethod(ref.getDescriptor());
        ScopedName name = this.naming.getFullNameFor(ref);
        this.renderFunctionDeclaration(name);
        this.writer.append("(");
        int startParam = 0;
        if (method.methodHolder.getModifiers().contains((Object)ElementModifier.STATIC)) {
            startParam = 1;
        }
        for (int i = startParam; i <= ref.parameterCount(); ++i) {
            if (i > startParam) {
                this.writer.append(",").ws();
            }
            this.writer.append(statementRenderer.variableName(i));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        MethodBodyRenderer renderer = new MethodBodyRenderer(statementRenderer);
        if (method.node != null) {
            method.node.acceptVisitor(renderer);
        } else {
            renderer.renderNative(method);
        }
        this.writer.outdent().append("}");
        if (name.scoped) {
            this.writer.append(";");
        }
        this.writer.newLine();
        this.debugEmitter.emitMethod(null);
        this.longLibraryUsed |= statementRenderer.isLongLibraryUsed();
    }

    private void renderFunctionDeclaration(ScopedName name) throws IOException {
        if (name.scoped) {
            this.writer.append(this.naming.getScopeName()).append(".").append(name.value).ws().append("=").ws();
        }
        this.writer.append("function");
        if (!name.scoped) {
            this.writer.append(" ").append(name.value);
        }
    }

    private void renderAsyncPrologue() throws IOException {
        this.writer.append(this.context.mainLoopName()).append(":").ws().append("while").ws().append("(true)").ws().append("{").ws();
        this.writer.append("switch").ws().append("(").append(this.context.pointerName()).append(")").ws().append('{').softNewLine();
    }

    private void renderAsyncEpilogue() throws IOException {
        this.writer.append("default:").ws().appendFunction("$rt_invalidPointer").append("();").softNewLine();
        this.writer.append("}}").softNewLine();
    }

    private void appendMonitor(StatementRenderer statementRenderer, MethodNode methodNode) throws IOException {
        if (methodNode.getModifiers().contains((Object)ElementModifier.STATIC)) {
            this.writer.appendFunction("$rt_cls").append("(").appendClass(methodNode.getReference().getClassName()).append(")");
        } else {
            this.writer.append(statementRenderer.variableName(0));
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        return this.services.getService(type);
    }

    private boolean isVirtual(MethodReference method) {
        return this.context.isVirtual(method);
    }

    private static class PostponedFieldInitializer {
        FieldReference field;
        String value;

        PostponedFieldInitializer(FieldReference field, String value) {
            this.field = field;
            this.value = value;
        }
    }

    private class MethodBodyRenderer
    implements MethodNodeVisitor,
    GeneratorContext {
        private boolean async;
        private StatementRenderer statementRenderer;

        MethodBodyRenderer(StatementRenderer statementRenderer) {
            this.statementRenderer = statementRenderer;
        }

        @Override
        public DependencyInfo getDependency() {
            return Renderer.this.context.getDependencyInfo();
        }

        public void renderNative(PreparedMethod method) {
            try {
                this.async = method.async;
                this.statementRenderer.setAsync(method.async);
                method.generator.generate(this, Renderer.this.writer, method.reference);
            }
            catch (IOException e) {
                throw new RenderingException("IO error occurred", e);
            }
        }

        @Override
        public void visit(RegularMethodNode method) {
            try {
                int i;
                this.statementRenderer.setAsync(false);
                this.async = false;
                MethodReference ref = method.getReference();
                for (int i2 = 0; i2 < method.getVariables().size(); ++i2) {
                    Renderer.this.debugEmitter.emitVariable(new String[]{method.getVariables().get(i2).getName()}, this.statementRenderer.variableName(i2));
                }
                int variableCount = 0;
                for (VariableNode var : method.getVariables()) {
                    variableCount = Math.max(variableCount, var.getIndex() + 1);
                }
                TryCatchFinder tryCatchFinder = new TryCatchFinder();
                method.getBody().acceptVisitor(tryCatchFinder);
                boolean hasTryCatch = tryCatchFinder.tryCatchFound;
                ArrayList<String> variableNames = new ArrayList<String>();
                for (i = ref.parameterCount() + 1; i < variableCount; ++i) {
                    variableNames.add(this.statementRenderer.variableName(i));
                }
                if (hasTryCatch) {
                    variableNames.add("$$je");
                }
                if (!variableNames.isEmpty()) {
                    Renderer.this.writer.append("var ");
                    for (i = 0; i < variableNames.size(); ++i) {
                        if (i > 0) {
                            Renderer.this.writer.append(",").ws();
                        }
                        Renderer.this.writer.append((String)variableNames.get(i));
                    }
                    Renderer.this.writer.append(";").softNewLine();
                }
                this.statementRenderer.setEnd(true);
                this.statementRenderer.setCurrentPart(0);
                if (method.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_ENTER_SYNC_METHOD);
                    Renderer.this.writer.append("(");
                    Renderer.this.appendMonitor(this.statementRenderer, method);
                    Renderer.this.writer.append(");").softNewLine();
                    Renderer.this.writer.append("try").ws().append("{").softNewLine().indent();
                }
                method.getBody().acceptVisitor(this.statementRenderer);
                if (method.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.outdent().append("}").ws().append("finally").ws().append("{").indent().softNewLine();
                    Renderer.this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_EXIT_SYNC_METHOD);
                    Renderer.this.writer.append("(");
                    Renderer.this.appendMonitor(this.statementRenderer, method);
                    Renderer.this.writer.append(");").softNewLine();
                    Renderer.this.writer.outdent().append("}").softNewLine();
                }
            }
            catch (IOException e) {
                throw new RenderingException("IO error occurred", e);
            }
        }

        @Override
        public void visit(AsyncMethodNode methodNode) {
            Renderer.this.threadLibraryUsed = true;
            try {
                int i;
                this.statementRenderer.setAsync(true);
                this.async = true;
                MethodReference ref = methodNode.getReference();
                for (int i2 = 0; i2 < methodNode.getVariables().size(); ++i2) {
                    Renderer.this.debugEmitter.emitVariable(new String[]{methodNode.getVariables().get(i2).getName()}, this.statementRenderer.variableName(i2));
                }
                int variableCount = 0;
                for (VariableNode var : methodNode.getVariables()) {
                    variableCount = Math.max(variableCount, var.getIndex() + 1);
                }
                ArrayList<String> variableNames = new ArrayList<String>();
                for (int i3 = ref.parameterCount() + 1; i3 < variableCount; ++i3) {
                    variableNames.add(this.statementRenderer.variableName(i3));
                }
                TryCatchFinder tryCatchFinder = new TryCatchFinder();
                for (AsyncMethodPart part : methodNode.getBody()) {
                    if (tryCatchFinder.tryCatchFound) continue;
                    part.getStatement().acceptVisitor(tryCatchFinder);
                }
                boolean hasTryCatch = tryCatchFinder.tryCatchFound;
                if (hasTryCatch) {
                    variableNames.add("$$je");
                }
                variableNames.add(Renderer.this.context.pointerName());
                variableNames.add(Renderer.this.context.tempVarName());
                if (!variableNames.isEmpty()) {
                    Renderer.this.writer.append("var ");
                    for (int i4 = 0; i4 < variableNames.size(); ++i4) {
                        if (i4 > 0) {
                            Renderer.this.writer.append(",").ws();
                        }
                        Renderer.this.writer.append((String)variableNames.get(i4));
                    }
                    Renderer.this.writer.append(";").softNewLine();
                }
                int firstToSave = 0;
                if (methodNode.getModifiers().contains((Object)ElementModifier.STATIC)) {
                    firstToSave = 1;
                }
                String popName = Renderer.this.minifying ? "l" : "pop";
                String pushName = Renderer.this.minifying ? "s" : "push";
                Renderer.this.writer.append(Renderer.this.context.pointerName()).ws().append('=').ws().append("0;").softNewLine();
                Renderer.this.writer.append("if").ws().append("(").appendFunction("$rt_resuming").append("())").ws().append("{").indent().softNewLine();
                Renderer.this.writer.append("var ").append(Renderer.this.context.threadName()).ws().append('=').ws().appendFunction("$rt_nativeThread").append("();").softNewLine();
                Renderer.this.writer.append(Renderer.this.context.pointerName()).ws().append('=').ws().append(Renderer.this.context.threadName()).append(".").append(popName).append("();");
                for (i = variableCount - 1; i >= firstToSave; --i) {
                    Renderer.this.writer.append(this.statementRenderer.variableName(i)).ws().append('=').ws().append(Renderer.this.context.threadName()).append(".").append(popName).append("();");
                }
                Renderer.this.writer.softNewLine();
                Renderer.this.writer.outdent().append("}").softNewLine();
                if (methodNode.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.append("try").ws().append('{').indent().softNewLine();
                }
                Renderer.this.renderAsyncPrologue();
                for (i = 0; i < methodNode.getBody().size(); ++i) {
                    Renderer.this.writer.append("case ").append(i).append(":").indent().softNewLine();
                    if (i == 0 && methodNode.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                        Renderer.this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_ENTER_METHOD);
                        Renderer.this.writer.append("(");
                        Renderer.this.appendMonitor(this.statementRenderer, methodNode);
                        Renderer.this.writer.append(");").softNewLine();
                        this.statementRenderer.emitSuspendChecker();
                    }
                    AsyncMethodPart part = methodNode.getBody().get(i);
                    this.statementRenderer.setEnd(true);
                    this.statementRenderer.setCurrentPart(i);
                    part.getStatement().acceptVisitor(this.statementRenderer);
                    Renderer.this.writer.outdent();
                }
                Renderer.this.renderAsyncEpilogue();
                if (methodNode.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.outdent().append("}").ws().append("finally").ws().append('{').indent().softNewLine();
                    Renderer.this.writer.append("if").ws().append("(!").appendFunction("$rt_suspending").append("())").ws().append("{").indent().softNewLine();
                    Renderer.this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_EXIT_METHOD);
                    Renderer.this.writer.append("(");
                    Renderer.this.appendMonitor(this.statementRenderer, methodNode);
                    Renderer.this.writer.append(");").softNewLine();
                    Renderer.this.writer.outdent().append('}').softNewLine();
                    Renderer.this.writer.outdent().append('}').softNewLine();
                }
                Renderer.this.writer.appendFunction("$rt_nativeThread").append("().").append(pushName).append("(");
                for (i = firstToSave; i < variableCount; ++i) {
                    Renderer.this.writer.append(this.statementRenderer.variableName(i)).append(',').ws();
                }
                Renderer.this.writer.append(Renderer.this.context.pointerName()).append(");");
                Renderer.this.writer.softNewLine();
            }
            catch (IOException e) {
                throw new RenderingException("IO error occurred", e);
            }
        }

        @Override
        public String getParameterName(int index) {
            return this.statementRenderer.variableName(index);
        }

        @Override
        public ListableClassReaderSource getClassSource() {
            return Renderer.this.classSource;
        }

        @Override
        public ClassReaderSource getInitialClassSource() {
            return Renderer.this.context.getInitialClassSource();
        }

        @Override
        public ClassLoader getClassLoader() {
            return Renderer.this.classLoader;
        }

        @Override
        public Properties getProperties() {
            return new Properties(Renderer.this.properties);
        }

        @Override
        public <T> T getService(Class<T> type) {
            return Renderer.this.services.getService(type);
        }

        @Override
        public boolean isAsync() {
            return this.async;
        }

        @Override
        public boolean isAsync(MethodReference method) {
            return Renderer.this.asyncMethods.contains(method);
        }

        @Override
        public boolean isAsyncFamily(MethodReference method) {
            return Renderer.this.asyncFamilyMethods.contains(method);
        }

        @Override
        public Diagnostics getDiagnostics() {
            return Renderer.this.diagnostics;
        }

        @Override
        public void typeToClassString(SourceWriter writer, ValueType type) {
            try {
                Renderer.this.context.typeToClsString(writer, type);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void useLongLibrary() {
            Renderer.this.longLibraryUsed = true;
        }

        @Override
        public boolean isDynamicInitializer(String className) {
            return Renderer.this.context.isDynamicInitializer(className);
        }
    }

    static class PackageNode {
        String name;
        Map<String, PackageNode> children = new HashMap<String, PackageNode>();

        PackageNode(String name) {
            this.name = name;
        }

        int count() {
            int result = 0;
            for (PackageNode child : this.children.values()) {
                result += 1 + child.count();
            }
            return result;
        }
    }
}

