/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.teavm.cli.ConsoleTeaVMToolLog;
import org.teavm.tooling.RuntimeCopyOperation;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;

public final class TeaVMRunner {
    private static long startTime;
    private static long phaseStartTime;
    private static TeaVMPhase currentPhase;
    private static String[] classPath;
    private static TeaVMProgressListener progressListener;

    private TeaVMRunner() {
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"a directory where to put generated files (current directory by default)");
        OptionBuilder.withLongOpt((String)"targetdir");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"a file where to put decompiled classes (classes.js by default)");
        OptionBuilder.withLongOpt((String)"targetfile");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withDescription((String)"causes TeaVM to generate minimized JavaScript file");
        OptionBuilder.withLongOpt((String)"minify");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"separate|merge|none");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"how to attach runtime. Possible values are: separate|merge|none");
        OptionBuilder.withLongOpt((String)"runtime");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withDescription((String)"causes TeaVM to include default main page");
        OptionBuilder.withLongOpt((String)"mainpage");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"causes TeaVM to log bytecode");
        OptionBuilder.withLongOpt((String)"logbytecode");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Generate debug information");
        OptionBuilder.withLongOpt((String)"debug");
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withDescription((String)"Generate source maps");
        OptionBuilder.withLongOpt((String)"sourcemaps");
        options.addOption(OptionBuilder.create((char)'S'));
        OptionBuilder.withDescription((String)"Incremental build");
        OptionBuilder.withLongOpt((String)"incremental");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Incremental build cache directory");
        OptionBuilder.withLongOpt((String)"cachedir");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withDescription((String)"Wait for command after compilation, in order to enable hot recompilation");
        OptionBuilder.withLongOpt((String)"wait");
        options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.withArgName((String)"classpath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Additional classpath that will be reloaded by TeaVM each time in wait mode");
        OptionBuilder.withLongOpt((String)"classpath");
        options.addOption(OptionBuilder.create((char)'p'));
        if (args.length == 0) {
            TeaVMRunner.printUsage(options);
            return;
        }
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMRunner.printUsage(options);
            return;
        }
        TeaVMTool tool = new TeaVMTool();
        tool.setBytecodeLogging(commandLine.hasOption("logbytecode"));
        if (commandLine.hasOption("d")) {
            tool.setTargetDirectory(new File(commandLine.getOptionValue("d")));
        }
        if (commandLine.hasOption("f")) {
            tool.setTargetFileName(commandLine.getOptionValue("f"));
        }
        if (commandLine.hasOption("m")) {
            tool.setMinifying(true);
        } else {
            tool.setMinifying(false);
        }
        if (commandLine.hasOption("r")) {
            switch (commandLine.getOptionValue("r")) {
                case "separate": {
                    tool.setRuntime(RuntimeCopyOperation.SEPARATE);
                    break;
                }
                case "merge": {
                    tool.setRuntime(RuntimeCopyOperation.MERGED);
                    break;
                }
                case "none": {
                    tool.setRuntime(RuntimeCopyOperation.NONE);
                    break;
                }
                default: {
                    System.err.println("Wrong parameter for -r option specified");
                    TeaVMRunner.printUsage(options);
                    return;
                }
            }
        }
        if (commandLine.hasOption("mainpage")) {
            tool.setMainPageIncluded(true);
        }
        if (commandLine.hasOption('D')) {
            tool.setDebugInformationGenerated(true);
        }
        if (commandLine.hasOption('S')) {
            tool.setSourceMapsFileGenerated(true);
        }
        if (commandLine.hasOption('i')) {
            tool.setIncremental(true);
        }
        if (commandLine.hasOption('c')) {
            tool.setCacheDirectory(new File(commandLine.getOptionValue('c')));
        } else {
            tool.setCacheDirectory(new File(tool.getTargetDirectory(), "teavm-cache"));
        }
        if (commandLine.hasOption('p')) {
            classPath = commandLine.getOptionValues('p');
        }
        boolean interactive = commandLine.hasOption('w');
        args = commandLine.getArgs();
        if (args.length > 1) {
            System.err.println("Unexpected arguments");
            TeaVMRunner.printUsage(options);
            return;
        }
        if (args.length == 1) {
            tool.setMainClass(args[0]);
        }
        tool.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog());
        tool.getProperties().putAll((Map<?, ?>)System.getProperties());
        tool.setProgressListener(progressListener);
        if (interactive) {
            BufferedReader reader;
            boolean quit = false;
            try {
                reader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-2);
                return;
            }
            do {
                try {
                    TeaVMRunner.build(tool);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                System.out.println("Press enter to repeat or enter 'q' to quit");
                try {
                    String line = reader.readLine().trim();
                    if (line.isEmpty()) continue;
                    if (line.equals("q")) {
                        quit = true;
                        continue;
                    }
                    System.out.println("Unrecognized command");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-2);
                }
            } while (!quit);
        } else {
            try {
                TeaVMRunner.build(tool);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(-2);
            }
            if (!tool.getProblemProvider().getSevereProblems().isEmpty()) {
                System.exit(-2);
            }
        }
    }

    private static void build(TeaVMTool tool) throws TeaVMToolException {
        TeaVMRunner.resetClassLoader(tool);
        currentPhase = null;
        startTime = System.currentTimeMillis();
        phaseStartTime = System.currentTimeMillis();
        tool.generate();
        TeaVMRunner.reportPhaseComplete();
        System.out.println("Build complete for " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
    }

    private static void resetClassLoader(TeaVMTool tool) {
        if (classPath == null || classPath.length == 0) {
            return;
        }
        URL[] urls = new URL[classPath.length];
        for (int i = 0; i < classPath.length; ++i) {
            try {
                urls[i] = new File(classPath[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                System.err.println("Illegal classpath entry: " + classPath[i]);
                System.exit(-1);
                return;
            }
        }
        tool.setClassLoader((ClassLoader)new URLClassLoader(urls, TeaVMRunner.class.getClassLoader()));
    }

    private static void reportPhaseComplete() {
        System.out.println(" complete for " + (double)(System.currentTimeMillis() - phaseStartTime) / 1000.0 + " seconds");
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        progressListener = new TeaVMProgressListener(){

            public TeaVMProgressFeedback progressReached(int progress) {
                return TeaVMProgressFeedback.CONTINUE;
            }

            public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
                if (currentPhase != phase) {
                    if (currentPhase != null) {
                        TeaVMRunner.reportPhaseComplete();
                    }
                    phaseStartTime = System.currentTimeMillis();
                    switch (phase) {
                        case DEPENDENCY_CHECKING: {
                            System.out.print("Finding methods to decompile...");
                            break;
                        }
                        case LINKING: {
                            System.out.print("Linking methods...");
                            break;
                        }
                        case DEVIRTUALIZATION: {
                            System.out.print("Applying devirtualization...");
                            break;
                        }
                        case DECOMPILATION: {
                            System.out.print("Decompiling...");
                            break;
                        }
                        case RENDERING: {
                            System.out.print("Generating output...");
                        }
                    }
                    currentPhase = phase;
                }
                return TeaVMProgressFeedback.CONTINUE;
            }
        };
    }
}

