/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.util.ArrayList;
import java.util.List;
import org.teavm.tooling.TeaVMToolLog;

public class AccumulatingTeaVMToolLog
implements TeaVMToolLog {
    private TeaVMToolLog delegatedLog;
    private List<Message> pendingMessages = new ArrayList<Message>();

    public AccumulatingTeaVMToolLog(TeaVMToolLog delegatedLog) {
        this.delegatedLog = delegatedLog;
    }

    public void flush() {
        for (Message message : this.pendingMessages) {
            switch (message.kind.ordinal()) {
                case 0: {
                    if (message.throwable != null) {
                        this.delegatedLog.info(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.info(message.text);
                    break;
                }
                case 1: {
                    if (message.throwable != null) {
                        this.delegatedLog.debug(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.debug(message.text);
                    break;
                }
                case 2: {
                    if (message.throwable != null) {
                        this.delegatedLog.warning(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.warning(message.text);
                    break;
                }
                case 3: {
                    if (message.throwable != null) {
                        this.delegatedLog.error(message.text, message.throwable);
                        break;
                    }
                    this.delegatedLog.error(message.text);
                }
            }
        }
        this.pendingMessages.clear();
    }

    public void info(String text) {
        this.pendingMessages.add(new Message(MessageKind.INFO, text, null));
    }

    public void debug(String text) {
        this.pendingMessages.add(new Message(MessageKind.DEBUG, text, null));
    }

    public void warning(String text) {
        this.pendingMessages.add(new Message(MessageKind.WARNING, text, null));
    }

    public void error(String text) {
        this.pendingMessages.add(new Message(MessageKind.ERROR, text, null));
    }

    public void info(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.INFO, text, e));
    }

    public void debug(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.DEBUG, text, e));
    }

    public void warning(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.WARNING, text, e));
    }

    public void error(String text, Throwable e) {
        this.pendingMessages.add(new Message(MessageKind.ERROR, text, e));
    }

    static class Message {
        MessageKind kind;
        String text;
        Throwable throwable;

        public Message(MessageKind kind, String text, Throwable throwable) {
            this.kind = kind;
            this.text = text;
            this.throwable = throwable;
        }
    }

    static enum MessageKind {
        INFO,
        DEBUG,
        WARNING,
        ERROR;

    }
}

