/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractLineTerminator;
import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;
import org.teavm.classlib.java.util.regex.TQuantifierSet;

class TDotQuantifierSet
extends TQuantifierSet {
    TAbstractLineTerminator lt;

    public TDotQuantifierSet(TAbstractSet innerSet, TAbstractSet next, int type, TAbstractLineTerminator lt) {
        super(innerSet, next, type);
        this.lt = lt;
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        int strLength = matchResult.getRightBound();
        int startSearch = this.findLineTerminator(stringIndex, strLength, testString);
        if (startSearch < 0) {
            startSearch = strLength;
        }
        if (startSearch <= stringIndex) {
            return this.next.matches(stringIndex, testString, matchResult);
        }
        return this.next.findBack(stringIndex, startSearch, testString, matchResult);
    }

    @Override
    public int find(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        int leftBound;
        int nextSearch;
        int strLength = matchResult.getRightBound();
        int res = this.next.find(stringIndex, testString, matchResult);
        if (res >= 0) {
            nextSearch = this.findLineTerminator(res, strLength, testString);
            if (nextSearch < 0) {
                nextSearch = strLength;
            }
        } else {
            return -1;
        }
        nextSearch = this.next.findBack(res, nextSearch, testString, matchResult);
        res = Math.max(res, nextSearch);
        int n = res > 0 ? this.findBackLineTerminator(stringIndex, res - 1, testString) : (leftBound = res == 0 ? 0 : -1);
        res = leftBound >= stringIndex ? (leftBound < res ? leftBound + 1 : leftBound) : stringIndex;
        return res;
    }

    private int findLineTerminator(int from, int to, CharSequence testString) {
        for (int i = from; i < to; ++i) {
            if (!this.lt.isLineTerminator(testString.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private int findBackLineTerminator(int from, int to, CharSequence testString) {
        for (int i = to; i >= from; --i) {
            if (!this.lt.isLineTerminator(testString.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected String getName() {
        return "<DotQuant>";
    }
}

