/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TUnsupportedOperationException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TSet;

public abstract class TAbstractMap<K, V>
extends TObject
implements TMap<K, V> {
    transient TSet<K> cachedKeySet;
    transient TCollection<V> cachedValues;

    protected TAbstractMap() {
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Object knownValue = ((TMap.Entry)iter.next()).getValue();
            if (!TObjects.equals(value, knownValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Object knownKey = ((TMap.Entry)iter.next()).getKey();
            if (!TObjects.equals(key, knownKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            if (!TObjects.equals(key, entry.getKey())) continue;
            return (V)entry.getValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new TUnsupportedOperationException();
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> m) {
        TIterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            if (!TObjects.equals(key, entry.getKey())) continue;
            iter.remove();
            return (V)entry.getValue();
        }
        return null;
    }

    @Override
    public abstract TSet<TMap.Entry<K, V>> entrySet();

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public TSet<K> keySet() {
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new KeySet();
        }
        return this.cachedKeySet;
    }

    @Override
    public TCollection<V> values() {
        if (this.cachedValues == null) {
            this.cachedValues = new Values();
        }
        return this.cachedValues;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TMap)) {
            return false;
        }
        TMap other = (TMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        try {
            TIterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                TMap.Entry entry = (TMap.Entry)it.next();
                if (!other.containsKey(entry.getKey())) {
                    return false;
                }
                if (TObjects.equals(entry.getValue(), other.get(entry.getKey()))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            result += entry.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        TMap.Entry e;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        TIterator iter = this.entrySet().iterator();
        if (iter.hasNext()) {
            e = (TMap.Entry)iter.next();
            sb.append((Object)(e.getKey() == this ? "(this Map)" : e.getKey()));
            sb.append('=');
            sb.append((Object)(e.getValue() == this ? "(this Map)" : e.getValue()));
        }
        while (iter.hasNext()) {
            sb.append(", ");
            e = (TMap.Entry)iter.next();
            sb.append((Object)(e.getKey() == this ? "(this Map)" : e.getKey()));
            sb.append('=');
            sb.append((Object)(e.getValue() == this ? "(this Map)" : e.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected Object clone() throws TCloneNotSupportedException {
        TAbstractMap copy = (TAbstractMap)super.clone();
        copy.cachedKeySet = null;
        copy.cachedValues = null;
        return copy;
    }

    private class KeySet
    extends TAbstractSet<K> {
        private KeySet() {
        }

        @Override
        public TIterator<K> iterator() {
            final TIterator it = TAbstractMap.this.entrySet().iterator();
            return new TIterator<K>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public K next() {
                    return ((TMap.Entry)it.next()).getKey();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public int size() {
            return TAbstractMap.this.size();
        }
    }

    private class Values
    extends TAbstractCollection<V> {
        private Values() {
        }

        @Override
        public int size() {
            return TAbstractMap.this.size();
        }

        @Override
        public TIterator<V> iterator() {
            final TIterator it = TAbstractMap.this.entrySet().iterator();
            return new TIterator<V>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public V next() {
                    return ((TMap.Entry)it.next()).getValue();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }
    }

    public static class SimpleImmutableEntry<K, V>
    implements TMap.Entry<K, V>,
    TSerializable {
        private K key;
        private V value;

        public SimpleImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleImmutableEntry(TMap.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new TUnsupportedOperationException();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TMap.Entry) {
                TMap.Entry entry = (TMap.Entry)obj;
                return TObjects.equals(this.key, entry.getKey()) && TObjects.equals(this.value, entry.getValue());
            }
            return false;
        }

        public int hashCode() {
            return TObjects.hashCode(this.key) ^ TObjects.hashCode(this.value);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static class SimpleEntry<K, V>
    implements TMap.Entry<K, V>,
    TSerializable {
        private K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(TMap.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TMap.Entry) {
                TMap.Entry entry = (TMap.Entry)obj;
                return TObjects.equals(this.key, entry.getKey()) && TObjects.equals(this.value, entry.getValue());
            }
            return false;
        }

        public int hashCode() {
            return TObjects.hashCode(this.key) ^ TObjects.hashCode(this.value);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

