/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TCloseable;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TReadable;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;

public abstract class TReader
implements TCloseable,
TReadable {
    protected TObject lock;

    protected TReader() {
        this(new TObject());
    }

    protected TReader(TObject lock) {
        this.lock = lock;
    }

    public int read() throws IOException {
        char[] buf = new char[1];
        return this.read(buf) >= 0 ? buf[0] : -1;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    @Override
    public int read(TCharBuffer cb) throws IOException {
        int bytesRead;
        if (!cb.hasRemaining()) {
            return 0;
        }
        if (cb.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (cb.hasArray()) {
            bytesRead = this.read(cb.array(), cb.position() + cb.arrayOffset(), cb.remaining());
            if (bytesRead > 0) {
                cb.position(cb.position() + bytesRead);
            }
        } else {
            char[] array = new char[cb.remaining()];
            bytesRead = this.read(array);
            if (bytesRead > 0) {
                cb.put(array, 0, bytesRead);
            }
        }
        return bytesRead;
    }

    public long skip(long n) throws IOException {
        long skipped;
        int charsRead;
        char[] buffer = new char[1024];
        for (skipped = 0L; skipped < n && (charsRead = this.read(buffer, 0, (int)TMath.min(n, (long)buffer.length))) >= 0; skipped += (long)charsRead) {
        }
        return skipped;
    }

    public boolean ready() throws IOException {
        return true;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException();
    }

    public void reset() throws IOException {
        throw new IOException();
    }
}

