/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.doubleimpl;

import java.util.PrimitiveIterator;
import java.util.function.DoublePredicate;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;

public class TGenericConcatDoubleStream
extends TSimpleDoubleStreamImpl {
    TDoubleStream first;
    TDoubleStream second;
    PrimitiveIterator.OfDouble iterator;
    boolean isSecond;

    public TGenericConcatDoubleStream(TDoubleStream first, TDoubleStream second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean next(DoublePredicate consumer) {
        if (this.iterator == null) {
            this.iterator = this.first.iterator();
        }
        while (true) {
            if (this.iterator.hasNext()) {
                if (consumer.test(this.iterator.nextDouble())) continue;
                return true;
            }
            if (this.isSecond) break;
            this.isSecond = true;
            this.iterator = this.second.iterator();
        }
        return false;
    }

    @Override
    public long count() {
        return this.first.count() + this.second.count();
    }

    @Override
    public void close() throws Exception {
        Exception suppressed = null;
        try {
            this.first.close();
        }
        catch (Exception e) {
            suppressed = e;
        }
        try {
            this.second.close();
        }
        catch (Exception e) {
            if (suppressed != null) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }
}

