/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferImpl;

class TCharBufferOverArray
extends TCharBufferImpl {
    boolean readOnly;
    int start;
    char[] array;

    public TCharBufferOverArray(int capacity) {
        this(0, capacity, new char[capacity], 0, capacity, false);
    }

    public TCharBufferOverArray(int start, int capacity, char[] array, int position, int limit, boolean readOnly) {
        super(capacity, position, limit);
        this.start = start;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TCharBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TCharBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    char getChar(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putChar(int index, char value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    char[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.BIG_ENDIAN;
    }
}

