/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import org.teavm.classlib.java.util.zip.TCRC32;
import org.teavm.classlib.java.util.zip.TDeflater;
import org.teavm.classlib.java.util.zip.TDeflaterOutputStream;

public class TGZIPOutputStream
extends TDeflaterOutputStream {
    protected TCRC32 crc = new TCRC32();

    public TGZIPOutputStream(OutputStream os) throws IOException {
        this(os, 512);
    }

    public TGZIPOutputStream(OutputStream os, int size) throws IOException {
        super(os, new TDeflater(-1, true), size);
        this.writeShort(35615);
        this.out.write(8);
        this.out.write(0);
        this.writeLong(0L);
        this.out.write(0);
        this.out.write(0);
    }

    @Override
    public void flush() throws IOException {
        int count = this.def.deflate(this.buf, 0, this.buf.length, 2);
        this.out.write(this.buf, 0, count);
        this.out.flush();
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        this.writeLong(this.crc.getValue());
        this.writeLong(this.crc.tbytes);
    }

    @Override
    public void write(byte[] buffer, int off, int nbytes) throws IOException {
        super.write(buffer, off, nbytes);
        this.crc.update(buffer, off, nbytes);
    }

    private long writeLong(long i) throws IOException {
        int unsigned = (int)i;
        this.out.write(unsigned & 0xFF);
        this.out.write(unsigned >> 8 & 0xFF);
        this.out.write(unsigned >> 16 & 0xFF);
        this.out.write(unsigned >> 24 & 0xFF);
        return i;
    }

    private int writeShort(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >> 8 & 0xFF);
        return i;
    }
}

