/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.util.TAbstractMap;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TNavigableMap;
import org.teavm.classlib.java.util.TNavigableSet;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TSet;
import org.teavm.classlib.java.util.TSortedMap;
import org.teavm.classlib.java.util.TSortedSet;

public class TTreeMap<K, V>
extends TAbstractMap<K, V>
implements TCloneable,
TSerializable,
TNavigableMap<K, V> {
    TreeNode<K, V> root;
    private TComparator<? super K> comparator;
    private TComparator<? super K> originalComparator;
    private TComparator<? super K> revertedComparator;
    private int modCount;
    private EntrySet<K, V> cachedEntrySet;
    private NavigableKeySet<K, V> cachedNavigableKeySet;

    public TTreeMap() {
        this((TComparator)null);
    }

    public TTreeMap(TComparator<? super K> comparator) {
        this.originalComparator = comparator;
        if (comparator == null) {
            comparator = new TComparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o1 != null ? ((TComparable)o1).compareTo(o2) : ((TComparable)o2).compareTo(o1);
                }
            };
        }
        this.comparator = comparator;
    }

    public TTreeMap(TMap<? extends K, ? extends V> m) {
        this((TComparator)null);
        TMap.Entry[] entries = new TMap.Entry[m.size()];
        entries = m.entrySet().toArray(entries);
        TArrays.sort(entries, (o1, o2) -> this.comparator.compare(o1.getKey(), o2.getKey()));
        this.fillMap(entries);
    }

    public TTreeMap(TSortedMap<K, ? extends V> m) {
        this(m.comparator());
        TMap.Entry[] entries = new TMap.Entry[m.size()];
        entries = m.entrySet().toArray(entries);
        this.fillMap(entries);
    }

    private void ensureRevertedComparator() {
        if (this.revertedComparator == null) {
            this.revertedComparator = (o1, o2) -> -this.originalComparator.compare(o1, o2);
        }
    }

    private void fillMap(TMap.Entry<? extends K, ? extends V>[] entries) {
        this.root = this.createNode(entries, 0, entries.length - 1);
    }

    private TreeNode<K, V> createNode(TMap.Entry<? extends K, ? extends V>[] entries, int l, int u) {
        if (l > u) {
            return null;
        }
        int mid = (l + u) / 2;
        TMap.Entry<K, V> entry = entries[mid];
        TreeNode<K, V> node = new TreeNode<K, V>(entry.getKey());
        node.setValue(entry.getValue());
        node.left = this.createNode(entries, l, mid - 1);
        node.right = this.createNode(entries, mid + 1, u);
        node.fix();
        return node;
    }

    @Override
    public V get(Object key) {
        TreeNode<?, V> node = this.findExact(key);
        return node != null ? (V)node.getValue() : null;
    }

    @Override
    public V put(K key, V value) {
        this.root = this.getOrCreateNode(this.root, key);
        TreeNode<?, V> node = this.findExact(key);
        V old = node.setValue(value);
        node.setValue(value);
        ++this.modCount;
        return old;
    }

    @Override
    public V remove(Object key) {
        TreeNode<?, V> node = this.findExact(key);
        if (node == null) {
            return null;
        }
        this.root = this.deleteNode(this.root, key);
        ++this.modCount;
        return node.getValue();
    }

    @Override
    public void clear() {
        this.root = null;
        ++this.modCount;
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findExact(key) != null;
    }

    TreeNode<?, V> findExact(Object key) {
        TreeNode<K, V> node = this.root;
        while (node != null) {
            int cmp = this.comparator.compare(key, node.getKey());
            if (cmp == 0) {
                return node;
            }
            if (cmp < 0) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return null;
    }

    TreeNode<K, V> findExactOrNext(Object key, boolean reverse) {
        TreeNode<K, V> node = this.root;
        TreeNode<K, V> lastForward = null;
        while (node != null) {
            int cmp = this.comparator.compare(key, node.getKey());
            if (reverse) {
                cmp = -cmp;
            }
            if (cmp == 0) {
                return node;
            }
            if (cmp < 0) {
                lastForward = node;
                node = node.forward(reverse);
                continue;
            }
            node = node.down(reverse);
        }
        return lastForward;
    }

    TreeNode<K, V>[] pathToExactOrNext(Object key, boolean reverse) {
        TreeNode[] path = new TreeNode[this.height()];
        int depth = 0;
        TreeNode<K, V> node = this.root;
        while (node != null) {
            int cmp = this.comparator.compare(key, node.getKey());
            if (reverse) {
                cmp = -cmp;
            }
            if (cmp == 0) {
                path[depth++] = node;
                break;
            }
            if (cmp < 0) {
                path[depth++] = node;
                node = node.forward(reverse);
                continue;
            }
            node = node.down(reverse);
        }
        return TArrays.copyOf(path, depth);
    }

    TreeNode<K, V> findNext(Object key, boolean reverse) {
        TreeNode<K, V> node = this.root;
        TreeNode<K, V> lastForward = null;
        while (node != null) {
            int cmp = this.comparator.compare(key, node.getKey());
            if (reverse) {
                cmp = -cmp;
            }
            if (cmp < 0) {
                lastForward = node;
                node = node.forward(reverse);
                continue;
            }
            node = node.down(reverse);
        }
        return lastForward;
    }

    TreeNode<K, V>[] pathToNext(Object key, boolean reverse) {
        TreeNode[] path = new TreeNode[this.height()];
        int depth = 0;
        TreeNode<K, V> node = this.root;
        while (node != null) {
            int cmp = this.comparator.compare(key, node.getKey());
            if (reverse) {
                cmp = -cmp;
            }
            if (cmp < 0) {
                path[depth++] = node;
                node = node.forward(reverse);
                continue;
            }
            node = node.down(reverse);
        }
        return TArrays.copyOf(path, depth);
    }

    TreeNode<K, V>[] pathToFirst(boolean reverse) {
        TreeNode[] path = new TreeNode[this.height()];
        int depth = 0;
        for (TreeNode<K, V> node = this.root; node != null; node = node.forward(reverse)) {
            path[depth++] = node;
        }
        return TArrays.copyOf(path, depth);
    }

    private TreeNode<K, V> getOrCreateNode(TreeNode<K, V> root, K key) {
        if (root == null) {
            return new TreeNode(key);
        }
        int cmp = this.comparator.compare(key, root.getKey());
        if (cmp == 0) {
            return root;
        }
        if (cmp < 0) {
            root.left = this.getOrCreateNode(root.left, key);
        } else {
            root.right = this.getOrCreateNode(root.right, key);
        }
        root.fix();
        return root.balance();
    }

    private TreeNode<K, V> deleteNode(TreeNode<K, V> root, Object key) {
        if (root == null) {
            return null;
        }
        int cmp = this.comparator.compare(key, root.getKey());
        if (cmp < 0) {
            root.left = this.deleteNode(root.left, key);
        } else if (cmp > 0) {
            root.right = this.deleteNode(root.right, key);
        } else {
            TreeNode right;
            if (root.right == null) {
                return root.left;
            }
            TreeNode left = root.left;
            TreeNode min = right = root.right;
            TreeNode[] pathToMin = new TreeNode[right.height];
            int minDepth = 0;
            while (min.left != null) {
                pathToMin[minDepth++] = min;
                min = min.left;
            }
            right = min.right;
            while (minDepth > 0) {
                TreeNode node = pathToMin[--minDepth];
                node.left = right;
                node.fix();
                node = node.balance();
                right = node;
            }
            min.right = right;
            min.left = left;
            root = min;
            root.fix();
        }
        root.fix();
        return root.balance();
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        if (this.cachedEntrySet == null) {
            this.cachedEntrySet = new EntrySet(this, null, true, false, null, true, false, false);
        }
        return this.cachedEntrySet;
    }

    @Override
    public TComparator<? super K> comparator() {
        return this.originalComparator;
    }

    @Override
    public TSortedMap<K, V> subMap(K fromKey, K toKey) {
        if (this.comparator.compare(fromKey, toKey) > 0) {
            throw new TIllegalArgumentException();
        }
        return new MapView(this, fromKey, true, true, toKey, false, true, false);
    }

    @Override
    public TNavigableMap<K, V> headMap(K toKey) {
        return new MapView(this, null, true, false, toKey, false, true, false);
    }

    @Override
    public TNavigableMap<K, V> tailMap(K fromKey) {
        return new MapView(this, fromKey, true, true, null, false, false, false);
    }

    @Override
    public K firstKey() {
        TreeNode<K, V> node = this.firstNode(false);
        if (node == null) {
            throw new TNoSuchElementException();
        }
        return node.getKey();
    }

    @Override
    public K lastKey() {
        TreeNode<K, V> node = this.firstNode(true);
        if (node == null) {
            throw new TNoSuchElementException();
        }
        return node.getKey();
    }

    @Override
    public TMap.Entry<K, V> lowerEntry(K key) {
        return this.findNext(key, true);
    }

    @Override
    public K lowerKey(K key) {
        TreeNode<K, V> node = this.findNext(key, true);
        return node != null ? (K)node.getKey() : null;
    }

    @Override
    public TMap.Entry<K, V> floorEntry(K key) {
        return this.findExactOrNext(key, true);
    }

    @Override
    public K floorKey(K key) {
        TreeNode<K, V> node = this.findExactOrNext(key, true);
        return node != null ? (K)node.getKey() : null;
    }

    @Override
    public TMap.Entry<K, V> ceilingEntry(K key) {
        return this.findExactOrNext(key, false);
    }

    @Override
    public K ceilingKey(K key) {
        TreeNode<K, V> node = this.findExactOrNext(key, false);
        return node != null ? (K)node.getKey() : null;
    }

    @Override
    public TMap.Entry<K, V> higherEntry(K key) {
        return this.findNext(key, false);
    }

    @Override
    public K higherKey(K key) {
        TreeNode<K, V> node = this.findNext(key, false);
        return node != null ? (K)node.getKey() : null;
    }

    @Override
    public TMap.Entry<K, V> firstEntry() {
        return this.firstNode(false);
    }

    @Override
    public TMap.Entry<K, V> lastEntry() {
        return this.firstNode(true);
    }

    @Override
    public TMap.Entry<K, V> pollFirstEntry() {
        TreeNode<K, V> node = this.firstNode(false);
        if (node != null) {
            this.root = this.deleteNode(this.root, node.getKey());
        }
        return node;
    }

    @Override
    public TMap.Entry<K, V> pollLastEntry() {
        TreeNode<K, V> node = this.firstNode(true);
        if (node != null) {
            this.root = this.deleteNode(this.root, node.getKey());
        }
        return node;
    }

    @Override
    public TNavigableMap<K, V> descendingMap() {
        return new MapView(this, null, false, false, null, false, false, true);
    }

    @Override
    public TNavigableSet<K> navigableKeySet() {
        if (this.cachedNavigableKeySet == null) {
            this.cachedNavigableKeySet = new NavigableKeySet(this);
        }
        return this.cachedNavigableKeySet;
    }

    @Override
    public TNavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public TNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new MapView(this, fromKey, fromInclusive, true, toKey, toInclusive, true, false);
    }

    @Override
    public TNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new MapView(this, null, false, false, toKey, inclusive, true, false);
    }

    @Override
    public TNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new MapView(this, fromKey, inclusive, true, null, false, false, false);
    }

    private TreeNode<K, V> firstNode(boolean reverse) {
        TreeNode<K, V> prev = null;
        for (TreeNode<K, V> node = this.root; node != null; node = node.forward(reverse)) {
            prev = node;
        }
        return prev;
    }

    @Override
    public int size() {
        return this.root != null ? this.root.size : 0;
    }

    int height() {
        return this.root != null ? this.root.height : 0;
    }

    @Override
    public Object clone() {
        TTreeMap copy = (TTreeMap)super.clone();
        copy.cachedEntrySet = null;
        return copy;
    }

    static class TreeNode<K, V>
    extends TAbstractMap.SimpleEntry<K, V> {
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        int height = 1;
        int size = 1;

        TreeNode(K key) {
            super(key, null);
        }

        public TreeNode<K, V> balance() {
            int factor = this.factor();
            if (factor == 2) {
                if (this.right.factor() < 0) {
                    this.right = this.right.rotateRight();
                }
                return this.rotateLeft();
            }
            if (factor == -2) {
                if (this.left.factor() > 0) {
                    this.left = this.left.rotateLeft();
                }
                return this.rotateRight();
            }
            return this;
        }

        public int factor() {
            return (this.right != null ? this.right.height : 0) - (this.left != null ? this.left.height : 0);
        }

        public TreeNode<K, V> rotateRight() {
            TreeNode<K, V> left = this.left;
            this.left = left.right;
            left.right = this;
            this.fix();
            left.fix();
            return left;
        }

        public TreeNode<K, V> rotateLeft() {
            TreeNode<K, V> right = this.right;
            this.right = right.left;
            right.left = this;
            this.fix();
            right.fix();
            return right;
        }

        public void fix() {
            this.height = Math.max(this.right != null ? this.right.height : 0, this.left != null ? this.left.height : 0) + 1;
            this.size = 1;
            if (this.left != null) {
                this.size += this.left.size;
            }
            if (this.right != null) {
                this.size += this.right.size;
            }
        }

        public TreeNode<K, V> forward(boolean reverse) {
            return !reverse ? this.left : this.right;
        }

        public TreeNode<K, V> down(boolean reverse) {
            return !reverse ? this.right : this.left;
        }
    }

    static class EntrySet<K, V>
    extends TAbstractSet<TMap.Entry<K, V>> {
        private int modCount = -1;
        private TTreeMap<K, V> owner;
        private K from;
        private boolean fromIncluded;
        private boolean fromChecked;
        private K to;
        private boolean toIncluded;
        private boolean toChecked;
        private int cachedSize;
        private boolean reverse;

        EntrySet(TTreeMap<K, V> owner, K from, boolean fromIncluded, boolean fromChecked, K to, boolean toIncluded, boolean toChecked, boolean reverse) {
            this.owner = owner;
            this.from = from;
            this.fromIncluded = fromIncluded;
            this.fromChecked = fromChecked;
            this.to = to;
            this.toIncluded = toIncluded;
            this.toChecked = toChecked;
            this.reverse = reverse;
        }

        @Override
        public int size() {
            int size = this.cachedSize;
            if (this.modCount != this.owner.modCount) {
                TreeNode<K, V>[] path;
                this.modCount = this.owner.modCount;
                size = this.owner.size();
                if (this.fromChecked) {
                    for (TreeNode<K, V> node : path = this.fromIncluded ? this.owner.pathToNext(this.from, true) : this.owner.pathToExactOrNext(this.from, true)) {
                        if (node.left == null) continue;
                        size -= node.left.size;
                    }
                    size -= path.length;
                }
                if (this.toChecked) {
                    for (TreeNode<K, V> node : path = this.toIncluded ? this.owner.pathToNext(this.to, false) : this.owner.pathToExactOrNext(this.to, false)) {
                        if (node.right == null) continue;
                        size -= node.right.size;
                    }
                    size -= path.length;
                }
                this.cachedSize = size;
            }
            return size;
        }

        @Override
        public TIterator<TMap.Entry<K, V>> iterator() {
            return !this.reverse ? this.ascendingIterator() : this.descendingIterator();
        }

        private TIterator<TMap.Entry<K, V>> ascendingIterator() {
            TreeNode<K, V>[] fromPath = this.fromChecked ? (this.fromIncluded ? this.owner.pathToExactOrNext(this.from, false) : this.owner.pathToNext(this.from, false)) : this.owner.pathToFirst(false);
            return new EntryIterator<K, V>(this.owner, fromPath, this.to, this.toChecked, this.toIncluded, false);
        }

        private TIterator<TMap.Entry<K, V>> descendingIterator() {
            TreeNode<K, V>[] toPath = this.toChecked ? (this.toIncluded ? this.owner.pathToExactOrNext(this.to, true) : this.owner.pathToNext(this.to, true)) : this.owner.pathToFirst(true);
            return new EntryIterator<K, V>(this.owner, toPath, this.from, this.fromIncluded, this.fromChecked, true);
        }

        @Override
        public boolean contains(Object o) {
            TreeNode<?, V> node;
            int cmp;
            if (!(o instanceof TMap.Entry)) {
                return false;
            }
            TMap.Entry entry = (TMap.Entry)o;
            Object key = entry.getKey();
            if (this.from != null) {
                cmp = this.owner.comparator.compare(key, this.from);
                if (this.fromIncluded ? cmp < 0 : cmp <= 0) {
                    return false;
                }
            }
            if (this.to != null) {
                cmp = this.owner.comparator.compare(key, this.to);
                if (this.toIncluded ? cmp > 0 : cmp >= 0) {
                    return false;
                }
            }
            return (node = this.owner.findExact(key)) != null && node.equals(o);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    static class MapView<K, V>
    extends TAbstractMap<K, V>
    implements TNavigableMap<K, V>,
    TSerializable {
        private int modCount = -1;
        private int cachedSize;
        private TTreeMap<K, V> owner;
        private K from;
        private boolean fromIncluded;
        private boolean fromChecked;
        private K to;
        private boolean toIncluded;
        private boolean toChecked;
        private EntrySet<K, V> entrySetCache;
        private boolean reverse;
        private NavigableKeySet<K, V> cachedNavigableKeySet;

        MapView(TTreeMap<K, V> owner, K from, boolean fromIncluded, boolean fromChecked, K to, boolean toIncluded, boolean toChecked, boolean reverse) {
            this.owner = owner;
            this.from = from;
            this.fromIncluded = fromIncluded;
            this.fromChecked = fromChecked;
            this.to = to;
            this.toIncluded = toIncluded;
            this.toChecked = toChecked;
            this.reverse = reverse;
        }

        @Override
        public TSet<TMap.Entry<K, V>> entrySet() {
            if (this.entrySetCache == null) {
                this.entrySetCache = new EntrySet<K, V>(this.owner, this.from, this.fromIncluded, this.fromChecked, this.to, this.toIncluded, this.toChecked, this.reverse);
            }
            return this.entrySetCache;
        }

        @Override
        public TComparator<? super K> comparator() {
            if (!this.reverse) {
                return this.owner.originalComparator;
            }
            this.owner.ensureRevertedComparator();
            return this.owner.revertedComparator;
        }

        private void checkKey(K key) {
            if (!this.keyInRange(key)) {
                throw new TIllegalArgumentException();
            }
        }

        private boolean keyInRange(K key) {
            int cmp;
            if (this.fromChecked) {
                cmp = this.owner.comparator.compare(key, this.from);
                if (this.fromIncluded ? cmp < 0 : cmp <= 0) {
                    return false;
                }
            }
            if (this.toChecked) {
                cmp = this.owner.comparator.compare(key, this.to);
                if (this.fromIncluded ? cmp > 0 : cmp >= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public V get(Object key) {
            if (!this.keyInRange(key)) {
                return null;
            }
            return this.owner.get(key);
        }

        @Override
        public V remove(Object key) {
            if (!this.keyInRange(key)) {
                return null;
            }
            return this.owner.remove(key);
        }

        @Override
        public V put(K key, V value) {
            this.checkKey(key);
            return this.owner.put(key, value);
        }

        @Override
        public void clear() {
            if (!this.fromChecked && !this.toChecked) {
                this.owner.clear();
            } else {
                super.clear();
            }
        }

        @Override
        public int size() {
            int size = this.cachedSize;
            if (this.modCount != this.owner.modCount) {
                TreeNode<K, V>[] path;
                this.modCount = this.owner.modCount;
                size = this.owner.size();
                if (this.fromChecked) {
                    for (TreeNode<K, V> node : path = this.fromIncluded ? this.owner.pathToNext(this.from, true) : this.owner.pathToExactOrNext(this.from, true)) {
                        if (node.left == null) continue;
                        size -= node.left.size;
                    }
                    size -= path.length;
                }
                if (this.toChecked) {
                    for (TreeNode<K, V> node : path = this.toIncluded ? this.owner.pathToNext(this.to, false) : this.owner.pathToExactOrNext(this.to, false)) {
                        if (node.right == null) continue;
                        size -= node.right.size;
                    }
                    size -= path.length;
                }
                this.cachedSize = size;
            }
            return size;
        }

        @Override
        public boolean containsKey(Object key) {
            int cmp;
            if (this.fromChecked) {
                cmp = this.owner.comparator.compare(key, this.from);
                if (this.fromIncluded ? cmp < 0 : cmp <= 0) {
                    return false;
                }
            }
            if (this.toChecked) {
                cmp = this.owner.comparator.compare(key, this.to);
                if (this.fromIncluded ? cmp > 0 : cmp >= 0) {
                    return false;
                }
            }
            return this.owner.containsKey(key);
        }

        @Override
        public TSortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public TSortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public TSortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        @Override
        public K firstKey() {
            TreeNode<K, V> node;
            TreeNode<K, V> treeNode = node = !this.reverse ? this.firstNode() : this.lastNode();
            if (node == null) {
                throw new TNoSuchElementException();
            }
            return node.getKey();
        }

        @Override
        public K lastKey() {
            TreeNode<K, V> node;
            TreeNode<K, V> treeNode = node = !this.reverse ? this.lastNode() : this.firstNode();
            if (node == null) {
                throw new TNoSuchElementException();
            }
            return node.getKey();
        }

        private TreeNode<K, V> firstNode() {
            TreeNode<K, V> node = this.fromChecked ? (this.fromIncluded ? this.owner.findExactOrNext(this.from, false) : this.owner.findNext(this.from, false)) : this.owner.firstNode(false);
            if (this.toChecked) {
                int cmp = this.owner.comparator.compare(node.getKey(), this.to);
                if (this.toIncluded ? cmp > 0 : cmp >= 0) {
                    return null;
                }
            }
            return node;
        }

        private TreeNode<K, V> lastNode() {
            TreeNode<K, V> node = this.toChecked ? (this.toIncluded ? this.owner.findExactOrNext(this.to, true) : this.owner.findNext(this.to, true)) : this.owner.firstNode(true);
            if (this.fromChecked) {
                int cmp = this.owner.comparator.compare(node.getKey(), this.from);
                if (this.fromIncluded ? cmp < 0 : cmp <= 0) {
                    return null;
                }
            }
            return node;
        }

        @Override
        public TMap.Entry<K, V> lowerEntry(K key) {
            return null;
        }

        @Override
        public K lowerKey(K key) {
            return null;
        }

        @Override
        public TMap.Entry<K, V> floorEntry(K key) {
            return null;
        }

        @Override
        public K floorKey(K key) {
            return null;
        }

        @Override
        public TMap.Entry<K, V> ceilingEntry(K key) {
            return null;
        }

        @Override
        public K ceilingKey(K key) {
            return null;
        }

        @Override
        public TMap.Entry<K, V> higherEntry(K key) {
            return null;
        }

        @Override
        public K higherKey(K key) {
            return null;
        }

        @Override
        public TMap.Entry<K, V> firstEntry() {
            return !this.reverse ? this.firstNode() : this.lastNode();
        }

        @Override
        public TMap.Entry<K, V> lastEntry() {
            return !this.reverse ? this.lastNode() : this.firstNode();
        }

        @Override
        public TMap.Entry<K, V> pollFirstEntry() {
            TreeNode<K, V> node;
            TreeNode<K, V> treeNode = node = !this.reverse ? this.firstNode() : this.lastNode();
            if (node != null) {
                this.owner.deleteNode(this.owner.root, node.getKey());
            }
            return node;
        }

        @Override
        public TMap.Entry<K, V> pollLastEntry() {
            TreeNode<K, V> node;
            TreeNode<K, V> treeNode = node = !this.reverse ? this.lastNode() : this.firstNode();
            if (node != null) {
                this.owner.deleteNode(this.owner.root, node.getKey());
            }
            return node;
        }

        @Override
        public TNavigableMap<K, V> descendingMap() {
            return new MapView<K, V>(this.owner, this.from, this.fromIncluded, this.fromChecked, this.to, this.toIncluded, this.toChecked, !this.reverse);
        }

        @Override
        public TNavigableSet<K> navigableKeySet() {
            if (this.cachedNavigableKeySet == null) {
                this.cachedNavigableKeySet = new NavigableKeySet(this);
            }
            return this.cachedNavigableKeySet;
        }

        @Override
        public TNavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public TNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            this.checkKey(fromKey);
            this.checkKey(toKey);
            if (!this.reverse) {
                if (this.owner.comparator.compare(fromKey, toKey) > 0) {
                    throw new IllegalArgumentException();
                }
                return new MapView<K, V>(this.owner, fromKey, fromInclusive, true, toKey, toInclusive, true, false);
            }
            if (this.owner.comparator.compare(fromKey, toKey) < 0) {
                throw new IllegalArgumentException();
            }
            return new MapView<K, V>(this.owner, toKey, toInclusive, true, fromKey, fromInclusive, true, true);
        }

        @Override
        public TNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            this.checkKey(toKey);
            if (!this.reverse) {
                return new MapView<K, V>(this.owner, this.from, this.fromIncluded, this.fromChecked, toKey, inclusive, true, false);
            }
            return new MapView<K, V>(this.owner, toKey, inclusive, true, this.to, this.toIncluded, this.toChecked, true);
        }

        @Override
        public TNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            this.checkKey(fromKey);
            if (!this.reverse) {
                return new MapView<K, V>(this.owner, fromKey, inclusive, true, this.to, this.toIncluded, this.toChecked, false);
            }
            return new MapView<K, V>(this.owner, this.from, this.fromIncluded, this.toChecked, fromKey, inclusive, true, true);
        }
    }

    static class NavigableKeySet<K, V>
    extends TAbstractSet<K>
    implements TNavigableSet<K> {
        private TNavigableMap<K, V> map;

        NavigableKeySet(TNavigableMap<K, V> map) {
            this.map = map;
        }

        @Override
        public TComparator<? super K> comparator() {
            return this.map.comparator();
        }

        @Override
        public TSortedSet<K> subSet(K fromElement, K toElement) {
            return this.map.subMap(fromElement, true, toElement, false).navigableKeySet();
        }

        @Override
        public TSortedSet<K> headSet(K toElement) {
            return this.map.headMap(toElement, false).navigableKeySet();
        }

        @Override
        public TSortedSet<K> tailSet(K fromElement) {
            return this.map.headMap(fromElement, true).navigableKeySet();
        }

        @Override
        public K first() {
            return this.map.firstKey();
        }

        @Override
        public K last() {
            return this.map.lastKey();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public TIterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public K lower(K e) {
            return this.map.lowerKey(e);
        }

        @Override
        public K floor(K e) {
            return this.map.floorKey(e);
        }

        @Override
        public K ceiling(K e) {
            return this.map.ceilingKey(e);
        }

        @Override
        public K higher(K e) {
            return this.map.higherKey(e);
        }

        @Override
        public K pollFirst() {
            TMap.Entry<K, V> entry = this.map.pollFirstEntry();
            return entry != null ? (K)entry.getKey() : null;
        }

        @Override
        public K pollLast() {
            TMap.Entry<K, V> entry = this.map.pollLastEntry();
            return entry != null ? (K)entry.getKey() : null;
        }

        @Override
        public TNavigableSet<K> descendingSet() {
            return this.map.descendingMap().navigableKeySet();
        }

        @Override
        public TIterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public TNavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            return this.map.subMap(fromElement, fromInclusive, toElement, toInclusive).navigableKeySet();
        }

        @Override
        public TNavigableSet<K> headSet(K toElement, boolean inclusive) {
            return this.map.headMap(toElement, inclusive).navigableKeySet();
        }

        @Override
        public TNavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            return this.map.headMap(fromElement, inclusive).navigableKeySet();
        }
    }

    static class EntryIterator<K, V>
    implements TIterator<TMap.Entry<K, V>> {
        private int modCount;
        private TTreeMap<K, V> owner;
        private TreeNode<K, V>[] path;
        private TreeNode<K, V> last;
        private K to;
        private boolean toChecked;
        private boolean toIncluded;
        private int depth;
        private boolean reverse;

        EntryIterator(TTreeMap<K, V> owner, TreeNode<K, V>[] path, K to, boolean toChecked, boolean toIncluded, boolean reverse) {
            this.owner = owner;
            this.modCount = owner.modCount;
            this.path = TArrays.copyOf(path, owner.root == null ? 0 : owner.root.height);
            this.depth = path.length;
            this.to = to;
            this.toChecked = toChecked;
            this.toIncluded = toIncluded;
            this.reverse = reverse;
            this.checkFinished();
        }

        @Override
        public boolean hasNext() {
            return this.depth > 0;
        }

        @Override
        public TMap.Entry<K, V> next() {
            if (this.modCount != this.owner.modCount) {
                throw new TConcurrentModificationException();
            }
            if (this.depth == 0) {
                throw new TNoSuchElementException();
            }
            TreeNode<K, V> node = this.path[--this.depth];
            this.last = node;
            TreeNode<K, V> down = node.down(this.reverse);
            if (down != null) {
                for (node = down; node != null; node = node.forward(this.reverse)) {
                    this.path[this.depth++] = node;
                }
            }
            this.checkFinished();
            return this.last;
        }

        private void checkFinished() {
            if (!this.toChecked || this.depth == 0) {
                return;
            }
            int cmp = this.owner.comparator.compare(this.path[this.depth - 1].getKey(), this.to);
            if (this.reverse) {
                cmp = -cmp;
            }
            if (this.toIncluded) {
                if (cmp > 0) {
                    this.depth = 0;
                }
            } else if (cmp >= 0) {
                this.depth = 0;
            }
        }

        @Override
        public void remove() {
            if (this.modCount != this.owner.modCount) {
                throw new TConcurrentModificationException();
            }
            if (this.last == null) {
                throw new TNoSuchElementException();
            }
            this.owner.root = this.owner.deleteNode(this.owner.root, this.last.getKey());
            this.modCount = ++this.owner.modCount;
            this.last = null;
        }
    }
}

