/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.stream.TIntStream;

public class TOptionalInt {
    private static TOptionalInt emptyInstance;
    private final int value;

    private TOptionalInt(int value) {
        this.value = value;
    }

    public static TOptionalInt empty() {
        if (emptyInstance == null) {
            emptyInstance = new TOptionalInt(0);
        }
        return emptyInstance;
    }

    public static TOptionalInt of(int value) {
        return new TOptionalInt(value);
    }

    public int getAsInt() {
        if (this == emptyInstance) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean isPresent() {
        return this != emptyInstance;
    }

    public boolean isEmpty() {
        return this == emptyInstance;
    }

    public void ifPresent(IntConsumer consumer) {
        if (this != emptyInstance) {
            consumer.accept(this.value);
        }
    }

    public int orElse(int other) {
        return this != emptyInstance ? this.value : other;
    }

    public int orElseGet(IntSupplier other) {
        return this != emptyInstance ? this.value : other.getAsInt();
    }

    public void ifPresentOrElse(IntConsumer action, Runnable emptyAction) {
        if (this == emptyInstance) {
            emptyAction.run();
        } else {
            action.accept(this.value);
        }
    }

    public <X extends Throwable> int orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this == emptyInstance) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public int orElseThrow() {
        if (this == emptyInstance) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public TIntStream stream() {
        if (this == emptyInstance) {
            return TIntStream.empty();
        }
        return TIntStream.of(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this == emptyInstance || obj == emptyInstance || !(obj instanceof TOptionalInt)) {
            return false;
        }
        return ((TOptionalInt)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.isPresent() ? "OptionalInt.of(" + this.value + ")" : "OptionalInt.empty()";
    }
}

