/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.impl.Base64Impl;

public class TBase64 {
    public static Encoder getEncoder() {
        return new Encoder(Base64Impl.alphabet, true);
    }

    public static Encoder getUrlEncoder() {
        return new Encoder(Base64Impl.urlAlphabet, false);
    }

    public Decoder getDecoder() {
        return new Decoder(Base64Impl.reverse);
    }

    public Decoder getUrlDecoder() {
        return new Decoder(Base64Impl.urlReverse);
    }

    public static class Encoder {
        private final byte[] mapping;
        private final boolean padding;

        private Encoder(byte[] mapping, boolean padding) {
            this.mapping = mapping;
            this.padding = padding;
        }

        public byte[] encode(byte[] src) {
            return Base64Impl.encode(src, this.mapping, this.padding);
        }

        public String encodeToString(byte[] src) {
            byte[] bytes = this.encode(src);
            char[] chars = new char[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                chars[i] = (char)(bytes[i] & 0xFF);
            }
            return new String(chars);
        }

        public Encoder withoutPadding() {
            return new Encoder(this.mapping, false);
        }
    }

    public static class Decoder {
        private final int[] mapping;

        private Decoder(int[] mapping) {
            this.mapping = mapping;
        }

        public byte[] decode(byte[] src) {
            return Base64Impl.decode(src, this.mapping);
        }

        public byte[] decode(String src) {
            byte[] bytes = new byte[src.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)src.charAt(i);
            }
            return this.decode(bytes);
        }
    }
}

