/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream;

import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.stream.TBaseStream;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.intimpl.TArrayIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TEmptyIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TGenerateIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TGenericConcatIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TIntStreamBuilder;
import org.teavm.classlib.java.util.stream.intimpl.TIterateIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TRangeIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TSingleIntStreamImpl;
import org.teavm.classlib.java.util.stream.intimpl.TSpecializedConcatIntStream;

public interface TIntStream
extends TBaseStream<Integer, TIntStream> {
    public TIntStream filter(IntPredicate var1);

    public TIntStream map(IntUnaryOperator var1);

    public <U> TStream<U> mapToObj(IntFunction<? extends U> var1);

    public TLongStream mapToLong(IntToLongFunction var1);

    public TDoubleStream mapToDouble(IntToDoubleFunction var1);

    public TIntStream flatMap(IntFunction<? extends TIntStream> var1);

    public TIntStream distinct();

    public TIntStream sorted();

    public TIntStream peek(IntConsumer var1);

    public TIntStream limit(long var1);

    public TIntStream skip(long var1);

    public void forEach(IntConsumer var1);

    public void forEachOrdered(IntConsumer var1);

    public int[] toArray();

    public int reduce(int var1, IntBinaryOperator var2);

    public OptionalInt reduce(IntBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjIntConsumer<R> var2, BiConsumer<R, R> var3);

    public int sum();

    public OptionalInt min();

    public OptionalInt max();

    public long count();

    public OptionalDouble average();

    public boolean anyMatch(IntPredicate var1);

    public boolean allMatch(IntPredicate var1);

    public boolean noneMatch(IntPredicate var1);

    public OptionalInt findFirst();

    public OptionalInt findAny();

    public TLongStream asLongStream();

    public TDoubleStream asDoubleStream();

    public TStream<Integer> boxed();

    public PrimitiveIterator.OfInt iterator();

    public Spliterator.OfInt spliterator();

    public static Builder builder() {
        return new TIntStreamBuilder();
    }

    public static TIntStream empty() {
        return new TEmptyIntStreamImpl();
    }

    public static TIntStream of(int t) {
        return new TSingleIntStreamImpl(t);
    }

    public static TIntStream of(int ... values) {
        return new TArrayIntStreamImpl(values, 0, values.length);
    }

    public static TIntStream iterate(int seed, IntUnaryOperator f) {
        return new TIterateIntStream(seed, f);
    }

    public static TIntStream generate(IntSupplier s) {
        return new TGenerateIntStream(s);
    }

    public static TIntStream range(int startInclusive, int endExclusive) {
        return new TRangeIntStream(startInclusive, endExclusive);
    }

    public static TIntStream rangeClosed(int startInclusive, int endInclusive) {
        return new TRangeIntStream(startInclusive, endInclusive + 1);
    }

    public static TIntStream concat(TIntStream a, TIntStream b) {
        if (a instanceof TSimpleIntStreamImpl && b instanceof TSimpleIntStreamImpl) {
            return new TSpecializedConcatIntStream((TSimpleIntStreamImpl)a, (TSimpleIntStreamImpl)b);
        }
        return new TGenericConcatIntStream(a, b);
    }

    public static interface Builder {
        public void accept(int var1);

        default public Builder add(int t) {
            this.accept(t);
            return this;
        }

        public TIntStream build();
    }
}

