/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.Properties;
import org.teavm.interop.Export;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.FieldHolder;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class ScalaHacks
implements ClassHolderTransformer {
    private static final String ATTR_NAME_CLASS = "java.util.jar.Attributes$Name";
    private static final String SCALA_INTERNAL_CLASS_MARKER = "$";

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        switch (cls.getName()) {
            case "scala.util.PropertiesTrait$class": {
                this.transformPropertiesTrait(cls, context.getHierarchy());
                break;
            }
            case "scala.util.Properties$": {
                this.transformProperties(cls);
                break;
            }
            default: {
                if (!cls.getName().endsWith(SCALA_INTERNAL_CLASS_MARKER)) break;
                this.checkAndRemoveExportAnnotation(cls);
            }
        }
    }

    private void transformPropertiesTrait(ClassHolder cls, ClassHierarchy hierarchy) {
        for (MethodHolder method : cls.getMethods()) {
            if (!method.getName().equals("scalaProps")) continue;
            ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
            pe.construct(Properties.class, new ValueEmitter[0]).returnValue();
        }
    }

    private void transformProperties(ClassHolder cls) {
        for (FieldHolder fieldHolder : cls.getFields().toArray(new FieldHolder[0])) {
            if (!fieldHolder.getName().equals("ScalaCompilerVersion")) continue;
            cls.removeField(fieldHolder);
        }
        for (FieldHolder fieldHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            if (fieldHolder.getName().equals("ScalaCompilerVersion")) {
                cls.removeMethod((MethodHolder)fieldHolder);
                continue;
            }
            if (!fieldHolder.getName().equals("<init>")) continue;
            Program program = fieldHolder.getProgram();
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                for (Instruction insn : block) {
                    ConstructInstruction cons;
                    if (insn instanceof InvokeInstruction) {
                        if (!((InvokeInstruction)insn).getMethod().getClassName().equals(ATTR_NAME_CLASS)) continue;
                        insn.delete();
                        continue;
                    }
                    if (insn instanceof PutFieldInstruction) {
                        if (!((PutFieldInstruction)insn).getField().getFieldName().equals("ScalaCompilerVersion")) continue;
                        insn.delete();
                        continue;
                    }
                    if (!(insn instanceof ConstructInstruction) || !(cons = (ConstructInstruction)insn).getType().equals(ATTR_NAME_CLASS)) continue;
                    cons.setType("java.lang.Object");
                }
            }
        }
    }

    private void checkAndRemoveExportAnnotation(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            AnnotationContainer items = method.getAnnotations();
            AnnotationHolder exportAnn = items.get(Export.class.getTypeName());
            if (exportAnn == null) continue;
            method.getAnnotations().remove(exportAnn);
        }
    }
}

