/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.util.ArrayList;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.annotation.TAnnotation;
import org.teavm.classlib.java.lang.reflect.TArray;

public interface TAnnotatedElement {
    default public boolean isAnnotationPresent(TClass<? extends TAnnotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <T extends TAnnotation> T getAnnotation(TClass<T> var1);

    public TAnnotation[] getAnnotations();

    public TAnnotation[] getDeclaredAnnotations();

    default public <T extends TAnnotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        ArrayList<T> result = new ArrayList<T>();
        Class<T> classAsObject = annotationClass;
        for (TAnnotation annot : this.getAnnotations()) {
            if (annot.annotationType() != classAsObject) continue;
            result.add(annotationClass.cast((TObject)((Object)annot)));
        }
        TAnnotation[] array = (TAnnotation[])TArray.newInstance(annotationClass, result.size());
        return result.toArray(array);
    }

    default public <T extends TAnnotation> T getDeclaredAnnotation(TClass<T> annotationClass) {
        TClass<T> classAsObject = annotationClass;
        for (TAnnotation annot : this.getDeclaredAnnotations()) {
            if (annot.annotationType() != classAsObject) continue;
            return (T)((TAnnotation)annotationClass.cast((TObject)((Object)annot)));
        }
        return null;
    }

    default public <T extends TAnnotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        ArrayList<T> result = new ArrayList<T>();
        Class<T> classAsObject = annotationClass;
        for (TAnnotation annot : this.getDeclaredAnnotations()) {
            if (annot.annotationType() != classAsObject) continue;
            result.add(annotationClass.cast((TObject)((Object)annot)));
        }
        TAnnotation[] array = (TAnnotation[])TArray.newInstance(annotationClass, result.size());
        return result.toArray(array);
    }
}

