/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.io.IOException;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReference;

public class DeclaringClassGenerator
implements Generator {
    private static final MethodReference METHOD = new MethodReference(Class.class, "getDeclaringClass", new Class[]{Class.class});

    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        writer.append("var p").ws().append("=").ws().append("\"teavm_declaredClass\";").softNewLine();
        writer.append("if").ws().append("(!").appendMethodBody(methodRef).append(".initialized").append(")").ws().append("{").indent().softNewLine();
        MethodDependencyInfo methodDep = context.getDependency().getMethod(METHOD);
        if (methodDep != null) {
            for (String type : methodDep.getVariable(0).getClassValueNode().getTypes()) {
                ClassReader cls = context.getClassSource().get(type);
                if (cls == null) continue;
                writer.appendClass(type).append("[p]").ws().append("=").ws();
                if (cls.getOwnerName() != null) {
                    writer.appendClass(cls.getOwnerName());
                } else {
                    writer.append("null");
                }
                writer.append(";").softNewLine();
            }
        }
        writer.appendMethodBody(methodRef).append(".initialized").ws().append("=").ws().append("true;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return ").append(context.getParameterName(1)).append("[p];").softNewLine();
    }
}

