/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TSet;

public interface TMap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public V get(Object var1);

    public V put(K var1, V var2);

    public V remove(Object var1);

    public void putAll(TMap<? extends K, ? extends V> var1);

    public void clear();

    public TSet<K> keySet();

    public TCollection<V> values();

    public TSet<Entry<K, V>> entrySet();

    default public boolean replace(K key, V value, V newValue) {
        if (this.containsKey(key) && TObjects.equals(this.get(key), value)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    default public V replace(K key, V value) {
        if (this.containsKey(key)) {
            return this.put(key, value);
        }
        return null;
    }

    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V v = this.get(key);
        if (v == null) {
            V newValue = mappingFunction.apply(key);
            if (newValue != null) {
                this.put(key, newValue);
            }
            return newValue;
        }
        return v;
    }

    default public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V v = this.get(key);
        if (v != null) {
            V oldValue = v;
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                this.put(key, newValue);
            } else {
                this.remove(key);
            }
            return newValue;
        }
        return null;
    }

    default public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V oldValue = this.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (oldValue != null) {
            if (newValue != null) {
                this.put(key, newValue);
            } else {
                this.remove(key);
            }
        } else if (newValue != null) {
            this.put(key, newValue);
        }
        return newValue;
    }

    default public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        V oldValue = this.get(key);
        V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        if (newValue == null) {
            this.remove(key);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }

    public static interface Entry<K1, V1> {
        public K1 getKey();

        public V1 getValue();

        public V1 setValue(V1 var1);
    }
}

