/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.classlib.java.nio.TShortBuffer;

abstract class TShortBufferImpl
extends TShortBuffer {
    public TShortBufferImpl(int capacity, int position, int limit) {
        super(capacity, position, limit);
    }

    @Override
    public TShortBuffer slice() {
        return this.duplicate(this.position, this.limit - this.position, 0, this.limit - this.position, this.isReadOnly());
    }

    @Override
    public TShortBuffer duplicate() {
        return this.duplicate(0, this.capacity, this.position, this.limit, this.isReadOnly());
    }

    @Override
    public TShortBuffer asReadOnlyBuffer() {
        return this.duplicate(0, this.capacity, this.position, this.limit, true);
    }

    abstract TShortBuffer duplicate(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public short get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.getElement(this.position++);
    }

    @Override
    public TShortBuffer put(short b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.putElement(this.position++, b);
        return this;
    }

    @Override
    public short get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        return this.getElement(index);
    }

    @Override
    public TShortBuffer put(int index, short b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        this.putElement(index, b);
        return this;
    }

    @Override
    public TShortBuffer compact() {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.position > 0) {
            int sz = this.remaining();
            int src = this.position;
            for (int i = 0; i < sz; ++i) {
                this.putElement(i, this.getElement(src++));
            }
            this.position = sz;
        }
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly();
    }

    abstract boolean readOnly();
}

