/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferOverByteBufferBigEndian;
import org.teavm.classlib.java.nio.TCharBufferOverByteBufferLittleEndian;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferOverByteBuffer;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferOverByteBufferBigEndian;
import org.teavm.classlib.java.nio.TFloatBufferOverByteBufferLittleEndian;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferOverByteBufferBigEndian;
import org.teavm.classlib.java.nio.TIntBufferOverByteBufferLittleEndian;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferOverByteBufferBigEndian;
import org.teavm.classlib.java.nio.TLongBufferOverByteBufferLittleEndian;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferOverByteBufferBigEndian;
import org.teavm.classlib.java.nio.TShortBufferOverByteBufferLittleEndian;

class TByteBufferImpl
extends TByteBuffer {
    private boolean direct;
    private boolean readOnly;

    public TByteBufferImpl(int capacity, boolean direct) {
        this(0, capacity, new byte[capacity], 0, capacity, direct, false);
    }

    public TByteBufferImpl(int start, int capacity, byte[] array, int position, int limit, boolean direct, boolean readOnly) {
        super(start, capacity, array, position, limit);
        this.direct = direct;
        this.readOnly = readOnly;
    }

    @Override
    public TByteBuffer slice() {
        return new TByteBufferImpl(this.position, this.limit - this.position, this.array, 0, this.limit - this.position, this.direct, this.readOnly);
    }

    @Override
    public TByteBuffer duplicate() {
        return new TByteBufferImpl(this.start, this.capacity, this.array, this.position, this.limit, this.direct, this.readOnly);
    }

    @Override
    public TByteBuffer asReadOnlyBuffer() {
        return new TByteBufferImpl(this.start, this.capacity, this.array, this.position, this.limit, this.direct, true);
    }

    @Override
    public byte get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.array[this.start + this.position++];
    }

    @Override
    public TByteBuffer put(byte b) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.array[this.start + this.position++] = b;
        return this;
    }

    @Override
    public byte get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        return this.array[this.start + index];
    }

    @Override
    public TByteBuffer put(int index, byte b) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        this.array[this.start + index] = b;
        return this;
    }

    @Override
    public TByteBuffer compact() {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position > 0) {
            int sz = this.remaining();
            int dst = this.start;
            int src = this.start + this.position;
            for (int i = 0; i < sz; ++i) {
                this.array[dst++] = this.array[src++];
            }
            this.position = sz;
        }
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public char getChar() {
        if (this.position + 1 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        int a = this.array[this.start + this.position] & 0xFF;
        int b = this.array[this.start + this.position + 1] & 0xFF;
        this.position += 2;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return (char)(a << 8 | b);
        }
        return (char)(b << 8 | a);
    }

    @Override
    public TByteBuffer putChar(char value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 1 >= this.limit) {
            throw new TBufferOverflowException();
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + this.position++] = (byte)(value >> 8);
            this.array[this.start + this.position++] = (byte)value;
        } else {
            this.array[this.start + this.position++] = (byte)value;
            this.array[this.start + this.position++] = (byte)(value >> 8);
        }
        return this;
    }

    @Override
    public char getChar(int index) {
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 1) + ")");
        }
        int a = this.array[this.start + index] & 0xFF;
        int b = this.array[this.start + index + 1] & 0xFF;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return (char)(a << 8 | b);
        }
        return (char)(b << 8 | a);
    }

    @Override
    public TByteBuffer putChar(int index, char value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 1) + ")");
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + index] = (byte)(value >> 8);
            this.array[this.start + index + 1] = (byte)value;
        } else {
            this.array[this.start + index] = (byte)value;
            this.array[this.start + index + 1] = (byte)(value >> 8);
        }
        return this;
    }

    @Override
    public TCharBuffer asCharBuffer() {
        int sz = this.remaining() / 2;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return new TCharBufferOverByteBufferBigEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
        }
        return new TCharBufferOverByteBufferLittleEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
    }

    @Override
    public short getShort() {
        if (this.position + 1 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        int a = this.array[this.start + this.position] & 0xFF;
        int b = this.array[this.start + this.position + 1] & 0xFF;
        this.position += 2;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return (short)(a << 8 | b);
        }
        return (short)(b << 8 | a);
    }

    @Override
    public TByteBuffer putShort(short value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 1 >= this.limit) {
            throw new TBufferOverflowException();
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + this.position++] = (byte)(value >> 8);
            this.array[this.start + this.position++] = (byte)value;
        } else {
            this.array[this.start + this.position++] = (byte)value;
            this.array[this.start + this.position++] = (byte)(value >> 8);
        }
        return this;
    }

    @Override
    public short getShort(int index) {
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 1) + ")");
        }
        int a = this.array[this.start + index] & 0xFF;
        int b = this.array[this.start + index + 1] & 0xFF;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return (short)(a << 8 | b);
        }
        return (short)(b << 8 | a);
    }

    @Override
    public TByteBuffer putShort(int index, short value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 1 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 1) + ")");
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + index] = (byte)(value >> 8);
            this.array[this.start + index + 1] = (byte)value;
        } else {
            this.array[this.start + index] = (byte)value;
            this.array[this.start + index + 1] = (byte)(value >> 8);
        }
        return this;
    }

    @Override
    public TShortBuffer asShortBuffer() {
        int sz = this.remaining() / 2;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return new TShortBufferOverByteBufferBigEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
        }
        return new TShortBufferOverByteBufferLittleEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
    }

    @Override
    public int getInt() {
        if (this.position + 3 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        int a = this.array[this.start + this.position] & 0xFF;
        int b = this.array[this.start + this.position + 1] & 0xFF;
        int c = this.array[this.start + this.position + 2] & 0xFF;
        int d = this.array[this.start + this.position + 3] & 0xFF;
        this.position += 4;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return a << 24 | b << 16 | c << 8 | d;
        }
        return d << 24 | c << 16 | b << 8 | a;
    }

    @Override
    public TByteBuffer putInt(int value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 3 >= this.limit) {
            throw new TBufferOverflowException();
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + this.position++] = (byte)(value >> 24);
            this.array[this.start + this.position++] = (byte)(value >> 16);
            this.array[this.start + this.position++] = (byte)(value >> 8);
            this.array[this.start + this.position++] = (byte)value;
        } else {
            this.array[this.start + this.position++] = (byte)value;
            this.array[this.start + this.position++] = (byte)(value >> 8);
            this.array[this.start + this.position++] = (byte)(value >> 16);
            this.array[this.start + this.position++] = (byte)(value >> 24);
        }
        return this;
    }

    @Override
    public int getInt(int index) {
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 3) + ")");
        }
        int a = this.array[this.start + index] & 0xFF;
        int b = this.array[this.start + index + 1] & 0xFF;
        int c = this.array[this.start + index + 2] & 0xFF;
        int d = this.array[this.start + index + 3] & 0xFF;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return a << 24 | b << 16 | c << 8 | d;
        }
        return d << 24 | c << 16 | b << 8 | a;
    }

    @Override
    public TByteBuffer putInt(int index, int value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 3) + ")");
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + index] = (byte)(value >> 24);
            this.array[this.start + index + 1] = (byte)(value >> 16);
            this.array[this.start + index + 2] = (byte)(value >> 8);
            this.array[this.start + index + 3] = (byte)value;
        } else {
            this.array[this.start + index] = (byte)value;
            this.array[this.start + index + 1] = (byte)(value >> 8);
            this.array[this.start + index + 2] = (byte)(value >> 16);
            this.array[this.start + index + 3] = (byte)(value >> 24);
        }
        return this;
    }

    @Override
    public TIntBuffer asIntBuffer() {
        int sz = this.remaining() / 4;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return new TIntBufferOverByteBufferBigEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
        }
        return new TIntBufferOverByteBufferLittleEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
    }

    @Override
    public long getLong() {
        if (this.position + 7 >= this.limit) {
            throw new TBufferUnderflowException();
        }
        long a = this.array[this.start + this.position] & 0xFF;
        long b = this.array[this.start + this.position + 1] & 0xFF;
        long c = this.array[this.start + this.position + 2] & 0xFF;
        long d = this.array[this.start + this.position + 3] & 0xFF;
        long e = this.array[this.start + this.position + 4] & 0xFF;
        long f = this.array[this.start + this.position + 5] & 0xFF;
        long g = this.array[this.start + this.position + 6] & 0xFF;
        long h = this.array[this.start + this.position + 7] & 0xFF;
        this.position += 8;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
        }
        return h << 56 | g << 48 | f << 40 | e << 32 | d << 24 | c << 16 | b << 8 | a;
    }

    @Override
    public TByteBuffer putLong(long value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (this.position + 7 >= this.limit) {
            throw new TBufferOverflowException();
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + this.position++] = (byte)(value >> 56);
            this.array[this.start + this.position++] = (byte)(value >> 48);
            this.array[this.start + this.position++] = (byte)(value >> 40);
            this.array[this.start + this.position++] = (byte)(value >> 32);
            this.array[this.start + this.position++] = (byte)(value >> 24);
            this.array[this.start + this.position++] = (byte)(value >> 16);
            this.array[this.start + this.position++] = (byte)(value >> 8);
            this.array[this.start + this.position++] = (byte)value;
        } else {
            this.array[this.start + this.position++] = (byte)value;
            this.array[this.start + this.position++] = (byte)(value >> 8);
            this.array[this.start + this.position++] = (byte)(value >> 16);
            this.array[this.start + this.position++] = (byte)(value >> 24);
            this.array[this.start + this.position++] = (byte)(value >> 32);
            this.array[this.start + this.position++] = (byte)(value >> 40);
            this.array[this.start + this.position++] = (byte)(value >> 48);
            this.array[this.start + this.position++] = (byte)(value >> 56);
        }
        return this;
    }

    @Override
    public long getLong(int index) {
        if (index < 0 || index + 7 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 7) + ")");
        }
        long a = this.array[this.start + index] & 0xFF;
        long b = this.array[this.start + index + 1] & 0xFF;
        long c = this.array[this.start + index + 2] & 0xFF;
        long d = this.array[this.start + index + 3] & 0xFF;
        long e = this.array[this.start + index + 4] & 0xFF;
        long f = this.array[this.start + index + 5] & 0xFF;
        long g = this.array[this.start + index + 6] & 0xFF;
        long h = this.array[this.start + index + 7] & 0xFF;
        this.position += 8;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
        }
        return h << 56 | g << 48 | f << 40 | e << 32 | d << 24 | c << 16 | b << 8 | a;
    }

    @Override
    public TByteBuffer putLong(int index, long value) {
        if (this.readOnly) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index + 3 >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + (this.limit - 3) + ")");
        }
        if (this.order == TByteOrder.BIG_ENDIAN) {
            this.array[this.start + index + 0] = (byte)(value >> 56);
            this.array[this.start + index + 1] = (byte)(value >> 48);
            this.array[this.start + index + 2] = (byte)(value >> 40);
            this.array[this.start + index + 3] = (byte)(value >> 32);
            this.array[this.start + index + 4] = (byte)(value >> 24);
            this.array[this.start + index + 5] = (byte)(value >> 16);
            this.array[this.start + index + 6] = (byte)(value >> 8);
            this.array[this.start + index + 7] = (byte)value;
        } else {
            this.array[this.start + index + 0] = (byte)value;
            this.array[this.start + index + 1] = (byte)(value >> 8);
            this.array[this.start + index + 2] = (byte)(value >> 16);
            this.array[this.start + index + 3] = (byte)(value >> 24);
            this.array[this.start + index + 4] = (byte)(value >> 24);
            this.array[this.start + index + 5] = (byte)(value >> 24);
            this.array[this.start + index + 6] = (byte)(value >> 24);
            this.array[this.start + index + 7] = (byte)(value >> 24);
        }
        return this;
    }

    @Override
    public TLongBuffer asLongBuffer() {
        int sz = this.remaining() / 8;
        if (this.order == TByteOrder.BIG_ENDIAN) {
            return new TLongBufferOverByteBufferBigEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
        }
        return new TLongBufferOverByteBufferLittleEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
    }

    @Override
    public TFloatBuffer asFloatBuffer() {
        int sz = this.remaining() / 4;
        if (this.order == TByteOrder.LITTLE_ENDIAN) {
            return new TFloatBufferOverByteBufferBigEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
        }
        return new TFloatBufferOverByteBufferLittleEndian(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
    }

    @Override
    public TDoubleBuffer asDoubleBuffer() {
        int sz = this.remaining() / 8;
        TDoubleBufferOverByteBuffer result = new TDoubleBufferOverByteBuffer(this.start + this.position, sz, this, 0, sz, this.isReadOnly());
        result.byteOrder = this.order;
        return result;
    }
}

