/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.teavm.classlib.impl.DeclaringClassMetadataGenerator;
import org.teavm.classlib.java.lang.ClassDependencyListener;
import org.teavm.classlib.java.lang.TClassCastException;
import org.teavm.classlib.java.lang.TClassLoader;
import org.teavm.classlib.java.lang.TClassNotFoundException;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TInstantiationException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.annotation.TAnnotation;
import org.teavm.classlib.java.lang.reflect.TAnnotatedElement;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.DelegateTo;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformClass;
import org.teavm.platform.PlatformObject;
import org.teavm.platform.metadata.ClassResource;
import org.teavm.platform.metadata.ClassScopedMetadataProvider;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeJavaObject;

public class TClass<T>
extends TObject
implements TAnnotatedElement {
    TString name;
    TString simpleName;
    private PlatformClass platformClass;
    private TAnnotation[] annotationsCache;
    private Map<TClass<?>, TAnnotation> annotationsByType;

    private TClass(PlatformClass platformClass) {
        this.platformClass = platformClass;
        platformClass.setJavaClass(Platform.getPlatformObject((Object)this));
    }

    public static TClass<?> getClass(PlatformClass cls) {
        if (cls == null) {
            return null;
        }
        TClass result = (TClass)((Object)Platform.asJavaClass((PlatformObject)cls.getJavaClass()));
        if (result == null) {
            result = new TClass(cls);
        }
        return result;
    }

    public PlatformClass getPlatformClass() {
        return this.platformClass;
    }

    public boolean isInstance(TObject obj) {
        return Platform.isInstance((PlatformObject)Platform.getPlatformObject((Object)obj), (PlatformClass)this.platformClass);
    }

    public boolean isAssignableFrom(TClass<?> obj) {
        return Platform.isAssignable((PlatformClass)obj.getPlatformClass(), (PlatformClass)this.platformClass);
    }

    @DelegateTo(value="getNameLowLevel")
    public TString getName() {
        if (this.name == null) {
            this.name = TString.wrap(Platform.getName((PlatformClass)this.platformClass));
        }
        return this.name;
    }

    private RuntimeJavaObject getNameLowLevel() {
        RuntimeClass runtimeClass = (RuntimeClass)Address.ofObject((Object)this).toStructure();
        return runtimeClass.name;
    }

    public TString getSimpleName() {
        if (this.simpleName == null) {
            if (this.isArray()) {
                this.simpleName = this.getComponentType().getSimpleName().concat(TString.wrap("[]"));
                return this.simpleName;
            }
            String name = Platform.getName((PlatformClass)this.platformClass);
            int lastDollar = name.lastIndexOf(36);
            if (lastDollar != -1) {
                if ((name = name.substring(lastDollar + 1)).charAt(0) >= '0' && name.charAt(0) <= '9') {
                    name = "";
                }
            } else {
                int lastDot = name.lastIndexOf(46);
                if (lastDot != -1) {
                    name = name.substring(lastDot + 1);
                }
            }
            this.simpleName = TString.wrap(name);
        }
        return this.simpleName;
    }

    public boolean isPrimitive() {
        return Platform.isPrimitive((PlatformClass)this.platformClass);
    }

    public boolean isArray() {
        return Platform.getArrayItem((PlatformClass)this.platformClass) != null;
    }

    public boolean isEnum() {
        return Platform.isEnum((PlatformClass)this.platformClass);
    }

    public TClass<?> getComponentType() {
        return TClass.getClass(Platform.getArrayItem((PlatformClass)this.platformClass));
    }

    public boolean desiredAssertionStatus() {
        return true;
    }

    public TClass<? super T> getSuperclass() {
        return TClass.getClass(this.platformClass.getMetadata().getSuperclass());
    }

    public T[] getEnumConstants() {
        return this.isEnum() ? (Object[])Platform.getEnumConstants((PlatformClass)this.platformClass) : null;
    }

    public T cast(TObject obj) {
        if (obj != null && !this.isAssignableFrom((TClass)((Object)obj.getClass()))) {
            throw new TClassCastException(TString.wrap(obj.getClass().getName() + " is not subtype of " + this.name));
        }
        return (T)obj;
    }

    public TClassLoader getClassLoader() {
        return TClassLoader.getSystemClassLoader();
    }

    public static TClass<?> forName(TString name) throws TClassNotFoundException {
        PlatformClass cls = Platform.lookupClass((String)name.toString());
        if (cls == null) {
            throw new TClassNotFoundException();
        }
        return TClass.getClass(cls);
    }

    public static TClass<?> forName(TString name, boolean initialize, TClassLoader loader) throws TClassNotFoundException {
        return TClass.forName(name);
    }

    @PluggableDependency(value=ClassDependencyListener.class)
    void initialize() {
        Platform.initClass((PlatformClass)this.platformClass);
    }

    public T newInstance() throws TInstantiationException, TIllegalAccessException {
        Object instance = Platform.newInstance((PlatformClass)this.platformClass);
        if (instance == null) {
            throw new TInstantiationException();
        }
        return (T)instance;
    }

    public TClass<?> getDeclaringClass() {
        ClassResource res = TClass.getDeclaringClass(this.platformClass);
        return res != null ? TClass.getClass(Platform.classFromResource((ClassResource)res)) : null;
    }

    @ClassScopedMetadataProvider(value=DeclaringClassMetadataGenerator.class)
    private static native ClassResource getDeclaringClass(PlatformClass var0);

    public <U> TClass<? extends U> asSubclass(TClass<U> clazz) {
        if (!clazz.isAssignableFrom(this)) {
            throw new TClassCastException();
        }
        return this;
    }

    @Override
    public boolean isAnnotationPresent(TClass<? extends TAnnotation> annotationClass) {
        this.ensureAnnotationsByType();
        return this.annotationsByType.containsKey(annotationClass);
    }

    public <S extends TAnnotation> S getAnnotation(TClass<S> annotationClass) {
        this.ensureAnnotationsByType();
        return (S)this.annotationsByType.get(annotationClass);
    }

    @Override
    public TAnnotation[] getAnnotations() {
        if (this.annotationsCache == null) {
            this.annotationsCache = (TAnnotation[])Platform.getAnnotations((PlatformClass)this.getPlatformClass());
        }
        return (TAnnotation[])this.annotationsCache.clone();
    }

    @Override
    public TAnnotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    private void ensureAnnotationsByType() {
        if (this.annotationsByType != null) {
            return;
        }
        this.annotationsByType = new HashMap();
        for (TAnnotation annot : this.getAnnotations()) {
            this.annotationsByType.put((TClass)((Object)annot.annotationType()), annot);
        }
    }

    public InputStream getResourceAsStream(String name) {
        if (name.startsWith("/")) {
            return this.getClassLoader().getResourceAsStream(name.substring(1));
        }
        TClass<?> cls = this;
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        String prefix = cls.getName().toString();
        int index = prefix.lastIndexOf(46);
        if (index >= 0) {
            name = prefix.substring(0, index + 1).replace('.', '/') + name;
        }
        return this.getClassLoader().getResourceAsStream(name);
    }
}

