/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;

public class TByte
extends TNumber
implements TComparable<TByte> {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = Byte.TYPE;
    public static final int SIZE = 8;
    private byte value;

    public TByte(byte value) {
        this.value = value;
    }

    public TByte(TString value) {
        this.value = TByte.parseByte(value, 10);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    public static TByte valueOf(byte value) {
        return new TByte(value);
    }

    public static String toString(byte value) {
        return "" + value;
    }

    @Override
    public String toString() {
        return TByte.toString(this.value);
    }

    public boolean equals(Object other) {
        return other instanceof TByte && ((TByte)other).value == this.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public static int compare(byte a, byte b) {
        return a - b;
    }

    @Override
    public int compareTo(TByte other) {
        return TByte.compare(this.value, other.value);
    }

    public static byte parseByte(TString s) throws TNumberFormatException {
        return TByte.parseByte(s, 10);
    }

    public static byte parseByte(TString s, int radix) throws TNumberFormatException {
        int value = TInteger.parseInt(s, radix);
        if (value < -128 || value >= 127) {
            throw new TNumberFormatException();
        }
        return (byte)value;
    }

    public static TByte valueOf(TString s, int radix) throws TNumberFormatException {
        return TByte.valueOf(TByte.parseByte(s, radix));
    }

    public static TByte valueOf(TString s) throws TNumberFormatException {
        return TByte.valueOf(TByte.parseByte(s));
    }

    public static TByte decode(TString nm) throws TNumberFormatException {
        TInteger value = TInteger.decode(nm);
        if (value.intValue() < -128 || value.intValue() >= 127) {
            throw new TNumberFormatException();
        }
        return TByte.valueOf((byte)value.intValue());
    }
}

