/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TSystem;

public class TBoolean
extends TObject
implements TSerializable,
TComparable<TBoolean> {
    public static final TBoolean TRUE = new TBoolean(true);
    public static final TBoolean FALSE = new TBoolean(false);
    public static final Class<Boolean> TYPE = Boolean.TYPE;
    private boolean value;

    public TBoolean(boolean value) {
        this.value = value;
    }

    public TBoolean(TString value) {
        this.value = TBoolean.parseBoolean(value);
    }

    @Override
    public int compareTo(TBoolean other) {
        return TBoolean.compare(this.value, other.value);
    }

    public static int compare(boolean x, boolean y) {
        if (x) {
            if (!y) {
                return 1;
            }
        } else if (y) {
            return -1;
        }
        return 0;
    }

    public static boolean parseBoolean(TString s) {
        return s != null && s.toLowerCase().equals(TString.wrap("true"));
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static TBoolean valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static TBoolean valueOf(TString value) {
        return TBoolean.valueOf(TBoolean.parseBoolean(value));
    }

    public static String toString(boolean value) {
        return value ? "true" : "false";
    }

    @Override
    public String toString() {
        return TBoolean.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof TBoolean && ((TBoolean)obj).value == this.value;
    }

    public boolean getBoolean(TString key) {
        return TBoolean.valueOf(TSystem.getProperty(key)).booleanValue();
    }
}

