/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.teavm.classlib.impl.report.JCLClass;
import org.teavm.classlib.impl.report.JCLComparisonVisitor;
import org.teavm.classlib.impl.report.JCLItem;
import org.teavm.classlib.impl.report.JCLPackage;
import org.teavm.classlib.impl.report.JCLStatus;
import org.teavm.classlib.impl.report.JCLVisibility;
import org.teavm.model.ClassReaderSource;
import org.teavm.parsing.ClasspathClassHolderSource;

public class JCLComparisonBuilder {
    private static final String JAR_PREFIX = "jar:file:";
    private static final String JAR_SUFFIX = "!/java/lang/Object.class";
    private static final String CLASS_SUFFIX = ".class";
    private static final String TEMPLATE_PLACEHOLDER = "${CONTENT}";
    private Set<String> packages = new HashSet<String>();
    private ClassLoader classLoader = JCLComparisonBuilder.class.getClassLoader();
    private JCLComparisonVisitor visitor;
    private String outputDirectory;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: package.name [package.name2 ...] [-output directory]");
            System.exit(1);
        }
        JCLComparisonBuilder builder = new JCLComparisonBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-output")) {
                builder.setOutputDirectory(args[++i]);
                continue;
            }
            builder.getPackages().add(args[i].replace('.', '/'));
        }
        builder.buildComparisonReport();
    }

    public void buildComparisonReport() throws IOException {
        List<JCLPackage> packages = this.buildModel();
        this.processModel(packages);
        new File(this.outputDirectory).mkdirs();
        this.copyResource("html/class_obj.png");
        this.copyResource("html/field_protected_obj.png");
        this.copyResource("html/field_public_obj.png");
        this.copyResource("html/jcl.css");
        this.copyResource("html/methpro_obj.png");
        this.copyResource("html/methpub_obj.png");
        this.copyResource("html/package_obj.png");
        this.copyResource("html/int_obj.png");
        this.copyResource("html/enum_obj.png");
        this.copyResource("html/annotation_obj.png");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDirectory, "jcl.html")), "UTF-8");
        Object object = null;
        try {
            this.generateHtml(out, packages);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (object != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)out).close();
                }
            }
        }
        File packagesDirectory = new File(this.outputDirectory, "packages");
        packagesDirectory.mkdirs();
        for (JCLPackage pkg : packages) {
            File file = new File(packagesDirectory, pkg.name + ".html");
            OutputStreamWriter out2 = new OutputStreamWriter(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                this.generatePackageHtml(out2, pkg);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out2 == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)out2).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Writer)out2).close();
            }
        }
        File classesDirectory = new File(this.outputDirectory, "classes");
        classesDirectory.mkdirs();
        for (JCLPackage pkg : packages) {
            for (JCLClass cls : pkg.classes) {
                File file = new File(classesDirectory, pkg.name + "." + cls.name + ".html");
                OutputStreamWriter out3 = new OutputStreamWriter(new FileOutputStream(file));
                Throwable throwable = null;
                try {
                    this.generateClassHtml(out3, pkg, cls);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (out3 == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)out3).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ((Writer)out3).close();
                }
            }
        }
    }

    private List<JCLPackage> buildModel() throws IOException {
        HashMap<String, JCLPackage> packageMap = new HashMap<String, JCLPackage>();
        URL url = this.classLoader.getResource("java/lang/Object.class");
        String path = url.toString();
        if (!path.startsWith(JAR_PREFIX) || !path.endsWith(JAR_SUFFIX)) {
            throw new RuntimeException("Can't find JCL classes");
        }
        ClasspathClassHolderSource classSource = new ClasspathClassHolderSource(this.classLoader);
        path = path.substring(JAR_PREFIX.length(), path.length() - JAR_SUFFIX.length());
        File outDir = new File(this.outputDirectory).getParentFile();
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        path = URLDecoder.decode(path, "UTF-8");
        try (JarInputStream jar = new JarInputStream(new FileInputStream(path));){
            JarEntry entry;
            this.visitor = new JCLComparisonVisitor((ClassReaderSource)classSource, packageMap);
            while ((entry = jar.getNextJarEntry()) != null) {
                if (this.validateName(entry.getName())) {
                    this.compareClass(jar);
                }
                jar.closeEntry();
            }
        }
        return new ArrayList<JCLPackage>(packageMap.values());
    }

    private void processModel(List<JCLPackage> packages) {
        Collections.sort(packages, (o1, o2) -> o1.name.compareTo(o2.name));
        for (JCLPackage pkg : packages) {
            Collections.sort(pkg.classes, (o1, o2) -> o1.name.compareTo(o2.name));
        }
    }

    private boolean validateName(String name) {
        if (!name.endsWith(CLASS_SUFFIX)) {
            return false;
        }
        int slashIndex = name.lastIndexOf(47);
        return slashIndex >= 0 && this.packages.contains(name.substring(0, slashIndex));
    }

    private void compareClass(InputStream input) throws IOException {
        byte[] buffer = IOUtils.toByteArray((InputStream)input);
        ClassReader reader = new ClassReader(buffer);
        reader.accept((ClassVisitor)this.visitor, 0);
    }

    private void copyResource(String name) throws IOException {
        String simpleName = name.substring(name.lastIndexOf(47) + 1);
        try (InputStream input = this.classLoader.getResourceAsStream(name);
             FileOutputStream output = new FileOutputStream(new File(this.outputDirectory, simpleName));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private void generateHtml(Writer out, List<JCLPackage> packages) throws IOException {
        String template;
        try (InputStreamReader reader = new InputStreamReader(this.classLoader.getResourceAsStream("html/jcl.html"), "UTF-8");){
            template = IOUtils.toString((Reader)reader);
        }
        int placeholderIndex = template.indexOf(TEMPLATE_PLACEHOLDER);
        String header = template.substring(0, placeholderIndex);
        String footer = template.substring(placeholderIndex + TEMPLATE_PLACEHOLDER.length());
        out.write(header);
        for (JCLPackage pkg : packages) {
            int totalClasses = pkg.classes.size();
            int fullClasses = 0;
            int partialClasses = 0;
            for (JCLClass cls : pkg.classes) {
                switch (cls.status) {
                    case FOUND: {
                        ++fullClasses;
                        ++partialClasses;
                        break;
                    }
                    case PARTIAL: {
                        ++partialClasses;
                        break;
                    }
                }
            }
            this.writeRow(out, "package", "packages/" + pkg.name + ".html", pkg.status, this.escape(pkg.name), totalClasses > 0 ? Integer.valueOf(fullClasses * 100 / totalClasses) : null, totalClasses > 0 ? Integer.valueOf(partialClasses * 100 / totalClasses) : null);
        }
        out.write(footer);
    }

    private void generatePackageHtml(Writer out, JCLPackage pkg) throws IOException {
        String template;
        try (InputStreamReader reader = new InputStreamReader(this.classLoader.getResourceAsStream("html/jcl-class.html"), "UTF-8");){
            template = IOUtils.toString((Reader)reader);
        }
        template = template.replace("${CLASSNAME}", pkg.name);
        int placeholderIndex = template.indexOf(TEMPLATE_PLACEHOLDER);
        String header = template.substring(0, placeholderIndex);
        String footer = template.substring(placeholderIndex + TEMPLATE_PLACEHOLDER.length());
        out.write(header);
        int totalClasses = pkg.classes.size();
        int fullClasses = 0;
        int partialClasses = 0;
        for (JCLClass cls : pkg.classes) {
            switch (cls.status) {
                case FOUND: {
                    ++fullClasses;
                    ++partialClasses;
                    break;
                }
                case PARTIAL: {
                    ++partialClasses;
                    break;
                }
            }
        }
        this.writeRow(out, "package", null, pkg.status, this.escape(pkg.name), totalClasses > 0 ? Integer.valueOf(fullClasses * 100 / totalClasses) : null, totalClasses > 0 ? Integer.valueOf(partialClasses * 100 / totalClasses) : null);
        for (JCLClass cls : pkg.classes) {
            this.writeClassRow(out, pkg, cls);
        }
        out.write(footer);
    }

    private void generateClassHtml(Writer out, JCLPackage pkg, JCLClass cls) throws IOException {
        String template;
        try (InputStreamReader reader = new InputStreamReader(this.classLoader.getResourceAsStream("html/jcl-class.html"), "UTF-8");){
            template = IOUtils.toString((Reader)reader);
        }
        template = template.replace("${CLASSNAME}", pkg.name + "." + cls.name);
        int placeholderIndex = template.indexOf(TEMPLATE_PLACEHOLDER);
        String header = template.substring(0, placeholderIndex);
        String footer = template.substring(placeholderIndex + TEMPLATE_PLACEHOLDER.length());
        out.write(header);
        this.writeRow(out, "package", null, pkg.status, this.escape(pkg.name), null, null);
        this.writeClassRow(out, pkg, cls);
        for (JCLItem item : cls.items) {
            String type;
            String name = item.name;
            switch (item.type) {
                case FIELD: {
                    type = "field";
                    int index = name.indexOf(58);
                    String desc = name.substring(index + 1);
                    name = name.substring(0, index) + " : " + this.printType(Type.getType((String)desc));
                    break;
                }
                case METHOD: {
                    type = "method";
                    int index = name.indexOf(40);
                    String desc = name.substring(index);
                    Type[] args = Type.getArgumentTypes((String)desc);
                    Type result = Type.getReturnType((String)desc);
                    StringBuilder sb = new StringBuilder();
                    name = name.substring(0, index);
                    if (name.equals("<init>")) {
                        name = cls.name;
                    }
                    sb.append(name).append("(");
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.printType(args[i]));
                    }
                    sb.append(") : ").append(this.printType(result));
                    name = sb.toString();
                    break;
                }
                default: {
                    type = "";
                }
            }
            if (item.visibility == JCLVisibility.PROTECTED) {
                type = "protected " + type;
            }
            this.writeRow(out, type, null, item.status, name, null, null);
        }
        out.write(footer);
    }

    private String printType(Type type) {
        switch (type.getSort()) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 2: {
                return "char";
            }
            case 9: {
                StringBuilder sb = new StringBuilder(this.printType(type.getElementType()));
                for (int i = 0; i < type.getDimensions(); ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            case 10: {
                String simpleName = type.getClassName();
                simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
                return "<a href=\"" + type.getClassName() + ".html\">" + simpleName + "</a>";
            }
        }
        return "";
    }

    private void writeClassRow(Writer out, JCLPackage pkg, JCLClass cls) throws IOException {
        String type;
        int implemented = 0;
        for (JCLItem item : cls.items) {
            if (item.status == JCLStatus.MISSING) continue;
            ++implemented;
        }
        switch (cls.type) {
            case INTERFACE: {
                type = "interface";
                break;
            }
            case ANNOTATION: {
                type = "annotation";
                break;
            }
            case ENUM: {
                type = "enum";
                break;
            }
            default: {
                type = "class";
            }
        }
        this.writeRow(out, type + " type", "../classes/" + pkg.name + "." + cls.name + ".html", cls.status, this.escape(cls.name), !cls.items.isEmpty() ? Integer.valueOf(implemented * 100 / cls.items.size()) : null, null);
    }

    private void writeRow(Writer out, String type, String link, JCLStatus status, String name, Integer percent, Integer partialPercent) throws IOException {
        out.write("<tr class=\"");
        switch (status) {
            case FOUND: {
                out.write("full");
                break;
            }
            case MISSING: {
                out.write("missing");
                break;
            }
            case PARTIAL: {
                out.write("partial");
            }
        }
        out.write("\">\n");
        out.write("<td><div class=\"");
        out.write(type);
        out.write("\">");
        if (link != null) {
            out.write("<a href=\"" + link + "\">");
        }
        out.write(name);
        if (link != null) {
            out.write("</a>");
        }
        out.write("</div></td>\n");
        out.write("<td class=\"percent\">" + (partialPercent != null ? partialPercent.toString() : "") + "</td>");
        out.write("<td class=\"percent\">" + (percent != null ? percent.toString() : "") + "</td>");
        out.write("</tr>\n");
    }

    private String escape(String string) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

