/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.impl.unicode.UnicodeHelper;
import org.teavm.classlib.java.lang.CharacterMetadataGenerator;
import org.teavm.classlib.java.lang.TCharSequence;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.platform.Platform;
import org.teavm.platform.metadata.MetadataProvider;
import org.teavm.platform.metadata.StringResource;

public class TCharacter
extends TObject
implements TComparable<TCharacter> {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final TClass<TCharacter> TYPE = TClass.charClass();
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 17;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int SIZE = 16;
    static final int ERROR = -1;
    private static int[] digitMapping;
    private static UnicodeHelper.Range[] classMapping;
    private char value;
    private static TCharacter[] characterCache;
    private static final int SURROGATE_NEUTRAL_BIT_MASK = 63488;
    private static final int SURROGATE_BITS = 55296;
    private static final int SURROGATE_BIT_MASK = 64512;
    private static final int SURROGATE_BIT_INV_MASK = 1023;
    private static final int HIGH_SURROGATE_BITS = 55296;
    private static final int LOW_SURROGATE_BITS = 56320;
    private static final int MEANINGFUL_SURROGATE_BITS = 10;

    public TCharacter(char value) {
        this.value = value;
    }

    public char charValue() {
        return this.value;
    }

    public static TCharacter valueOf(char value) {
        if (value < characterCache.length) {
            TCharacter result = characterCache[value];
            if (result == null) {
                TCharacter.characterCache[value] = result = new TCharacter(value);
            }
            return result;
        }
        return new TCharacter(value);
    }

    @Override
    public String toString() {
        return TCharacter.toString(this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TCharacter && ((TCharacter)other).value == this.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public static String toString(char c) {
        return new String(new char[]{c});
    }

    public static boolean isValidCodePoint(int codePoint) {
        return codePoint >= 0 && codePoint <= 0x10FFFF;
    }

    public static boolean isBmpCodePoint(int codePoint) {
        return codePoint > 0 && codePoint <= 65535;
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public static boolean isHighSurrogate(char ch) {
        return (ch & 0xFC00) == 55296;
    }

    public static boolean isLowSurrogate(char ch) {
        return (ch & 0xFC00) == 56320;
    }

    public static boolean isSurrogate(char ch) {
        return TCharacter.isHighSurrogate(ch) || TCharacter.isLowSurrogate(ch);
    }

    public static boolean isSurrogatePair(char high, char low) {
        return TCharacter.isHighSurrogate(high) && TCharacter.isLowSurrogate(low);
    }

    public static int charCount(int codePoint) {
        return TCharacter.isSupplementaryCodePoint(codePoint) ? 2 : 1;
    }

    public static int toCodePoint(char high, char low) {
        return ((high & 0x3FF) << 10 | low & 0x3FF) + 65536;
    }

    public static int codePointAt(TCharSequence seq, int index) {
        if (index >= seq.length() - 1 || !TCharacter.isHighSurrogate(seq.charAt(index)) || !TCharacter.isLowSurrogate(seq.charAt(index + 1))) {
            return seq.charAt(index);
        }
        return TCharacter.toCodePoint(seq.charAt(index), seq.charAt(index + 1));
    }

    public static int codePointAt(char[] a, int index) {
        return TCharacter.codePointAt(a, index, a.length);
    }

    public static int codePointAt(char[] a, int index, int limit) {
        if (index >= limit - 1 || !TCharacter.isHighSurrogate(a[index]) || !TCharacter.isLowSurrogate(a[index + 1])) {
            return a[index];
        }
        return TCharacter.toCodePoint(a[index], a[index + 1]);
    }

    public static int codePointBefore(TCharSequence seq, int index) {
        if (index == 1 || !TCharacter.isLowSurrogate(seq.charAt(index - 1)) || !TCharacter.isHighSurrogate(seq.charAt(index - 2))) {
            return seq.charAt(index - 1);
        }
        return TCharacter.toCodePoint(seq.charAt(index - 2), seq.charAt(index - 1));
    }

    public static int codePointBefore(char[] a, int index) {
        return TCharacter.codePointBefore(a, index, 0);
    }

    public static int codePointBefore(char[] a, int index, int start) {
        if (index <= start + 1 || !TCharacter.isLowSurrogate(a[index - 1]) || !TCharacter.isHighSurrogate(a[index - 2])) {
            return a[index];
        }
        return TCharacter.toCodePoint(a[index - 2], a[index - 1]);
    }

    public static char highSurrogate(int codePoint) {
        return (char)(0xD800 | (codePoint -= 65536) >> 10 & 0x3FF);
    }

    public static char lowSurrogate(int codePoint) {
        return (char)(0xDC00 | codePoint & 0x3FF);
    }

    public static char toLowerCase(char ch) {
        return (char)TCharacter.toLowerCase((int)ch);
    }

    public static int toLowerCase(int ch) {
        return Platform.stringFromCharCode((int)ch).toLowerCase().charCodeAt(0);
    }

    public static char toUpperCase(char ch) {
        return (char)TCharacter.toUpperCase((int)ch);
    }

    public static int toUpperCase(int codePoint) {
        return Platform.stringFromCharCode((int)codePoint).toUpperCase().charCodeAt(0);
    }

    public static int digit(char ch, int radix) {
        return TCharacter.digit((int)ch, radix);
    }

    public static int digit(int codePoint, int radix) {
        if (radix < 2 || radix > 36) {
            return -1;
        }
        int d = TCharacter.getNumericValue(codePoint);
        return d < radix ? d : -1;
    }

    public static int getNumericValue(char ch) {
        return TCharacter.getNumericValue((int)ch);
    }

    public static int getNumericValue(int codePoint) {
        int[] digitMapping = TCharacter.getDigitMapping();
        int l = 0;
        int u = digitMapping.length / 2 - 1;
        while (u >= l) {
            int idx = (l + u) / 2;
            int val = digitMapping[idx * 2];
            if (codePoint > val) {
                l = idx + 1;
                continue;
            }
            if (codePoint < val) {
                u = idx - 1;
                continue;
            }
            return digitMapping[idx * 2 + 1];
        }
        return -1;
    }

    public static char forDigit(int digit, int radix) {
        if (radix < 2 || radix > 36 || digit >= radix) {
            return '\u0000';
        }
        return digit < 10 ? (char)(48 + digit) : (char)(97 + digit - 10);
    }

    public static boolean isDigit(char ch) {
        return TCharacter.isDigit((int)ch);
    }

    public static boolean isDigit(int codePoint) {
        return TCharacter.getType(codePoint) == 9;
    }

    private static int[] getDigitMapping() {
        if (digitMapping == null) {
            digitMapping = UnicodeHelper.decodeIntByte(TCharacter.obtainDigitMapping().getValue());
        }
        return digitMapping;
    }

    @MetadataProvider(value=CharacterMetadataGenerator.class)
    private static native StringResource obtainDigitMapping();

    private static UnicodeHelper.Range[] getClasses() {
        if (classMapping == null) {
            classMapping = UnicodeHelper.extractRle(TCharacter.obtainClasses().getValue());
        }
        return classMapping;
    }

    @MetadataProvider(value=CharacterMetadataGenerator.class)
    private static native StringResource obtainClasses();

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        if (codePoint >= 65536) {
            dst[dstIndex] = TCharacter.highSurrogate(codePoint);
            dst[dstIndex + 1] = TCharacter.lowSurrogate(codePoint);
            return 2;
        }
        dst[dstIndex] = (char)codePoint;
        return 1;
    }

    public static char[] toChars(int codePoint) {
        if (codePoint >= 65536) {
            return new char[]{TCharacter.highSurrogate(codePoint), TCharacter.lowSurrogate(codePoint)};
        }
        return new char[]{(char)codePoint};
    }

    public static int codePointCount(TCharSequence seq, int beginIndex, int endIndex) {
        int count = endIndex - beginIndex;
        --endIndex;
        for (int i = beginIndex; i < endIndex; ++i) {
            if (!TCharacter.isHighSurrogate(seq.charAt(i)) || !TCharacter.isLowSurrogate(seq.charAt(i + 1))) continue;
            --count;
            ++i;
        }
        return count;
    }

    public static int codePointCount(char[] a, int offset, int count) {
        int r = count--;
        for (int i = 0; i < count; ++i) {
            if (!TCharacter.isHighSurrogate(a[offset]) || !TCharacter.isLowSurrogate(a[offset + i + 1])) continue;
            --r;
            ++i;
        }
        return r;
    }

    public static int offsetByCodePoints(TCharSequence seq, int index, int codePointOffset) {
        for (int i = 0; i < codePointOffset; ++i) {
            if (index < seq.length() - 1 && TCharacter.isHighSurrogate(seq.charAt(index)) && TCharacter.isLowSurrogate(seq.charAt(index + 1))) {
                index += 2;
                continue;
            }
            ++index;
        }
        return index;
    }

    public static int offsetByCodePoints(char[] a, int start, int count, int index, int codePointOffset) {
        for (int i = 0; i < codePointOffset; ++i) {
            if (index < count - 1 && TCharacter.isHighSurrogate(a[index + start]) && TCharacter.isLowSurrogate(a[index + start + 1])) {
                index += 2;
                continue;
            }
            ++index;
        }
        return index;
    }

    public static boolean isISOControl(char ch) {
        return TCharacter.isISOControl((int)ch);
    }

    public static boolean isISOControl(int codePoint) {
        return codePoint >= 0 && codePoint <= 31 || codePoint >= 127 && codePoint <= 159;
    }

    public static int getType(char c) {
        return TCharacter.getType((int)c);
    }

    public static int getType(int codePoint) {
        if (TCharacter.isBmpCodePoint(codePoint) && TCharacter.isSurrogate((char)codePoint)) {
            return 19;
        }
        UnicodeHelper.Range[] classes = TCharacter.getClasses();
        int l = 0;
        int u = classes.length - 1;
        while (l <= u) {
            int i = (l + u) / 2;
            UnicodeHelper.Range range = classes[i];
            if (codePoint >= range.end) {
                l = i + 1;
                continue;
            }
            if (codePoint < range.start) {
                u = i - 1;
                continue;
            }
            return range.data[codePoint - range.start];
        }
        return 0;
    }

    public static boolean isLowerCase(char ch) {
        return TCharacter.isLowerCase((int)ch);
    }

    public static boolean isLowerCase(int codePoint) {
        return TCharacter.getType(codePoint) == 2;
    }

    public static boolean isUpperCase(char ch) {
        return TCharacter.isUpperCase((int)ch);
    }

    public static boolean isUpperCase(int codePoint) {
        return TCharacter.getType(codePoint) == 1;
    }

    public static boolean isTitleCase(char ch) {
        return TCharacter.isTitleCase((int)ch);
    }

    public static boolean isTitleCase(int codePoint) {
        return TCharacter.getType(codePoint) == 3;
    }

    public static boolean isDefined(char ch) {
        return TCharacter.isDefined((int)ch);
    }

    public static boolean isDefined(int codePoint) {
        return TCharacter.getType(codePoint) != 0;
    }

    public static boolean isLetter(char ch) {
        return TCharacter.isLetter((int)ch);
    }

    public static boolean isLetter(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetterOrDigit(char ch) {
        return TCharacter.isLetterOrDigit((int)ch);
    }

    public static boolean isLetterOrDigit(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isJavaLetter(char ch) {
        return TCharacter.isJavaIdentifierStart(ch);
    }

    public static boolean isJavaIdentifierStart(char ch) {
        return TCharacter.isJavaIdentifierStart((int)ch);
    }

    public static boolean isJavaIdentifierStart(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return TCharacter.isIdentifierIgnorable(codePoint);
    }

    @Deprecated
    public static boolean isJavaLetterOrDigit(char ch) {
        return TCharacter.isJavaIdentifierPart(ch);
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return TCharacter.isJavaIdentifierPart((int)ch);
    }

    public static boolean isJavaIdentifierPart(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return TCharacter.isIdentifierIgnorable(codePoint);
    }

    public static boolean isAlphabetic(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnicodeIdentifierStart(char ch) {
        return TCharacter.isUnicodeIdentifierStart((int)ch);
    }

    public static boolean isUnicodeIdentifierStart(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
        }
        return TCharacter.isIdentifierIgnorable(codePoint);
    }

    public static boolean isUnicodeIdentifierPart(char ch) {
        return TCharacter.isUnicodeIdentifierPart((int)ch);
    }

    public static boolean isUnicodeIdentifierPart(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                return true;
            }
        }
        return TCharacter.isIdentifierIgnorable(codePoint);
    }

    public static boolean isIdentifierIgnorable(char ch) {
        return TCharacter.isIdentifierIgnorable((int)ch);
    }

    public static boolean isIdentifierIgnorable(int codePoint) {
        if (codePoint >= 0 && codePoint <= 8 || codePoint >= 14 && codePoint <= 27 || codePoint >= 127 && codePoint <= 159) {
            return true;
        }
        return TCharacter.getType(codePoint) == 16;
    }

    @Deprecated
    public static boolean isSpace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpaceChar(char ch) {
        return TCharacter.isSpaceChar((int)ch);
    }

    public static boolean isSpaceChar(int codePoint) {
        switch (TCharacter.getType(codePoint)) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char ch) {
        return TCharacter.isWhitespace((int)ch);
    }

    public static boolean isWhitespace(int codePoint) {
        switch (codePoint) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return true;
            }
            case 160: 
            case 8199: 
            case 8239: {
                return false;
            }
        }
        return TCharacter.isSpaceChar(codePoint);
    }

    @Override
    public int compareTo(TCharacter anotherCharacter) {
        return TCharacter.compare(this.value, anotherCharacter.value);
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static char reverseBytes(char ch) {
        return (char)(ch >> 8 | ch << 8);
    }

    static {
        characterCache = new TCharacter[128];
    }
}

