/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBufferOverArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;

public abstract class TFloatBuffer
extends TBuffer
implements Comparable<TFloatBuffer> {
    TFloatBuffer(int capacity, int position, int limit) {
        super(capacity);
        this.position = position;
        this.limit = limit;
    }

    public static TFloatBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        return new TFloatBufferOverArray(capacity);
    }

    public static TFloatBuffer wrap(float[] array, int offset, int length) {
        return new TFloatBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TFloatBuffer wrap(float[] array) {
        return TFloatBuffer.wrap(array, 0, array.length);
    }

    public abstract TFloatBuffer slice();

    public abstract TFloatBuffer duplicate();

    public abstract TFloatBuffer asReadOnlyBuffer();

    public abstract float get();

    public abstract TFloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract TFloatBuffer put(int var1, float var2);

    abstract float getElement(int var1);

    abstract void putElement(int var1, float var2);

    public TFloatBuffer get(float[] dst, int offset, int length) {
        if (offset < 0 || offset >= dst.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + dst.length + ")");
        }
        if (offset + length > dst.length) {
            throw new IndexOutOfBoundsException("The last float in dst " + (offset + length) + " is outside " + "of array of size " + dst.length);
        }
        if (this.remaining() < length) {
            throw new TBufferUnderflowException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            dst[offset++] = this.getElement(pos++);
        }
        this.position += length;
        return this;
    }

    public TFloatBuffer get(float[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TFloatBuffer put(TFloatBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < src.remaining()) {
            throw new TBufferOverflowException();
        }
        int length = src.remaining();
        int pos = this.position;
        int offset = src.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src.getElement(offset++));
        }
        this.position += length;
        return this;
    }

    public TFloatBuffer put(float[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (offset < 0 || offset >= src.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + src.length + ")");
        }
        if (offset + length > src.length) {
            throw new IndexOutOfBoundsException("The last float in src " + (offset + length) + " is outside " + "of array of size " + src.length);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src[offset++]);
        }
        this.position += length;
        return this;
    }

    public final TFloatBuffer put(float[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final float[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract float[] getArray();

    abstract int getArrayOffset();

    public abstract TFloatBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[FloatBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity + ", mark " + (this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + Float.floatToIntBits(this.getElement(pos++));
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TFloatBuffer)) {
            return false;
        }
        TFloatBuffer other = (TFloatBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TFloatBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Float.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();
}

