/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.List;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.platform.PlatformAnnotationProvider;

public class AnnotationDependencyListener
extends AbstractDependencyListener {
    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        ClassReader cls = agent.getClassSource().get(className);
        if (cls == null) {
            return;
        }
        for (AnnotationReader annotation : cls.getAnnotations().all()) {
            agent.linkClass(annotation.getType(), location);
        }
        this.createAnnotationClass(agent, className);
    }

    private String getAnnotationImplementor(DependencyAgent agent, String annotationType) {
        String implementorName = annotationType + "$$_impl";
        if (agent.getClassSource().get(implementorName) == null) {
            ClassHolder implementor = this.createImplementor(agent.getClassSource(), annotationType, implementorName);
            agent.submitClass(implementor);
        }
        return implementorName;
    }

    private ClassHolder createImplementor(ClassReaderSource classSource, String annotationType, String implementorName) {
        ClassHolder implementor = new ClassHolder(implementorName);
        implementor.setParent("java.lang.Object");
        implementor.getInterfaces().add(annotationType);
        implementor.getModifiers().add(ElementModifier.FINAL);
        implementor.setLevel(AccessLevel.PUBLIC);
        ClassReader annotation = classSource.get(annotationType);
        if (annotation == null) {
            return implementor;
        }
        ArrayList<Object> ctorSignature = new ArrayList<Object>();
        for (MethodReader methodDecl : annotation.getMethods()) {
            if (methodDecl.hasModifier(ElementModifier.STATIC)) continue;
            FieldHolder field = new FieldHolder("$" + methodDecl.getName());
            field.setType(methodDecl.getResultType());
            field.setLevel(AccessLevel.PRIVATE);
            implementor.addField(field);
            MethodHolder accessor = new MethodHolder(methodDecl.getDescriptor());
            ProgramEmitter pe = ProgramEmitter.create((MethodHolder)accessor);
            ValueEmitter thisVal = pe.newVar();
            ValueEmitter result = thisVal.getField(field.getReference(), field.getType());
            if (field.getType() instanceof ValueType.Array) {
                result = result.cloneArray();
            }
            result.returnValue();
            implementor.addMethod(accessor);
            ctorSignature.add(field.getType());
        }
        ctorSignature.add(ValueType.VOID);
        MethodHolder ctor = new MethodHolder("<init>", ctorSignature.toArray(new ValueType[ctorSignature.size()]));
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)ctor);
        ValueEmitter thisVal = pe.newVar();
        thisVal.invokeSpecial(new MethodReference(Object.class, "<init>", new Class[]{Void.TYPE}), new ValueEmitter[0]);
        for (MethodReader methodDecl : annotation.getMethods()) {
            if (methodDecl.hasModifier(ElementModifier.STATIC)) continue;
            ValueEmitter param = pe.newVar();
            FieldReference field = new FieldReference(implementorName, "$" + methodDecl.getName());
            thisVal.setField(field, methodDecl.getResultType(), param);
        }
        pe.exit();
        implementor.addMethod(ctor);
        MethodHolder annotTypeMethod = new MethodHolder("annotationType", new ValueType[]{ValueType.parse(Class.class)});
        pe = ProgramEmitter.create((MethodHolder)annotTypeMethod);
        pe.newVar();
        pe.constant(ValueType.object((String)annotationType)).returnValue();
        implementor.addMethod(annotTypeMethod);
        return implementor;
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        ClassReader cls;
        ValueType type = method.getMethod().getResultType();
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            ClassReader cls2 = agent.getClassSource().get(className);
            if (cls2 != null && cls2.hasModifier(ElementModifier.ANNOTATION)) {
                agent.linkClass(className, location);
            }
        }
        if (method.getMethod().hasModifier(ElementModifier.STATIC) && method.getMethod().getName().equals("$$__readAnnotations__$$") && (cls = agent.getClassSource().get(method.getReference().getClassName())) != null) {
            for (AnnotationReader annotation : cls.getAnnotations().all()) {
                agent.linkClass(annotation.getType(), location);
            }
        }
    }

    private void createAnnotationClass(DependencyAgent agent, String className) {
        String readerClassName = className + "$$__annotations__$$";
        if (agent.getClassSource().get(readerClassName) != null) {
            return;
        }
        ClassHolder cls = new ClassHolder(className + "$$__annotations__$$");
        cls.setLevel(AccessLevel.PUBLIC);
        cls.setOwnerName("java.lang.Object");
        cls.getInterfaces().add(PlatformAnnotationProvider.class.getName());
        MethodHolder ctor = new MethodHolder("<init>", new ValueType[]{ValueType.VOID});
        ctor.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)ctor);
        ValueEmitter thisVar = pe.newVar();
        thisVar.invokeSpecial(new MethodReference(Object.class, "<init>", new Class[]{Void.TYPE}), new ValueEmitter[0]);
        pe.exit();
        ClassReader annotatedClass = agent.getClassSource().get(className);
        cls.addMethod(ctor);
        cls.addMethod(this.addReader(agent, annotatedClass));
        agent.submitClass(cls);
    }

    private MethodHolder addReader(DependencyAgent agent, ClassReader cls) {
        MethodHolder readerMethod = new MethodHolder("getAnnotations", new ValueType[]{ValueType.parse(Annotation[].class)});
        readerMethod.setLevel(AccessLevel.PUBLIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)readerMethod);
        ArrayList<AnnotationReader> annotations = new ArrayList<AnnotationReader>();
        for (AnnotationReader annot : cls.getAnnotations().all()) {
            String retentionPolicy;
            AnnotationReader retention;
            ClassReader annotType = agent.getClassSource().get(annot.getType());
            if (annotType == null || (retention = annotType.getAnnotations().get(Retention.class.getName())) == null || !(retentionPolicy = retention.getValue("value").getEnumValue().getFieldName()).equals("RUNTIME")) continue;
            annotations.add(annot);
        }
        ValueEmitter array = pe.constructArray(Annotation.class, annotations.size());
        for (int i = 0; i < annotations.size(); ++i) {
            array.unwrapArray(ArrayElementType.OBJECT).setElement(i, this.generateAnnotationInstance(agent, pe, (AnnotationReader)annotations.get(i)));
        }
        array.returnValue();
        return readerMethod;
    }

    private ValueEmitter generateAnnotationInstance(DependencyAgent agent, ProgramEmitter pe, AnnotationReader annotation) {
        ClassReader annotationClass = agent.getClassSource().get(annotation.getType());
        if (annotationClass == null) {
            return pe.constantNull();
        }
        String className = this.getAnnotationImplementor(agent, annotation.getType());
        ArrayList<Object> ctorSignature = new ArrayList<Object>();
        ArrayList<ValueEmitter> params = new ArrayList<ValueEmitter>();
        for (MethodReader methodDecl : annotationClass.getMethods()) {
            ctorSignature.add(methodDecl.getResultType());
            AnnotationValue value = annotation.getValue(methodDecl.getName());
            if (value == null) {
                value = methodDecl.getAnnotationDefault();
            }
            params.add(this.generateAnnotationValue(agent, pe, methodDecl.getResultType(), value));
        }
        ctorSignature.add(ValueType.VOID);
        MethodReference ctor = new MethodReference(className, "<init>", ctorSignature.toArray(new ValueType[ctorSignature.size()]));
        return pe.construct(ctor, params.toArray(new ValueEmitter[params.size()]));
    }

    private ValueEmitter generateAnnotationValue(DependencyAgent agent, ProgramEmitter pe, ValueType type, AnnotationValue value) {
        switch (value.getType()) {
            case 0: {
                return pe.constant(value.getBoolean() ? 1 : 0);
            }
            case 1: {
                return pe.constant((int)value.getByte());
            }
            case 2: {
                return pe.constant((int)value.getShort());
            }
            case 3: {
                return pe.constant(value.getInt());
            }
            case 4: {
                return pe.constant(value.getLong());
            }
            case 5: {
                return pe.constant(value.getFloat());
            }
            case 6: {
                return pe.constant(value.getDouble());
            }
            case 7: {
                return pe.constant(value.getString());
            }
            case 9: {
                List list = value.getList();
                ValueType itemType = ((ValueType.Array)type).getItemType();
                ValueEmitter array = pe.constructArray(itemType, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    array.unwrapArray(ArrayElementType.OBJECT).setElement(i, this.generateAnnotationValue(agent, pe, itemType, (AnnotationValue)list.get(i)));
                }
                return array;
            }
            case 10: {
                pe.initClass(value.getEnumValue().getClassName());
                return pe.getField(value.getEnumValue(), type);
            }
            case 8: {
                return pe.constant(value.getJavaClass());
            }
            case 11: {
                return this.generateAnnotationInstance(agent, pe, value.getAnnotation());
            }
        }
        throw new IllegalArgumentException("Unknown annotation value type: " + value.getType());
    }
}

