/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.logging;

import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.lang.TThrowable;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.logging.LoggerNativeGenerator;
import org.teavm.classlib.java.util.logging.TLevel;
import org.teavm.classlib.java.util.logging.TLogRecord;
import org.teavm.javascript.spi.GeneratedBy;

public class TLogger {
    public static final TString GLOBAL_LOGGER_NAME = TString.wrap("global");
    private static TMap<TString, TLogger> loggerCache = new THashMap<TString, TLogger>();
    private TString name;
    private TLogger parent;

    TLogger(TString name) {
        this.name = name;
    }

    public static TLogger getLogger(TString name) {
        TLogger logger = loggerCache.get(name);
        if (logger == null) {
            logger = new TLogger(name);
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex >= 0) {
                TString parentName = name.substring(0, dotIndex);
                logger.parent = TLogger.getLogger(parentName);
            } else if (!name.isEmpty()) {
                logger.parent = TLogger.getLogger(TString.wrap(""));
            }
            loggerCache.put(name, logger);
        }
        return logger;
    }

    public static TLogger getAnonymousLogger() {
        return new TLogger(null);
    }

    public void log(TLogRecord record) {
        TString message = this.format(record.getMessage(), record.getParameters());
        if (record.getLevel().intValue() >= TLevel.SEVERE.intValue()) {
            this.error(message);
        } else if (record.getLevel().intValue() >= TLevel.WARNING.intValue()) {
            this.warn(message);
        } else {
            this.info(message);
        }
    }

    private TString format(TString message, Object[] params) {
        int paramStart;
        int next;
        if (params == null) {
            return message;
        }
        TStringBuilder sb = new TStringBuilder();
        int index = 0;
        while (index < message.length() && (next = message.indexOf(123, index)) >= 0 && (next = TLogger.digits(paramStart = next + 1, message)) >= 0) {
            if (message.charAt(next) != '}') {
                sb.append(message.substring(index, next));
                index = next;
                continue;
            }
            int paramIndex = TInteger.parseInt(message.substring(index, next - 1));
            if (paramIndex >= params.length) {
                sb.append(message.substring(index, next));
                index = next;
                continue;
            }
            sb.append(TObject.wrap(params[paramIndex]));
            index = next + 1;
        }
        return TString.wrap(sb.toString());
    }

    private static int digits(int from, TString message) {
        while (from < message.length()) {
            char c;
            if ((c = message.charAt(from++)) > '0' && c < '9') continue;
            return from;
        }
        return -1;
    }

    public void log(TLevel level, TString msg, Object[] params) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setParameters(params);
        this.log(record);
    }

    public void log(TLevel level, TString msg) {
        this.log(new TLogRecord(level, msg));
    }

    public void log(TLevel level, TString msg, TObject param1) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setParameters(new Object[]{param1});
        this.log(record);
    }

    public void log(TLevel level, TString msg, TThrowable thrown) {
        TLogRecord record = new TLogRecord(level, msg);
        record.setThrown(thrown);
        this.log(record);
    }

    public void severe(TString msg) {
        this.log(TLevel.SEVERE, msg);
    }

    public void warning(TString msg) {
        this.log(TLevel.WARNING, msg);
    }

    public void config(TString msg) {
        this.log(TLevel.CONFIG, msg);
    }

    public void fine(TString msg) {
        this.log(TLevel.FINE, msg);
    }

    public void finer(TString msg) {
        this.log(TLevel.FINER, msg);
    }

    public void finest(TString msg) {
        this.log(TLevel.FINEST, msg);
    }

    public boolean isLoggable(TLevel level) {
        return true;
    }

    public TString getName() {
        return this.name;
    }

    public TLogger getParent() {
        return this.parent;
    }

    public void setParent(TLogger parent) {
        this.parent = parent;
    }

    @GeneratedBy(value=LoggerNativeGenerator.class)
    public native void info(TString var1);

    @GeneratedBy(value=LoggerNativeGenerator.class)
    private native void warn(TString var1);

    @GeneratedBy(value=LoggerNativeGenerator.class)
    private native void error(TString var1);
}

