/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;

abstract class TCharBufferImpl
extends TCharBuffer {
    public TCharBufferImpl(int capacity, int position, int limit) {
        super(capacity, position, limit);
    }

    @Override
    public TCharBuffer slice() {
        return this.duplicate(this.position, this.limit - this.position, 0, this.limit - this.position, this.isReadOnly());
    }

    @Override
    public TCharBuffer duplicate() {
        return this.duplicate(0, this.capacity, this.position, this.limit, this.isReadOnly());
    }

    @Override
    public TCharBuffer asReadOnlyBuffer() {
        return this.duplicate(0, this.capacity, this.position, this.limit, true);
    }

    abstract TCharBuffer duplicate(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public char get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.getChar(this.position++);
    }

    @Override
    public TCharBuffer put(char c) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.putChar(this.position++, c);
        return this;
    }

    @Override
    public char get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        return this.getChar(index);
    }

    @Override
    public TCharBuffer put(int index, char b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        this.putChar(index, b);
        return this;
    }

    @Override
    public TCharBuffer compact() {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.position > 0) {
            int sz = this.remaining();
            int src = this.position;
            for (int i = 0; i < sz; ++i) {
                this.putChar(i, this.getChar(src++));
            }
            this.position = sz;
        }
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly();
    }

    abstract boolean readOnly();

    @Override
    public TCharBuffer subSequence(int start, int end) {
        return this.duplicate(0, this.capacity, this.position + start, this.position + end, this.isReadOnly());
    }
}

