/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.List;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.ArrayElementType;

public class AnnotationClassTransformer
implements ClassHolderTransformer {
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        MethodHolder readerMethod = new MethodHolder("$$__readAnnotations__$$", new ValueType[]{ValueType.parse(Annotation[].class)});
        readerMethod.setLevel(AccessLevel.PUBLIC);
        readerMethod.getModifiers().add(ElementModifier.STATIC);
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)readerMethod);
        ArrayList<AnnotationReader> annotations = new ArrayList<AnnotationReader>();
        for (AnnotationReader annot : cls.getAnnotations().all()) {
            AnnotationReader retention;
            String retentionPolicy;
            ClassReader annotType = innerSource.get(annot.getType());
            if (annotType == null || !(retentionPolicy = (retention = annotType.getAnnotations().get(Retention.class.getName())).getValue("value").getEnumValue().getFieldName()).equals("RUNTIME")) continue;
            annotations.add(annot);
        }
        ValueEmitter array = pe.constructArray(Annotation.class, annotations.size());
        for (int i = 0; i < annotations.size(); ++i) {
            array.unwrapArray(ArrayElementType.OBJECT).setElement(i, this.generateAnnotationInstance(innerSource, pe, (AnnotationReader)annotations.get(i)));
        }
        array.returnValue();
        cls.addMethod(readerMethod);
    }

    private ValueEmitter generateAnnotationInstance(ClassReaderSource classSource, ProgramEmitter pe, AnnotationReader annotation) {
        ClassReader annotationClass = classSource.get(annotation.getType());
        if (annotationClass == null) {
            return pe.constantNull();
        }
        String className = annotation.getType() + "$$_impl";
        ArrayList<Object> ctorSignature = new ArrayList<Object>();
        ArrayList<ValueEmitter> params = new ArrayList<ValueEmitter>();
        for (MethodReader methodDecl : annotationClass.getMethods()) {
            ctorSignature.add(methodDecl.getResultType());
            AnnotationValue value = annotation.getValue(methodDecl.getName());
            if (value == null) {
                value = methodDecl.getAnnotationDefault();
            }
            params.add(this.generateAnnotationValue(classSource, pe, methodDecl.getResultType(), value));
        }
        ctorSignature.add(ValueType.VOID);
        MethodReference ctor = new MethodReference(className, "<init>", ctorSignature.toArray(new ValueType[ctorSignature.size()]));
        return pe.construct(ctor, params.toArray(new ValueEmitter[params.size()]));
    }

    private ValueEmitter generateAnnotationValue(ClassReaderSource classSource, ProgramEmitter pe, ValueType type, AnnotationValue value) {
        switch (value.getType()) {
            case 0: {
                return pe.constant(value.getBoolean() ? 1 : 0);
            }
            case 1: {
                return pe.constant((int)value.getByte());
            }
            case 2: {
                return pe.constant((int)value.getShort());
            }
            case 3: {
                return pe.constant(value.getInt());
            }
            case 4: {
                return pe.constant(value.getLong());
            }
            case 5: {
                return pe.constant(value.getFloat());
            }
            case 6: {
                return pe.constant(value.getDouble());
            }
            case 7: {
                return pe.constant(value.getString());
            }
            case 9: {
                List list = value.getList();
                ValueType itemType = ((ValueType.Array)type).getItemType();
                ValueEmitter array = pe.constructArray(itemType, list.size());
                for (int i = 0; i < list.size(); ++i) {
                    array.unwrapArray(ArrayElementType.OBJECT).setElement(i, this.generateAnnotationValue(classSource, pe, itemType, (AnnotationValue)list.get(i)));
                }
                return array;
            }
            case 10: {
                pe.initClass(value.getEnumValue().getClassName());
                return pe.getField(value.getEnumValue(), type);
            }
            case 8: {
                return pe.constant(value.getJavaClass());
            }
            case 11: {
                return this.generateAnnotationInstance(classSource, pe, value.getAnnotation());
            }
        }
        throw new IllegalArgumentException("Unknown annotation value type: " + value.getType());
    }
}

